/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.Options;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.Pipe;

public class RemoteServer {
    private static final Options options = new Options(System.getProperties());
    public static final String SERVER_DEBUG_PORT = "server.debug.port";
    public static final String SERVER_SHUTDOWN_PORT = "server.shutdown.port";
    public static final String SERVER_SHUTDOWN_HOST = "server.shutdown.host";
    public static final String SERVER_SHUTDOWN_COMMAND = "server.shutdown.command";
    public static final String OPENEJB_SERVER_DEBUG = "openejb.server.debug";
    private boolean debug = options.get("openejb.server.debug", false);
    private final boolean profile = options.get("openejb.server.profile", false);
    private final boolean tomcat;
    private final String javaOpts = System.getProperty("java.opts");
    private String additionalClasspath = null;
    private boolean serverHasAlreadyBeenStarted = true;
    private Properties properties;
    private Process server;
    private final int tries;
    private final boolean verbose;
    private final int shutdownPort;
    private final String host;
    private final String command;
    private File home = null;
    static final List<Process> kill = new ArrayList<Process>();

    public RemoteServer() {
        this(options.get("connect.tries", 60), options.get("verbose", false));
    }

    public RemoteServer(int tries, boolean verbose) {
        this.tries = tries;
        this.verbose = verbose;
        this.home = this.getHome();
        this.tomcat = this.home != null && new File(new File(this.home, "bin"), "catalina.sh").exists();
        this.shutdownPort = options.get(SERVER_SHUTDOWN_PORT, this.tomcat ? 8005 : 4200);
        this.command = options.get(SERVER_SHUTDOWN_COMMAND, "SHUTDOWN");
        this.host = options.get(SERVER_SHUTDOWN_HOST, "localhost");
    }

    public void init(Properties props) {
        this.properties = props;
        props.put("java.naming.factory.initial", "org.apache.openejb.client.RemoteInitialContextFactory");
        int port = options.get("ejbd.port", 4201);
        props.put("java.naming.provider.url", options.get("java.naming.provider.url", "127.0.0.1:" + port));
        props.put("java.naming.security.principal", "testuser");
        props.put("java.naming.security.credentials", "testpassword");
    }

    public static void main(String[] args) {
        assert (args.length > 0) : "no arguments supplied: valid argumen -efts are 'start' or 'stop'";
        if (args[0].equalsIgnoreCase("start")) {
            new RemoteServer().start();
        } else if (args[0].equalsIgnoreCase("stop")) {
            RemoteServer remoteServer = new RemoteServer();
            remoteServer.serverHasAlreadyBeenStarted = false;
            remoteServer.stop();
        } else {
            throw new OpenEJBRuntimeException("valid arguments are 'start' or 'stop'");
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void destroy() {
        this.stop();
        if (this.server != null) {
            try {
                this.server.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void start() {
        this.start(Collections.<String>emptyList(), "start", true);
    }

    public void start(List<String> additionalArgs, String cmd, boolean checkPortAvailable) {
        this.cmd(additionalArgs, cmd, checkPortAvailable);
    }

    private void cmd(List<String> additionalArgs, String cmd, boolean checkPortAvailable) {
        boolean ok = true;
        if (checkPortAvailable) {
            boolean bl = ok = !this.connect();
        }
        if (ok) {
            try {
                Object[] args;
                if (this.verbose) {
                    System.out.println("[] " + cmd.toUpperCase() + " SERVER");
                }
                File home = this.getHome();
                String javaVersion = System.getProperty("java.version");
                if (this.verbose) {
                    System.out.println("OPENEJB_HOME = " + home.getAbsolutePath());
                    String systemInfo = "Java " + javaVersion + "; " + System.getProperty("os.name") + "/" + System.getProperty("os.version");
                    System.out.println("SYSTEM_INFO  = " + systemInfo);
                }
                this.serverHasAlreadyBeenStarted = false;
                File lib = new File(home, "lib");
                File webapplib = new File(new File(new File(home, "webapps"), "tomee"), "lib");
                File openejbJar = this.lib("openejb-core", lib, webapplib);
                File javaagentJar = this.lib("openejb-javaagent", lib, webapplib);
                boolean isWindows = System.getProperty("os.name", "unknown").toLowerCase().startsWith("windows");
                String java = isWindows && "start".equals(cmd) && options.get("server.windows.fork", false) ? new File(System.getProperty("java.home"), "bin/javaw").getAbsolutePath() : new File(System.getProperty("java.home"), "bin/java").getAbsolutePath();
                int debugPort = options.get(SERVER_DEBUG_PORT, 5005);
                if (!this.tomcat) {
                    args = this.debug ? new String[]{java, "-XX:+HeapDumpOnOutOfMemoryError", "-Xdebug", "-Xnoagent", "-Djava.compiler=NONE", "-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + debugPort, "-javaagent:" + javaagentJar.getAbsolutePath(), "-jar", openejbJar.getAbsolutePath(), "start"} : new String[]{java, "-XX:+HeapDumpOnOutOfMemoryError", "-javaagent:" + javaagentJar.getAbsolutePath(), "-jar", openejbJar.getAbsolutePath(), "start"};
                } else {
                    File bin = new File(home, "bin");
                    File tlib = new File(home, "lib");
                    File bootstrapJar = new File(bin, "bootstrap.jar");
                    File juliJar = new File(bin, "tomcat-juli.jar");
                    File commonsLoggingJar = new File(bin, "commons-logging-api.jar");
                    File conf = new File(home, "conf");
                    File loggingProperties = new File(conf, "logging.properties");
                    File endorsed = new File(home, "endorsed");
                    File temp = new File(home, "temp");
                    ArrayList<String> argsList = new ArrayList<String>();
                    argsList.add(java);
                    argsList.add("-XX:+HeapDumpOnOutOfMemoryError");
                    if (this.debug) {
                        argsList.add("-Xdebug");
                        argsList.add("-Xnoagent");
                        argsList.add("-Djava.compiler=NONE");
                        argsList.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + debugPort);
                    }
                    if (this.profile) {
                        String yourkitHome = options.get("yourkit.home", "/Applications/YourKit_Java_Profiler_9.5.6.app/bin/mac/");
                        if (!yourkitHome.endsWith("/")) {
                            yourkitHome = yourkitHome + "/";
                        }
                        String yourkitOpts = options.get("yourkit.opts", "disablestacktelemetry,disableexceptiontelemetry,builtinprobes=none,delay=10000,sessionname=Tomcat");
                        argsList.add("-agentpath:" + yourkitHome + "libyjpagent.jnilib=" + yourkitOpts);
                    }
                    if (this.javaOpts != null) {
                        Collections.addAll(argsList, this.javaOpts.split(" +"));
                    }
                    HashMap<String, String> addedArgs = new HashMap<String, String>();
                    if (additionalArgs != null) {
                        for (String arg : additionalArgs) {
                            String[] values = arg.split("=");
                            if (values.length == 1) {
                                addedArgs.put(values[0], "null");
                            } else {
                                addedArgs.put(values[0], values[1]);
                            }
                            argsList.add(arg);
                        }
                    }
                    argsList.add("-javaagent:" + javaagentJar.getAbsolutePath());
                    if (!addedArgs.containsKey("-Dcom.sun.management.jmxremote")) {
                        argsList.add("-Dcom.sun.management.jmxremote");
                    }
                    if (!addedArgs.containsKey("-Djava.util.logging.manager")) {
                        argsList.add("-Djava.util.logging.manager=org.apache.juli.ClassLoaderLogManager");
                    }
                    if (!addedArgs.containsKey("-Djava.util.logging.config.file") && loggingProperties.exists()) {
                        argsList.add("-Djava.util.logging.config.file=" + loggingProperties.getAbsolutePath());
                    }
                    if (!addedArgs.containsKey("-Djava.io.tmpdir")) {
                        argsList.add("-Djava.io.tmpdir=" + temp.getAbsolutePath());
                    }
                    if (!addedArgs.containsKey("-Djava.endorsed.dirs")) {
                        argsList.add("-Djava.endorsed.dirs=" + endorsed.getAbsolutePath());
                    }
                    if (!addedArgs.containsKey("-Dcatalina.base")) {
                        argsList.add("-Dcatalina.base=" + home.getAbsolutePath());
                    }
                    if (!addedArgs.containsKey("-Dcatalina.home")) {
                        argsList.add("-Dcatalina.home=" + home.getAbsolutePath());
                    }
                    if (!addedArgs.containsKey("-Dcatalina.ext.dirs")) {
                        argsList.add("-Dcatalina.ext.dirs=" + tlib.getAbsolutePath());
                    }
                    if (!addedArgs.containsKey("-Dorg.apache.catalina.STRICT_SERVLET_COMPLIANCE")) {
                        argsList.add("-Dorg.apache.catalina.STRICT_SERVLET_COMPLIANCE=true");
                    }
                    if (!addedArgs.containsKey("-Dorg.apache.tomcat.util.http.ServerCookie.ALLOW_HTTP_SEPARATORS_IN_V0")) {
                        argsList.add("-Dorg.apache.tomcat.util.http.ServerCookie.ALLOW_HTTP_SEPARATORS_IN_V0=true");
                    }
                    if (addedArgs.isEmpty()) {
                        this.addIfSet(argsList, "javax.net.ssl.keyStore");
                        this.addIfSet(argsList, "javax.net.ssl.keyStorePassword");
                        this.addIfSet(argsList, "javax.net.ssl.trustStore");
                        this.addIfSet(argsList, "java.protocol.handler.pkgs");
                    }
                    argsList.add("-ea");
                    argsList.add("-classpath");
                    String ps = File.pathSeparator;
                    StringBuilder cp = new StringBuilder(bootstrapJar.getAbsolutePath()).append(ps).append(juliJar.getAbsolutePath());
                    if (commonsLoggingJar.exists()) {
                        cp.append(ps).append(commonsLoggingJar.getAbsolutePath());
                    }
                    if (this.additionalClasspath != null) {
                        cp.append(ps).append(this.additionalClasspath);
                    }
                    argsList.add(cp.toString());
                    argsList.add("org.apache.catalina.startup.Bootstrap");
                    if (cmd == null) {
                        argsList.add("start");
                    } else {
                        argsList.add(cmd);
                    }
                    args = argsList.toArray(new String[argsList.size()]);
                }
                if (this.verbose) {
                    System.out.println(Join.join("\n", args));
                }
                Process process = Runtime.getRuntime().exec((String[])args);
                if (this.tomcat) {
                    Pipe.pipeOut(process);
                } else {
                    Pipe.pipe(process);
                }
                if ("start".equals(cmd)) {
                    this.server = process;
                } else if ("stop".equals(cmd) && this.server != null) {
                    this.server.waitFor();
                }
            }
            catch (Exception e) {
                throw (RuntimeException)new OpenEJBRuntimeException("Cannot start the server.  Exception: " + e.getClass().getName() + ": " + e.getMessage()).initCause(e);
            }
            if (checkPortAvailable && (this.debug ? !this.connect(Integer.MAX_VALUE) : !this.connect(this.tries))) {
                throw new OpenEJBRuntimeException("Could not connect to server");
            }
        } else if (this.verbose) {
            System.out.println("[] FOUND STARTED SERVER");
        }
    }

    private void kill3UNIXDebug() {
        Thread t = new Thread(){

            @Override
            public void run() {
                this.setName("[DEBUG] Dump Observer");
                boolean end = false;
                int i = 0;
                while (!end) {
                    try {
                        if (RemoteServer.this.server == null) {
                            throw new IllegalThreadStateException();
                        }
                        RemoteServer.this.server.exitValue();
                        end = true;
                    }
                    catch (IllegalThreadStateException e) {
                        ++i;
                        try {
                            Thread.sleep(Integer.getInteger("sleep", 300000).intValue());
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                        if (i != 5) continue;
                        RemoteServer.this.kill3UNIX();
                        i = 0;
                    }
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public void kill3UNIX() {
        if (System.getProperty("os.name", "unknown").toLowerCase().startsWith("windows")) {
            return;
        }
        try {
            Field f = this.server.getClass().getDeclaredField("pid");
            f.setAccessible(true);
            int pid = (Integer)f.get(this.server);
            Pipe.pipe(Runtime.getRuntime().exec("kill -3 " + pid));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private File lib(String name, File ... dirs) {
        for (File dir : dirs) {
            File[] files = dir.listFiles();
            if (files == null) continue;
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".jar") || !file.getName().startsWith(name)) continue;
                return file;
            }
        }
        for (File dir : dirs) {
            RemoteServer.dumpLibs(dir);
        }
        throw new IllegalStateException("Cannot find the " + name + " jar");
    }

    private static void dumpLibs(File dir) {
        if (!dir.exists()) {
            System.out.println("lib dir doesn't exist");
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File lib : files) {
                System.out.println(lib.getAbsolutePath());
            }
        }
    }

    public Process getServer() {
        return this.server;
    }

    private void addIfSet(List<String> argsList, String key) {
        if (System.getProperties().containsKey(key)) {
            argsList.add("-D" + key + "=" + System.getProperty(key));
        }
    }

    private File getHome() {
        if (this.home != null) {
            return this.home;
        }
        String openejbHome = System.getProperty("openejb.home");
        if (openejbHome != null) {
            this.home = new File(openejbHome);
        }
        return this.home;
    }

    public void stop() {
        block3: {
            if (!this.serverHasAlreadyBeenStarted) {
                try {
                    this.shutdown();
                }
                catch (Exception e) {
                    if (!this.verbose) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    public void forceStop() throws Exception {
        this.shutdown();
        this.waitForServerShutdown();
    }

    private void waitForServerShutdown() throws InterruptedException {
        if (this.verbose) {
            System.out.print("Waiting for TomEE shutdown.");
        }
        while (this.connect()) {
            Thread.sleep(1000L);
            if (!this.verbose) continue;
            System.out.print(".");
        }
        if (this.verbose) {
            System.out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() throws Exception {
        Socket socket = null;
        OutputStream stream = null;
        try {
            socket = new Socket(this.host, this.shutdownPort);
            stream = socket.getOutputStream();
            String shutdown = this.command + Character.toString('\u0000');
            for (int i = 0; i < shutdown.length(); ++i) {
                stream.write(shutdown.charAt(i));
            }
            stream.flush();
        }
        catch (Throwable throwable) {
            IO.close(stream);
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        IO.close(stream);
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean connect() {
        return this.connect(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connect(int tries) {
        if (this.verbose) {
            System.out.println("[] CONNECT ATTEMPT " + (this.tries - tries));
        }
        Socket s = null;
        try {
            s = new Socket();
            s.connect(new InetSocketAddress(this.host, this.shutdownPort), 1000);
            s.getOutputStream().close();
            if (this.verbose) {
                System.out.println("[] CONNECTED IN " + (this.tries - tries));
            }
        }
        catch (Exception e) {
            if (tries < 2) {
                if (this.verbose) {
                    System.out.println("[] CONNECT ATTEMPTS FAILED ( " + (this.tries - tries) + " tries)");
                }
                boolean bl = false;
                return bl;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e2) {
                e.printStackTrace();
            }
            boolean bl = this.connect(--tries);
            return bl;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception ignored) {}
            }
        }
        return true;
    }

    public void setAdditionalClasspath(String additionalClasspath) {
        this.additionalClasspath = additionalClasspath;
    }

    public void killOnExit() {
        if (!this.serverHasAlreadyBeenStarted && kill.contains(this.server)) {
            return;
        }
        kill.add(this.server);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (Process server : kill) {
                    try {
                        if (server == null) continue;
                        server.destroy();
                        server.waitFor();
                    }
                    catch (Throwable throwable) {}
                }
            }
        });
    }
}

