/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.log;

import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.loader.SystemInstance;

public class LoggerCreator
implements Callable<Logger> {
    private final String name;
    private Logger logger;
    private volatile boolean init = false;

    public LoggerCreator(String channel) {
        this.name = channel;
        Properties p = SystemInstance.get().getProperties();
        String levelName = p.getProperty("logging.level." + channel);
        if (levelName != null) {
            try {
                this.call();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Logger call() throws Exception {
        if (this.logger == null) {
            LoggerCreator loggerCreator = this;
            synchronized (loggerCreator) {
                if (this.logger == null) {
                    try {
                        this.logger = Logger.getLogger(this.name);
                    }
                    catch (Exception e) {
                        this.logger = Logger.getLogger(this.name);
                    }
                    Properties p = SystemInstance.get().getProperties();
                    String levelName = p.getProperty("logging.level." + this.logger.getName());
                    if (levelName != null) {
                        Level level = Level.parse(levelName);
                        for (Handler handler : this.logger.getHandlers()) {
                            handler.setLevel(level);
                        }
                    }
                }
            }
        }
        return this.logger;
    }

    public boolean isInit() {
        return this.init;
    }

    public static final class Get {
        private Get() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Logger exec(LoggerCreator creator) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(ParentClassLoaderFinder.Helper.get());
            try {
                Logger logger = creator.call();
                return logger;
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger("default");
                return logger;
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }

        public static Logger exec(LoggerCreator logger, AtomicBoolean debug, AtomicBoolean info) {
            Logger l = Get.exec(logger);
            if (!logger.init) {
                Get.levels(logger, debug, info);
            }
            return l;
        }

        public static void levels(LoggerCreator lc, AtomicBoolean debug, AtomicBoolean info) {
            Logger l;
            if (lc.init) {
                return;
            }
            try {
                l = lc.call();
            }
            catch (Exception e) {
                return;
            }
            debug.set(l.isLoggable(Level.FINE));
            info.set(l.isLoggable(Level.INFO));
            lc.init = true;
        }
    }
}

