/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.observer.event.ObserverAdded;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.OpenEjbVersion;

public class UpdateChecker {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB_STARTUP, UpdateChecker.class);
    private static final String TOMEE_ARTIFACT = "apache-tomee";
    private String repoUrl = SystemInstance.get().getOptions().get("openejb.version.check.repo.url", "http://repo1.maven.org/maven2/");
    private String groupId = "org/apache/openejb/";
    private String metadata = "/maven-metadata.xml";
    private String checkerProxy = SystemInstance.get().getOptions().get("openejb.version.check.proxy", (String)null);
    private String auto = "auto";
    private String url = SystemInstance.get().getOptions().get("openejb.version.check.url", this.auto);
    private String tag = "release";
    private String undefined = "undefined";
    private String latest = "undefined";
    private String current = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(@Observes ObserverAdded event) {
        String realUrl;
        if (event.getObserver() != this) {
            return;
        }
        String originalProxyHost = null;
        String originalProxyPort = null;
        String originalProxyUser = null;
        String originalProxyPwd = null;
        String proxyProtocol = null;
        if (this.checkerProxy != null) {
            try {
                URL proxyUrl = new URL(this.checkerProxy);
                proxyProtocol = proxyUrl.getProtocol();
                originalProxyHost = System.getProperty(proxyProtocol + ".proxyHost");
                originalProxyPort = System.getProperty(proxyProtocol + ".proxyPort");
                originalProxyUser = System.getProperty(proxyProtocol + ".proxyUser");
                originalProxyPwd = System.getProperty(proxyProtocol + ".proxyPassword");
                System.setProperty(proxyProtocol + ".proxyHost", proxyUrl.getHost());
                System.setProperty(proxyProtocol + ".proxyPort", Integer.toString(proxyUrl.getPort()));
                String userInfo = proxyUrl.getUserInfo();
                if (userInfo != null) {
                    int sep = userInfo.indexOf(":");
                    if (sep >= 0) {
                        System.setProperty(proxyProtocol + ".proxyUser", userInfo.substring(0, sep));
                        System.setProperty(proxyProtocol + ".proxyPassword", userInfo.substring(sep + 1));
                    } else {
                        System.setProperty(proxyProtocol + ".proxyUser", userInfo);
                    }
                }
            }
            catch (MalformedURLException e) {
                this.checkerProxy = null;
            }
        }
        if ("auto".equals(realUrl = this.url)) {
            realUrl = this.repoUrl + this.groupId + UpdateChecker.artifact() + this.metadata;
        }
        try {
            URL url = new URL(realUrl);
            String metaData = IO.slurp(url);
            this.latest = this.extractLatest(metaData);
            if (!this.usesLatest()) {
                LOGGER.warning(this.message());
            }
        }
        catch (Exception e) {
            LOGGER.warning("can't check the version: " + e.getMessage());
        }
        finally {
            if (proxyProtocol != null) {
                UpdateChecker.resetSystemProp(proxyProtocol + ".proxyHost", originalProxyHost);
                UpdateChecker.resetSystemProp(proxyProtocol + ".proxyPort", originalProxyPort);
                UpdateChecker.resetSystemProp(proxyProtocol + ".proxyUser", originalProxyUser);
                UpdateChecker.resetSystemProp(proxyProtocol + ".proxyPassword", originalProxyPwd);
            }
        }
    }

    private static String artifact() {
        try {
            UpdateChecker.class.getClassLoader().loadClass("org.apache.tomee.catalina.TomcatWebAppBuilder");
            return TOMEE_ARTIFACT;
        }
        catch (ClassNotFoundException e) {
            return "openejb";
        }
    }

    private static void resetSystemProp(String key, String value) {
        if (value == null) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, value);
        }
    }

    private String extractLatest(String metaData) {
        if (metaData != null) {
            boolean found = false;
            for (String s : metaData.replace(">", ">\n").split("\n")) {
                if (found) {
                    return this.trim(s).replace("</" + this.tag + ">", "");
                }
                if (s.isEmpty() || !this.trim(s).endsWith("<" + this.tag + ">")) continue;
                found = true;
            }
        }
        return this.undefined;
    }

    private String trim(String s) {
        return s.replace("\t", "").replace(" ", "");
    }

    public boolean usesLatest() {
        InputStream is;
        if (UpdateChecker.artifact().contains(TOMEE_ARTIFACT) && (is = this.getClass().getClassLoader().getResourceAsStream("META-INF/maven/org.apache.openejb/tomee-catalina/pom.properties")) != null) {
            Properties prop = new Properties();
            try {
                prop.load(is);
                this.current = prop.getProperty("version");
            }
            catch (IOException e) {
                LOGGER.error("can't get tomee version, will use openejb one");
            }
        }
        if (this.current == null) {
            this.current = OpenEjbVersion.get().getVersion();
        }
        return this.current.equals(this.latest);
    }

    public String message() {
        if (this.undefined.equals(this.latest)) {
            return "can't determine the latest version";
        }
        if (this.current.equals(this.latest)) {
            return "running on the latest version";
        }
        return "you are using the version " + this.current + ", our latest stable version " + this.latest + " is available on " + this.repoUrl;
    }

    public void setRepoUrl(String repoUrl) {
        this.repoUrl = repoUrl;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public void setCheckerProxy(String checkerProxy) {
        this.checkerProxy = checkerProxy;
    }

    public void setAuto(String auto) {
        this.auto = auto;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setUndefined(String undefined) {
        this.undefined = undefined;
    }

    public void setLatest(String latest) {
        this.latest = latest;
    }
}

