/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf;

import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.naming.Context;
import org.apache.cxf.Bus;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.openejb.BeanContext;
import org.apache.openejb.assembler.classic.util.ServiceConfiguration;
import org.apache.openejb.core.webservices.PortData;
import org.apache.openejb.server.cxf.CxfCatalogUtils;
import org.apache.openejb.server.cxf.CxfWsContainer;
import org.apache.openejb.server.cxf.client.SaajInterceptor;
import org.apache.openejb.server.cxf.ejb.EjbWsContainer;
import org.apache.openejb.server.cxf.pojo.PojoWsContainer;
import org.apache.openejb.server.cxf.transport.HttpTransportFactory;
import org.apache.openejb.server.cxf.transport.util.CxfUtil;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.webservices.WsService;

public class CxfService
extends WsService {
    public static final String OPENEJB_JAXWS_CXF_FEATURES = "features";
    private final Map<String, CxfWsContainer> wsContainers = new TreeMap<String, CxfWsContainer>();
    private HttpTransportFactory httpTransportFactory;

    public String getName() {
        return "cxf";
    }

    public void init(Properties props) throws Exception {
        super.init(props);
        CxfUtil.configureBus();
        SaajInterceptor.registerInterceptors();
        this.initBusTransport(CxfUtil.getBus());
    }

    private void initBusTransport(Bus bus) {
        this.httpTransportFactory = new HttpTransportFactory(bus);
        ArrayList<String> ids = new ArrayList<String>(this.httpTransportFactory.getTransportIds().size() + 1);
        ids.addAll(this.httpTransportFactory.getTransportIds());
        ids.add("http://schemas.xmlsoap.org/wsdl/soap/");
        this.httpTransportFactory.setTransportIds(ids);
    }

    protected void setWsdl(HttpListener listener, String wsdl) {
        if (CxfWsContainer.class.isInstance(listener)) {
            ((CxfWsContainer)CxfWsContainer.class.cast(listener)).setWsldUrl(wsdl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpListener createEjbWsContainer(URL moduleBaseUrl, PortData port, BeanContext beanContext, ServiceConfiguration config) {
        Bus bus = CxfUtil.getBus();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
        try {
            CxfCatalogUtils.loadOASISCatalog(bus, moduleBaseUrl, "META-INF/jax-ws-catalog.xml");
            EjbWsContainer container = new EjbWsContainer(bus, (HTTPTransportFactory)this.httpTransportFactory, port, beanContext, config);
            container.start();
            this.wsContainers.put(beanContext.getDeploymentID().toString(), container);
            EjbWsContainer ejbWsContainer = container;
            return ejbWsContainer;
        }
        finally {
            if (oldLoader != null) {
                CxfUtil.clearBusLoader((ClassLoader)oldLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpListener createPojoWsContainer(ClassLoader loader, URL moduleBaseUrl, PortData port, String serviceId, Class target, Context context, String contextRoot, Map<String, Object> bdgs, ServiceConfiguration services) {
        Bus bus = CxfUtil.getBus();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
        try {
            CxfCatalogUtils.loadOASISCatalog(bus, moduleBaseUrl, "META-INF/jax-ws-catalog.xml");
            PojoWsContainer container = new PojoWsContainer(loader, (HTTPTransportFactory)this.httpTransportFactory, bus, port, context, target, bdgs, services);
            container.start();
            this.wsContainers.put(serviceId, container);
            PojoWsContainer pojoWsContainer = container;
            return pojoWsContainer;
        }
        finally {
            if (oldLoader != null) {
                CxfUtil.clearBusLoader((ClassLoader)oldLoader);
            }
        }
    }

    protected void destroyPojoWsContainer(String serviceId) {
        this.destroyWsContainer(serviceId);
    }

    protected void destroyEjbWsContainer(String deploymentId) {
        this.destroyWsContainer(deploymentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyWsContainer(String serviceId) {
        CxfWsContainer container = this.wsContainers.remove(serviceId);
        if (container != null) {
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
            try {
                container.destroy();
            }
            finally {
                if (oldLoader != null) {
                    CxfUtil.clearBusLoader((ClassLoader)oldLoader);
                }
            }
        }
    }
}

