/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

class ContextFinder {
    private static final String PLATFORM_DEFAULT_FACTORY_CLASS = "com.sun.xml.bind.v2.ContextFactory";
    private static final String JAXB_CONTEXT_PROPERTY = JAXBContext.class.getName();
    private static final String JAXB_CONTEXT_FACTORY = "javax.xml.bind.context.factory";
    private static Class<?> osgiLocator;
    private static Method getServiceClassMethod;
    private static Method loadClassMethod;

    ContextFinder() {
    }

    public static JAXBContext find(String contextPath, ClassLoader classLoader, Map properties) throws JAXBException {
        String pkg;
        String url;
        String[] packages;
        if ((contextPath = contextPath.trim()).length() == 0 || contextPath.equals(":")) {
            throw new JAXBException("Invalid contextPath");
        }
        String className = null;
        String[] arr$ = packages = contextPath.split("[:]");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (className = ContextFinder.loadClassNameFromProperties(url = (pkg = arr$[i$]).replace('.', '/') + "/jaxb.properties", classLoader)) == null; ++i$) {
        }
        if (className == null) {
            className = System.getProperty(JAXB_CONTEXT_PROPERTY);
        }
        Class spi = null;
        if (className == null) {
            spi = ContextFinder.loadSPIClass(JAXBContext.class, classLoader);
            if (spi == null) {
                spi = ContextFinder.loadSpi(PLATFORM_DEFAULT_FACTORY_CLASS, classLoader);
            }
        } else {
            spi = ContextFinder.loadSpi(className, classLoader);
        }
        try {
            Method m = spi.getMethod("createContext", String.class, ClassLoader.class, Map.class);
            return (JAXBContext)m.invoke(null, contextPath, classLoader, properties);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Throwable t) {
            throw new JAXBException("Unable to create context", t);
        }
        try {
            Method m = spi.getMethod("createContext", String.class, ClassLoader.class);
            return (JAXBContext)m.invoke(null, contextPath, classLoader);
        }
        catch (Throwable t) {
            throw new JAXBException("Unable to create context", t);
        }
    }

    public static JAXBContext find(Class[] classes, Map properties) throws JAXBException {
        String url;
        Class cl;
        Package pkg;
        String className = null;
        Class[] arr$ = classes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && ((pkg = (cl = arr$[i$]).getPackage()) == null || (className = ContextFinder.loadClassNameFromProperties(url = pkg.getName().replace('.', '/') + "/jaxb.properties", cl.getClassLoader())) == null); ++i$) {
        }
        if (className == null) {
            className = System.getProperty(JAXB_CONTEXT_PROPERTY);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class spi = null;
        if (className == null) {
            spi = ContextFinder.loadSPIClass(JAXBContext.class, classLoader);
            if (spi == null) {
                spi = ContextFinder.loadSpi(PLATFORM_DEFAULT_FACTORY_CLASS, classLoader);
            }
        } else {
            spi = ContextFinder.loadSpi(className, classLoader);
        }
        try {
            Method m = spi.getMethod("createContext", Class[].class, Map.class);
            return (JAXBContext)m.invoke(null, classes, properties);
        }
        catch (Throwable t) {
            throw new JAXBException("Unable to create context", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String loadClassNameFromProperties(String url, ClassLoader classLoader) throws JAXBException {
        String string;
        InputStream is = classLoader != null ? classLoader.getResourceAsStream(url) : ClassLoader.getSystemResourceAsStream(url);
        if (is == null) return null;
        try {
            Properties props = new Properties();
            props.load(is);
            String className = props.getProperty(JAXB_CONTEXT_FACTORY);
            if (className == null) {
                throw new JAXBException("jaxb.properties file " + url + " should contain a " + JAXB_CONTEXT_FACTORY + " property");
            }
            string = className.trim();
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new JAXBException(e);
            }
        }
        is.close();
        return string;
    }

    private static Class<?> loadSPIClass(Class<?> iface, ClassLoader classLoader) throws JAXBException {
        if (osgiLocator != null) {
            return ContextFinder.loadSPIClassFromOSGi(iface, classLoader);
        }
        try {
            return ContextFinder.locateServiceClass(iface.getName(), ContextFinder.class, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new JAXBException("Provider " + iface.getName() + " not found", e);
        }
    }

    private static Class<?> locateServiceClass(String iface, Class<?> contextClass, ClassLoader loader) throws ClassNotFoundException {
        String className = ContextFinder.locateServiceClassName(iface, contextClass, loader);
        if (className == null) {
            return null;
        }
        return ContextFinder.loadClass(className, contextClass, loader);
    }

    private static String locateServiceClassName(String iface, Class<?> contextClass, ClassLoader loader) {
        String name = ContextFinder.locateServiceClassName(iface, loader);
        if (name != null) {
            return name;
        }
        if (contextClass != null && (name = ContextFinder.locateServiceClassName(iface, contextClass.getClassLoader())) != null) {
            return name;
        }
        return null;
    }

    private static String locateServiceClassName(String iface, ClassLoader loader) {
        if (loader != null) {
            try {
                String service = "META-INF/services/" + iface;
                Enumeration<URL> providers = loader.getResources(service);
                while (providers.hasMoreElements()) {
                    List<String> providerNames = ContextFinder.parseServiceDefinition(providers.nextElement());
                    if (providerNames.isEmpty()) continue;
                    return providerNames.get(0);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Class<?> loadClass(String className, Class<?> contextClass, ClassLoader loader) throws ClassNotFoundException {
        if (loader != null) {
            try {
                return loader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (contextClass != null) {
            loader = contextClass.getClassLoader();
        }
        return Class.forName(className, true, loader);
    }

    private static Collection<String> locateServiceClassNames(String iface, Class<?> contextClass, ClassLoader loader) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        ContextFinder.locateServiceClassNames(iface, loader, names);
        if (contextClass != null) {
            ContextFinder.locateServiceClassNames(iface, contextClass.getClassLoader(), names);
        }
        return names;
    }

    static void locateServiceClassNames(String iface, ClassLoader loader, Set names) {
        if (loader != null) {
            try {
                String service = "META-INF/services/" + iface;
                Enumeration<URL> providers = loader.getResources(service);
                while (providers.hasMoreElements()) {
                    List<String> providerNames = ContextFinder.parseServiceDefinition(providers.nextElement());
                    names.addAll(providerNames);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static List<String> parseServiceDefinition(URL u) {
        String url = u.toString();
        ArrayList<String> classes = new ArrayList<String>();
        if (url.endsWith("/")) {
            return classes;
        }
        String providerId = url.substring(url.lastIndexOf("/") + 1);
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(u.openStream(), "UTF-8"));
            String line = br.readLine();
            while (line != null) {
                int comment = line.indexOf(35);
                if (comment != -1) {
                    line = line.substring(0, comment);
                }
                if ((line = line.trim()).length() > 0) {
                    classes.add(line);
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return classes;
    }

    private static Class loadSpi(String className, ClassLoader classLoader) throws JAXBException {
        if (osgiLocator != null) {
            return ContextFinder.loadSpiFromOSGi(className, classLoader);
        }
        try {
            return ContextFinder.loadClass(className, ContextFinder.class, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new JAXBException("Provider " + className + " not found", e);
        }
    }

    private static Class<?> loadSPIClassFromOSGi(Class<?> iface, ClassLoader classLoader) throws JAXBException {
        try {
            return (Class)getServiceClassMethod.invoke(null, iface.getName(), ContextFinder.class, classLoader);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Class loadSpiFromOSGi(String className, ClassLoader classLoader) throws JAXBException {
        try {
            return (Class)loadClassMethod.invoke(null, className, ContextFinder.class, classLoader);
        }
        catch (Exception e) {
            throw new JAXBException("Provider " + className + " not found", e);
        }
    }

    static {
        try {
            osgiLocator = Thread.currentThread().getContextClassLoader().loadClass("org.apache.geronimo.osgi.locator.ProviderLocator");
            getServiceClassMethod = osgiLocator.getMethod("getServiceClass", String.class, Class.class, ClassLoader.class);
            loadClassMethod = osgiLocator.getMethod("loadClass", String.class, Class.class, ClassLoader.class);
        }
        catch (Exception e) {
            osgiLocator = null;
        }
        catch (NoClassDefFoundError ncdfe) {
            osgiLocator = null;
        }
    }
}

