/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.client.CommandParser;
import org.apache.openejb.client.Connection;
import org.apache.openejb.client.ConnectionManager;
import org.apache.openejb.client.MulticastConnectionFactory;
import org.apache.openejb.client.Options;
import sun.net.util.IPAddressUtil;

public class MulticastPulseClient
extends MulticastConnectionFactory {
    public static final String ORG_APACHE_OPENEJB_MULTIPULSE_TTL = "org.apache.openejb.multipulse.ttl";
    public static final String ORG_APACHE_OPENEJB_MULTIPULSE_URI_LIMIT = "org.apache.openejb.multipulse.uri.limit";
    private static final Logger log = Logger.getLogger("OpenEJB.client");
    private static final String SERVER = "OpenEJB.MCP.Server:";
    private static final String CLIENT = "OpenEJB.MCP.Client:";
    private static final String BADURI = ":BadUri:";
    private static final String EMPTY = "NoService";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final int TTL = Integer.parseInt(System.getProperty("org.apache.openejb.multipulse.ttl", "32"));
    private static final int LIMIT = Integer.parseInt(System.getProperty("org.apache.openejb.multipulse.uri.limit", "50000"));
    private static final Map<URI, Set<URI>> knownUris = new HashMap<URI, Set<URI>>();
    private static NetworkInterface[] interfaces = MulticastPulseClient.getNetworkInterfaces();
    private static ExecutorService executor = null;
    private static final CommandParser cmd = new CommandParser(){

        @Override
        protected void init() {
            this.category("Options");
            this.opt('g', "group").type(String.class).value("*").description("Group name");
            this.opt('h', "host").type(String.class).value("239.255.3.2").description("Multicast address");
            this.opt('p', "port").type(Integer.TYPE).value(6142).description("Multicast port");
            this.opt('t', "timeout").type(Integer.TYPE).value(1000).description("Pulse back timeout");
        }

        @Override
        protected List<String> validate(CommandParser.Arguments arguments) {
            return super.validate(arguments);
        }

        @Override
        protected List<String> usage() {
            return super.usage();
        }
    };

    private static synchronized NetworkInterface[] getInterfaces() {
        if (null == interfaces) {
            interfaces = MulticastPulseClient.getNetworkInterfaces();
        }
        return interfaces;
    }

    private static synchronized ExecutorService getExecutorService() {
        if (null == executor) {
            int length = MulticastPulseClient.getInterfaces().length;
            if (length < 1) {
                length = 1;
            }
            executor = Executors.newFixedThreadPool(length * 2);
        }
        return executor;
    }

    @Override
    public Connection getConnection(URI uri) throws IOException {
        if (knownUris.size() >= LIMIT) {
            throw new IllegalArgumentException("Unique MultiPulse URI limit of " + LIMIT + " reached. Increase using the system property '" + ORG_APACHE_OPENEJB_MULTIPULSE_URI_LIMIT + "'");
        }
        Set<URI> uriSet = knownUris.get(uri);
        if (null == uriSet || uriSet.isEmpty()) {
            Map<String, String> params = MulticastPulseClient.getUriParameters(uri);
            Set<String> schemes = MulticastPulseClient.getSet(params, "schemes", this.getDefaultSchemes());
            String group = MulticastPulseClient.getString(params, "group", "default");
            long timeout = MulticastPulseClient.getLong(params, "timeout", 250L);
            try {
                uriSet = MulticastPulseClient.discoverURIs(group, schemes, uri.getHost(), uri.getPort(), timeout);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to find an ejb server via the MultiPulse URI: " + uri);
            }
            knownUris.put(uri, uriSet);
        }
        for (URI serviceURI : uriSet) {
            URI tryUri = URI.create(URI.create(serviceURI.getSchemeSpecificPart()).getSchemeSpecificPart());
            try {
                return ConnectionManager.getConnection(tryUri);
            }
            catch (Exception e) {
                uriSet.remove(serviceURI);
                if (SocketTimeoutException.class.isInstance(e) || SocketException.class.isInstance(e)) {
                    MulticastPulseClient.broadcastBadUri(MulticastPulseClient.getString(MulticastPulseClient.getUriParameters(uri), "group", "default"), tryUri, uri.getHost(), uri.getPort());
                }
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("Failed connection to: " + serviceURI);
            }
        }
        throw new IOException("Unable to connect an ejb server via the MultiPulse URI: " + uri);
    }

    private static Map<String, String> getUriParameters(URI uri) {
        Map<String, String> params;
        try {
            params = MulticastConnectionFactory.URIs.parseParamters(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid MultiPulse uri " + uri.toString(), e);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static Set<URI> discoverURIs(final String forGroup, final Set<String> schemes, String host, int port, long timeout) throws Exception {
        if (timeout < 50L) {
            timeout = 50L;
        }
        if (null == forGroup || forGroup.isEmpty()) {
            throw new Exception("Specify a valid group or *");
        }
        if (null == schemes || schemes.isEmpty()) {
            throw new Exception("Specify at least one scheme, 'ejbd' for example");
        }
        if (null == host || host.isEmpty()) {
            throw new Exception("Specify a valid host name");
        }
        if (port < 1 || port > 65535) {
            throw new Exception("Specify a valid port between 1 and 65535");
        }
        final InetAddress ia = MulticastPulseClient.getAddress(host);
        byte[] bytes = (CLIENT + forGroup).getBytes(UTF8);
        final DatagramPacket request = new DatagramPacket(bytes, bytes.length, new InetSocketAddress(ia, port));
        final AtomicBoolean running = new AtomicBoolean(true);
        final List<Future<?>> futures = Collections.synchronizedList(new ArrayList());
        MulticastSocket[] clientSockets = null;
        try {
            void var19_23;
            final MulticastSocket[] clientSocketsFinal = clientSockets = MulticastPulseClient.getSockets(ia, port);
            Timer timer = new Timer(true);
            final TreeSet<URI> set = new TreeSet<URI>(new Comparator<URI>(){

                @Override
                public int compare(URI uri1, URI uri2) {
                    URI u1 = URI.create(uri1.getSchemeSpecificPart());
                    URI u2 = URI.create(uri2.getSchemeSpecificPart());
                    u1 = URI.create(u1.getSchemeSpecificPart());
                    u2 = URI.create(u2.getSchemeSpecificPart());
                    int i = this.compare(u1.getHost(), u2.getHost());
                    if (i != 0) {
                        i = uri1.compareTo(uri2);
                    }
                    return i;
                }

                @Override
                private int compare(String h1, String h2) {
                    try {
                        if (IPAddressUtil.isIPv4LiteralAddress(h1)) {
                            if (IPAddressUtil.isIPv6LiteralAddress(h2.replace("[", "").replace("]", ""))) {
                                return -1;
                            }
                        } else if (IPAddressUtil.isIPv6LiteralAddress(h1.replace("[", "").replace("]", ""))) {
                            if (IPAddressUtil.isIPv4LiteralAddress(h2)) {
                                return 1;
                            }
                        } else if (0 != h1.compareTo(h2)) {
                            return -1;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return h1.compareTo(h2);
                }
            });
            final ReentrantLock setLock = new ReentrantLock();
            final CountDownLatch latchListeners = new CountDownLatch(clientSocketsFinal.length);
            MulticastSocket[] arr$ = clientSocketsFinal;
            int n = arr$.length;
            boolean bl = false;
            while (var19_23 < n) {
                final MulticastSocket socket = arr$[var19_23];
                futures.add(MulticastPulseClient.getExecutorService().submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            DatagramPacket response = new DatagramPacket(new byte[2048], 2048);
                            latchListeners.countDown();
                            while (running.get()) {
                                try {
                                    String s;
                                    socket.receive(response);
                                    SocketAddress sa = response.getSocketAddress();
                                    if (null == sa || !(sa instanceof InetSocketAddress)) continue;
                                    int len = response.getLength();
                                    if (len > 2048) {
                                        if (log.isLoggable(Level.FINE)) {
                                            log.log(Level.FINE, "Truncating multipulse length {0} to 2048", new Object[]{len});
                                        }
                                        len = 2048;
                                    }
                                    if (!(s = new String(response.getData(), 0, len)).startsWith(MulticastPulseClient.SERVER)) continue;
                                    s = s.replace(MulticastPulseClient.SERVER, "");
                                    String group = s.substring(0, s.indexOf(58));
                                    s = s.substring(group.length() + 1);
                                    if (!"*".equals(forGroup) && !forGroup.equals(group)) continue;
                                    String services = s.substring(0, s.lastIndexOf(124));
                                    s = s.substring(services.length() + 1);
                                    String[] serviceList = services.split("\\|");
                                    String[] hosts = s.split(",");
                                    for (String svc : serviceList) {
                                        URI serviceUri;
                                        if (MulticastPulseClient.EMPTY.equals(svc)) continue;
                                        try {
                                            serviceUri = URI.create(svc);
                                        }
                                        catch (Exception e) {
                                            continue;
                                        }
                                        if (!schemes.contains(serviceUri.getScheme())) continue;
                                        String serverHost = ((InetSocketAddress)response.getSocketAddress()).getAddress().getHostAddress();
                                        String serviceHost = serviceUri.getHost();
                                        if (MulticastPulseClient.isLocalAddress(serviceHost, false) && !MulticastPulseClient.isLocalAddress(serverHost, false)) continue;
                                        String svcfull = "mp-" + serverHost + ":" + group + ":" + svc;
                                        setLock.lock();
                                        try {
                                            if (svcfull.contains("0.0.0.0")) {
                                                for (String h : hosts) {
                                                    if (h.replace("[", "").startsWith("2001:0:")) continue;
                                                    set.add(URI.create(svcfull.replace("0.0.0.0", MulticastPulseClient.ipFormat(h))));
                                                }
                                                continue;
                                            }
                                            if (svcfull.contains("[::]")) {
                                                for (String h : hosts) {
                                                    if (h.replace("[", "").startsWith("2001:0:")) continue;
                                                    set.add(URI.create(svcfull.replace("[::]", MulticastPulseClient.ipFormat(h))));
                                                }
                                                continue;
                                            }
                                            set.add(URI.create(svcfull));
                                        }
                                        catch (Exception e) {
                                        }
                                        finally {
                                            setLock.unlock();
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                }
                            }
                        }
                        finally {
                            try {
                                socket.leaveGroup(ia);
                            }
                            catch (Exception e) {}
                            try {
                                socket.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }));
                ++var19_23;
            }
            try {
                if (latchListeners.await(clientSocketsFinal.length * 2, TimeUnit.SECONDS)) {
                    futures.add(0, MulticastPulseClient.getExecutorService().submit(new Runnable(){

                        @Override
                        public void run() {
                            while (running.get()) {
                                for (MulticastSocket socket : clientSocketsFinal) {
                                    if (!running.get()) break;
                                    try {
                                        socket.send(request);
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                if (!running.get()) continue;
                                try {
                                    Thread.sleep(10L);
                                }
                                catch (InterruptedException e) {
                                    break;
                                }
                            }
                        }
                    }));
                } else {
                    timeout = 1L;
                }
            }
            catch (InterruptedException e) {
                timeout = 1L;
            }
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    running.set(false);
                    try {
                        for (Future future : futures) {
                            future.cancel(true);
                        }
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        // empty catch block
                    }
                }
            }, timeout);
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Exception exception) {}
            }
            setLock.lock();
            try {
                TreeSet<URI> treeSet = new TreeSet<URI>((Collection<URI>)set);
                setLock.unlock();
                return treeSet;
            }
            catch (Throwable throwable) {
                setLock.unlock();
                throw throwable;
            }
        }
        finally {
            for (Future future : futures) {
                try {
                    future.cancel(true);
                }
                catch (Exception e) {}
            }
            futures.clear();
            for (MulticastSocket socket : clientSockets) {
                try {
                    socket.leaveGroup(ia);
                }
                catch (Exception e) {}
                try {
                    socket.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private static InetAddress getAddress(String host) throws Exception {
        InetAddress ia;
        try {
            ia = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new Exception(host + " is not a valid address", e);
        }
        if (null == ia || !ia.isMulticastAddress()) {
            throw new Exception(host + " is not a valid multicast address");
        }
        return ia;
    }

    public static boolean isLocalAddress(String host, boolean wildcardIsLocal) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            return false;
        }
        if (wildcardIsLocal && addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    private static String ipFormat(String h) throws UnknownHostException {
        InetAddress ia = InetAddress.getByName(h);
        if (ia instanceof Inet6Address) {
            return "[" + ia.getHostAddress() + "]";
        }
        return h;
    }

    public static MulticastSocket[] getSockets(InetAddress ia, int port) throws Exception {
        ArrayList<MulticastSocket> list = new ArrayList<MulticastSocket>();
        for (NetworkInterface ni : MulticastPulseClient.getInterfaces()) {
            MulticastSocket ms = null;
            try {
                ms = new MulticastSocket(port);
                ms.setNetworkInterface(ni);
                ms.setSoTimeout(0);
                ms.setTimeToLive(TTL);
                if (!ms.getBroadcast()) {
                    ms.setBroadcast(true);
                }
                ms.joinGroup(ia);
                list.add(ms);
            }
            catch (Exception e) {
                if (null == ms) continue;
                try {
                    ms.close();
                }
                catch (Exception t) {
                    // empty catch block
                }
            }
        }
        return list.toArray(new MulticastSocket[list.size()]);
    }

    private static NetworkInterface[] getNetworkInterfaces() {
        HashSet<NetworkInterface> list = new HashSet<NetworkInterface>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface next = interfaces.nextElement();
                if (!next.supportsMulticast() || !next.isUp()) continue;
                list.add(next);
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return list.toArray(new NetworkInterface[list.size()]);
    }

    public static void main(String[] args) throws Exception {
        CommandParser.Arguments arguments;
        try {
            arguments = cmd.parse(args);
        }
        catch (CommandParser.HelpException e) {
            System.exit(0);
            throw new Exception();
        }
        catch (CommandParser.InvalidOptionsException e) {
            System.exit(1);
            throw new Exception();
        }
        Options options = arguments.options();
        final String discover = options.get("group", "*");
        final String mchost = options.get("host", "239.255.3.2");
        final int mcport = options.get("port", 6142);
        final int timeout = options.get("timeout", 1500);
        System.out.println(String.format("Using discovery options group=%1$s, host=%2$s, port=%3$s, timeout=%4$s", discover, mchost, mcport, timeout));
        System.out.println();
        final AtomicBoolean running = new AtomicBoolean(true);
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (running.get()) {
                    Set<URI> uriSet = null;
                    try {
                        uriSet = MulticastPulseClient.discoverURIs(discover, new HashSet<String>(Arrays.asList("ejbd", "ejbds", "http", "https")), mchost, mcport, timeout);
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                    }
                    int size = uriSet.size();
                    if (uriSet != null && size > 0) {
                        int st = timeout / size;
                        for (URI uri : uriSet) {
                            String server = uri.getScheme().replace("mp-", "");
                            URI uriSub = URI.create(uri.getSchemeSpecificPart());
                            String group = uriSub.getScheme();
                            uriSub = URI.create(uriSub.getSchemeSpecificPart());
                            String host = uriSub.getHost();
                            int port = uriSub.getPort();
                            if (MulticastPulseClient.isLocalAddress(host, false) && !MulticastPulseClient.isLocalAddress(server, false)) {
                                System.out.println(server + ":" + group + " - " + uriSub.toASCIIString() + " is not a local service");
                                continue;
                            }
                            System.out.print(server + ":" + group + " - " + uriSub.toASCIIString() + " is reachable: ");
                            boolean b = false;
                            Socket s = new Socket();
                            try {
                                s.connect(new InetSocketAddress(host, port), st);
                                b = true;
                            }
                            catch (Exception e) {
                                if (SocketTimeoutException.class.isInstance(e) || SocketException.class.isInstance(e)) {
                                    MulticastPulseClient.broadcastBadUri(group, uriSub, mchost, mcport);
                                    System.out.print("" + e + " : ");
                                }
                            }
                            finally {
                                try {
                                    s.close();
                                }
                                catch (Exception e) {}
                            }
                            System.out.println(b);
                        }
                    } else {
                        System.out.println("### Failed to discover server: " + discover);
                    }
                    System.out.println(".");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, "MulticastPulseClient Test");
        t.setDaemon(true);
        t.start();
        System.in.read();
        running.set(false);
        t.interrupt();
    }

    private static void broadcastBadUri(final String group, final URI uri, final String host, final int port) {
        MulticastPulseClient.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    MulticastSocket[] multicastSockets;
                    InetAddress ia = MulticastPulseClient.getAddress(host);
                    byte[] bytes = (MulticastPulseClient.CLIENT + group + MulticastPulseClient.BADURI + uri.getHost()).getBytes(UTF8);
                    DatagramPacket request = new DatagramPacket(bytes, bytes.length, new InetSocketAddress(ia, port));
                    for (MulticastSocket socket : multicastSockets = MulticastPulseClient.getSockets(ia, port)) {
                        try {
                            socket.send(request);
                        }
                        catch (Exception e) {
                            log.log(Level.WARNING, "Failed to broadcast bad URI: " + uri + " on: " + socket.getInterface().getHostAddress(), e);
                        }
                    }
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Failed to broadcast bad URI: " + uri, e);
                }
            }
        });
    }
}

