/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.util.ServerInfo;
import org.apache.openejb.classloader.ClassLoaderConfigurer;
import org.apache.openejb.config.QuickJarsTxtParser;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.OpenEjbVersion;
import org.apache.tomee.catalina.TomcatLoader;
import org.apache.tomee.loader.TomcatHelper;

public class ServerListener
implements LifecycleListener {
    private static final Logger LOGGER = Logger.getLogger(ServerListener.class.getName());
    private static final AtomicBoolean listenerInstalled = new AtomicBoolean(false);

    public void lifecycleEvent(LifecycleEvent event) {
        this.install(event);
        SystemInstance.get().fireEvent((Object)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void install(LifecycleEvent event) {
        if ("before_init".equals(event.getType()) && StandardServer.class.isInstance(event.getSource())) {
            this.installServerInfo();
        }
        AtomicBoolean atomicBoolean = listenerInstalled;
        synchronized (atomicBoolean) {
            if (listenerInstalled.get() || !"after_init".equals(event.getType())) {
                return;
            }
            if (!(event.getSource() instanceof StandardServer)) {
                return;
            }
            try {
                StandardServer server = (StandardServer)event.getSource();
                TomcatHelper.setServer((StandardServer)server);
                Properties properties = new Properties();
                System.getProperties().setProperty("openejb.embedder.source", this.getClass().getSimpleName());
                properties.setProperty("openejb.embedder.source", this.getClass().getSimpleName());
                if (SystemInstance.isInitialized()) {
                    return;
                }
                properties.setProperty("openejb.loader", "tomcat-system");
                String catalinaHome = System.getProperty("catalina.home");
                properties.setProperty("openejb.home", catalinaHome);
                System.setProperty("openejb.home", catalinaHome);
                String catalinaBase = System.getProperty("catalina.base");
                properties.setProperty("openejb.base", catalinaBase);
                System.setProperty("openejb.base", catalinaBase);
                ClassLoader classLoader = ServerListener.class.getClassLoader();
                try {
                    String serverBuilt;
                    String serverInfo;
                    Properties tomcatServerInfo = IO.readProperties((InputStream)classLoader.getResourceAsStream("org/apache/catalina/util/ServerInfo.properties"), (Properties)new Properties());
                    String serverNumber = tomcatServerInfo.getProperty("server.number");
                    if (serverNumber == null && (serverInfo = tomcatServerInfo.getProperty("server.info")) != null) {
                        int slash = serverInfo.indexOf(47);
                        serverNumber = serverInfo.substring(slash + 1);
                    }
                    if (serverNumber != null) {
                        System.setProperty("tomcat.version", serverNumber);
                    }
                    if ((serverBuilt = tomcatServerInfo.getProperty("server.built")) != null) {
                        System.setProperty("tomcat.built", serverBuilt);
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                TomcatLoader loader = new TomcatLoader();
                loader.initSystemInstance(properties);
                if (URLClassLoader.class.isInstance(classLoader)) {
                    URLClassLoader ucl = (URLClassLoader)URLClassLoader.class.cast(classLoader);
                    try {
                        Method addUrl = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                        boolean acc = addUrl.isAccessible();
                        try {
                            for (File f : ProvisioningUtil.addAdditionalLibraries()) {
                                ServerListener.addUrl(ucl, addUrl, f.toURI().toURL());
                            }
                            File globalJaxrsTxt = SystemInstance.get().getConf("jars.txt");
                            ClassLoaderConfigurer configurer = QuickJarsTxtParser.parse((File)globalJaxrsTxt);
                            if (configurer != null) {
                                for (URL f : configurer.additionalURLs()) {
                                    ServerListener.addUrl(ucl, addUrl, f);
                                }
                            }
                        }
                        finally {
                            addUrl.setAccessible(acc);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                } else {
                    LOGGER.finer("container classloader is not an URL one so can't check provisining: " + classLoader);
                }
                loader.initialize(properties);
                listenerInstalled.set(true);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "TomEE Listener can't start OpenEJB", e);
            }
        }
    }

    private static void addUrl(URLClassLoader ucl, Method addUrl, URL url) throws IllegalAccessException, InvocationTargetException, MalformedURLException {
        if (!addUrl.isAccessible()) {
            addUrl.setAccessible(true);
        }
        addUrl.invoke((Object)ucl, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void installServerInfo() {
        if (SystemInstance.get().getOptions().get("tomee.keep-server-info", false)) {
            return;
        }
        String value = ServerInfo.getServerInfo();
        Field field = null;
        boolean acc = true;
        try {
            field = ServerInfo.class.getDeclaredField("serverInfo");
            acc = field.isAccessible();
            int slash = value.indexOf(47);
            field.setAccessible(true);
            String version = OpenEjbVersion.get().getVersion();
            String tomeeVersion = Integer.parseInt(Character.toString(version.charAt(0))) - 3 + version.substring(1, version.length());
            field.set(null, value.substring(0, slash) + " (TomEE)" + value.substring(slash) + " (" + tomeeVersion + ")");
        }
        catch (Exception e) {
        }
        finally {
            if (field != null) {
                field.setAccessible(acc);
            }
        }
    }
}

