/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina.realm.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletRequest;

public class FindSecurityConstraintsEvent {
    private final ServletRequest request;
    private final String context;
    private final List<String> roles = new ArrayList<String>();
    private String userConstraint;

    public FindSecurityConstraintsEvent(ServletRequest request, String context) {
        this.request = request;
        this.context = context;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public String getContext() {
        return this.context;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public FindSecurityConstraintsEvent addRoles(String ... roles) {
        this.roles.addAll(Arrays.asList(roles));
        return this;
    }

    public void setUserConstraint(String userConstraint) {
        if (this.userConstraint != null && !this.userConstraint.equals(userConstraint)) {
            throw new IllegalStateException("User constraint already set to > " + this.userConstraint);
        }
        this.userConstraint = userConstraint;
    }

    public String getUserConstraint() {
        return this.userConstraint;
    }
}

