/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.spi.Bean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.util.AnnotationUtil;

public class AlternativesManager {
    private final Set<Class<?>> alternatives = new HashSet();
    private final Set<Class<? extends Annotation>> stereoAlternatives = new HashSet<Class<? extends Annotation>>();
    private final WebBeansContext webBeansContext;

    public AlternativesManager(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public void addStereoTypeAlternative(Class<?> alternative, String fileName, ScannerService scanner) {
        if (Annotation.class.isAssignableFrom(alternative)) {
            Class<?> stereo = alternative;
            boolean ok = false;
            if (this.webBeansContext.getAnnotationManager().isStereoTypeAnnotation(stereo) && AnnotationUtil.hasClassAnnotation(stereo, Alternative.class)) {
                boolean isBDAScanningEnabled;
                boolean bl = isBDAScanningEnabled = scanner != null && scanner.isBDABeansXmlScanningEnabled();
                if (isBDAScanningEnabled && !scanner.getBDABeansXmlScanner().addStereoType(stereo, fileName)) {
                    throw new WebBeansConfigurationException("Given alternative class : " + alternative.getName() + " is already added as @Alternative");
                }
                ok = true;
                this.stereoAlternatives.add(stereo);
            }
            if (!ok) {
                throw new WebBeansConfigurationException("Given stereotype class : " + alternative.getName() + " is not annotated with @Alternative");
            }
        } else {
            throw new WebBeansConfigurationException("Given stereotype class : " + alternative.getName() + " is not an annotation");
        }
    }

    public void addClazzAlternative(Class<?> alternative, String fileName, ScannerService scanner) {
        if (AnnotationUtil.hasClassAnnotation(alternative, Alternative.class)) {
            boolean isBDAScanningEnabled;
            boolean bl = isBDAScanningEnabled = scanner != null && scanner.isBDABeansXmlScanningEnabled();
            if (isBDAScanningEnabled && !scanner.getBDABeansXmlScanner().addAlternative(alternative, fileName)) {
                throw new WebBeansConfigurationException("Given class : " + alternative.getName() + " is already added as @Alternative");
            }
        } else {
            throw new WebBeansConfigurationException("Given class : " + alternative.getName() + " is not annotated with @Alternative");
        }
        this.alternatives.add(alternative);
    }

    public boolean isClassAlternative(Class<?> clazz) {
        return this.alternatives.contains(clazz);
    }

    public boolean isStereoAlternative(Class<? extends Annotation> stereo) {
        return this.stereoAlternatives.contains(stereo);
    }

    public boolean isBeanHasAlternative(Bean<?> bean) {
        return this.isAlternative(bean.getBeanClass(), bean.getStereotypes());
    }

    public boolean isAlternative(Class<?> beanType, Set<Class<? extends Annotation>> stereotypes) {
        if (this.alternatives.contains(beanType)) {
            return true;
        }
        for (Class<? extends Annotation> ann : stereotypes) {
            if (!this.stereoAlternatives.contains(ann)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.alternatives.clear();
        this.stereoAlternatives.clear();
    }
}

