/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.util.ExceptionUtil;

public class LifecycleInterceptorInvocationContext<T>
implements InvocationContext {
    private T target;
    private InterceptionType type;
    private List<Interceptor<?>> interceptors;
    private Map<Interceptor<?>, ?> instances;
    private Map<String, Object> contextData = new HashMap<String, Object>();
    private int interceptorIndex = 0;
    private List<AnnotatedMethod<?>> lifecycleMethods;

    public LifecycleInterceptorInvocationContext(T target, InterceptionType type, List<Interceptor<?>> interceptors, Map<Interceptor<?>, ?> instances, List<AnnotatedMethod<?>> lifecycleMethods) {
        this.target = target;
        this.type = type;
        this.interceptors = interceptors;
        this.instances = instances;
        this.lifecycleMethods = lifecycleMethods;
    }

    public T getTarget() {
        return this.target;
    }

    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    public void setContextData(Map<String, Object> contextData) {
        this.contextData = contextData;
    }

    public Object proceed() throws Exception {
        if (this.interceptors != null && this.interceptorIndex < this.interceptors.size()) {
            Interceptor<?> interceptor;
            if ((interceptor = this.interceptors.get(this.interceptorIndex++)).intercepts(this.type)) {
                return interceptor.intercept(this.type, this.instances.get(interceptor), (InvocationContext)this);
            }
            return this.proceed();
        }
        if (this.lifecycleMethods != null) {
            for (AnnotatedMethod<?> lifecycleMethod : this.lifecycleMethods) {
                Method m = lifecycleMethod.getJavaMember();
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                try {
                    m.invoke(this.getTarget(), new Object[0]);
                }
                catch (InvocationTargetException ite) {
                    throw ExceptionUtil.throwAsRuntimeException(ite.getCause());
                }
            }
        }
        return null;
    }

    public Method getMethod() {
        return null;
    }

    public Object[] getParameters() {
        return new Object[0];
    }

    public void setParameters(Object[] parameters) {
    }

    public Object getTimer() {
        return null;
    }

    public Constructor getConstructor() {
        return null;
    }
}

