/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.meta;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.persistence.meta.Members;
import org.apache.openjpa.persistence.meta.MetamodelImpl;
import org.apache.openjpa.persistence.meta.Types;

public abstract class AbstractManagedType<X>
extends Types.BaseType<X>
implements ManagedType<X> {
    private static final Localizer _loc = Localizer.forPackage(AbstractManagedType.class);
    public final MetamodelImpl model;
    public final ClassMetaData meta;
    private Set<Attribute<? super X, ?>> attrs = new HashSet();
    private final DeclaredAttributeFilter<X> declaredAttributeFilter;
    private final SingularAttributeFilter<X> singularAttributeFilter;
    private final SingularAttributeFilter<X> pluralAttributeFilter;

    protected AbstractManagedType(Class<X> cls, MetamodelImpl model) {
        super(cls);
        this.model = model;
        this.meta = null;
        this.declaredAttributeFilter = null;
        this.singularAttributeFilter = null;
        this.pluralAttributeFilter = null;
    }

    public AbstractManagedType(ClassMetaData meta, MetamodelImpl model) {
        super(meta.getDescribedType());
        FieldMetaData[] fmds;
        this.model = model;
        this.meta = meta;
        block27: for (FieldMetaData f : fmds = meta.getFields()) {
            int decCode = f.getDeclaredTypeCode();
            switch (decCode) {
                case 0: 
                case 16: {
                    this.attrs.add(new Members.SingularAttributeImpl(this, f));
                    continue block27;
                }
                case 1: 
                case 17: {
                    this.attrs.add(new Members.SingularAttributeImpl(this, f));
                    continue block27;
                }
                case 2: 
                case 18: {
                    this.attrs.add(new Members.SingularAttributeImpl(this, f));
                    continue block27;
                }
                case 3: 
                case 19: {
                    this.attrs.add(new Members.SingularAttributeImpl(this, f));
                    continue block27;
                }
                case 4: 
                case 20: {
                    this.attrs.add(new Members.SingularAttributeImpl(this, f));
                    continue block27;
                }
                case 5: 
                case 21: {
                    this.attrs.add(new Members.SingularAttributeImpl(this, f));
                    continue block27;
                }
                case 6: 
                case 22: {
                    this.attrs.add(new Members.SingularAttributeImpl(this, f));
                    continue block27;
                }
                case 7: 
                case 23: {
                    this.attrs.add(new Members.SingularAttributeImpl(this, f));
                    continue block27;
                }
                case 9: {
                    this.attrs.add(new Members.SingularAttributeImpl(this, f));
                    continue block27;
                }
                case 10: {
                    this.attrs.add(new Members.SingularAttributeImpl(this, f));
                    continue block27;
                }
                case 14: {
                    this.attrs.add(new Members.SingularAttributeImpl(this, f));
                    continue block27;
                }
                case 28: {
                    this.attrs.add(new Members.SingularAttributeImpl(this, f));
                    continue block27;
                }
                case 24: {
                    this.attrs.add(new Members.SingularAttributeImpl(this, f));
                    continue block27;
                }
                case 25: {
                    this.attrs.add(new Members.SingularAttributeImpl(this, f));
                    continue block27;
                }
                case 26: {
                    this.attrs.add(new Members.SingularAttributeImpl(this, f));
                    continue block27;
                }
                case 8: 
                case 15: 
                case 27: 
                case 29: 
                case 30: 
                case 31: {
                    this.attrs.add(new Members.SingularAttributeImpl(this, f));
                    continue block27;
                }
                case 11: {
                    Compatibility compat = meta.getRepository().getConfiguration().getCompatibilityInstance();
                    if (compat.getUseListAttributeForArrays() || f.isPersistentCollection()) {
                        this.attrs.add(new Members.ListAttributeImpl(this, f));
                        continue block27;
                    }
                    this.attrs.add(new Members.SingularAttributeImpl(this, f));
                    continue block27;
                }
                case 12: {
                    switch (MetamodelImpl.categorizeCollection(f.getDeclaredType())) {
                        case COLLECTION: {
                            this.attrs.add(new Members.CollectionAttributeImpl(this, f));
                            break;
                        }
                        case LIST: {
                            this.attrs.add(new Members.ListAttributeImpl(this, f));
                            break;
                        }
                        case SET: {
                            this.attrs.add(new Members.SetAttributeImpl(this, f));
                        }
                    }
                    continue block27;
                }
                case 13: {
                    this.attrs.add(new Members.MapAttributeImpl(this, f));
                    continue block27;
                }
                case 32: {
                    this.attrs.add(new Members.SingularAttributeImpl(this, f));
                    continue block27;
                }
                default: {
                    throw new IllegalStateException(_loc.get("field-unrecognized", f.getFullName(false), decCode).getMessage());
                }
            }
        }
        this.declaredAttributeFilter = new DeclaredAttributeFilter(this);
        this.singularAttributeFilter = new SingularAttributeFilter();
        this.pluralAttributeFilter = new SingularAttributeFilter().inverse();
    }

    public Set<Attribute<? super X, ?>> getAttributes() {
        return Collections.unmodifiableSet(this.attrs);
    }

    public Set<Attribute<X, ?>> getDeclaredAttributes() {
        return AbstractManagedType.filter(this.attrs, new TreeSet(), this.declaredAttributeFilter);
    }

    public Set<SingularAttribute<? super X, ?>> getSingularAttributes() {
        return AbstractManagedType.filter(this.attrs, new TreeSet(), this.singularAttributeFilter);
    }

    public Set<SingularAttribute<X, ?>> getDeclaredSingularAttributes() {
        return AbstractManagedType.filter(this.attrs, new TreeSet(), this.declaredAttributeFilter, this.singularAttributeFilter);
    }

    public <Y> Attribute<? super X, Y> getAttribute(String name, Class<Y> type) {
        Attribute<? super X, ?> result = AbstractManagedType.pick(this.attrs, new AttributeNameFilter(name), new AttributeTypeFilter(type));
        if (result == null) {
            this.notFoundException("attr-not-found", name, type);
        }
        return result;
    }

    public <Y> SingularAttribute<? super X, Y> getSingularAttribute(String name, Class<Y> type) {
        Attribute<? super X, ?> result = AbstractManagedType.pick(this.attrs, new AttributeNameFilter(name), new AttributeTypeFilter(type), this.singularAttributeFilter);
        if (result == null) {
            this.notFoundException("attr-not-found-single", name, type);
        }
        return (SingularAttribute)result;
    }

    public <Y> Attribute<X, Y> getDeclaredAttribute(String name, Class<Y> type) {
        Attribute<? super X, ?> result = AbstractManagedType.pick(this.attrs, new AttributeNameFilter(name), new AttributeTypeFilter(type), this.declaredAttributeFilter);
        if (result == null) {
            this.notFoundException("attr-not-found-decl-single", name, type);
        }
        return result;
    }

    public <Y> SingularAttribute<X, Y> getDeclaredSingularAttribute(String name, Class<Y> type) {
        Attribute<? super X, ?> result = AbstractManagedType.pick(this.attrs, new AttributeNameFilter(name), new AttributeTypeFilter(type), this.declaredAttributeFilter, this.singularAttributeFilter);
        if (result == null) {
            this.notFoundException("attr-not-found-decl-single", name, type);
        }
        return (SingularAttribute)result;
    }

    public Set<PluralAttribute<? super X, ?, ?>> getPluralAttributes() {
        return AbstractManagedType.filter(this.attrs, new HashSet(), this.pluralAttributeFilter);
    }

    public Set<PluralAttribute<X, ?, ?>> getDeclaredPluralAttributes() {
        return AbstractManagedType.filter(this.attrs, new HashSet(), this.declaredAttributeFilter, this.pluralAttributeFilter);
    }

    public <E> CollectionAttribute<? super X, E> getCollection(String name, Class<E> elementType) {
        Attribute<? super X, ?> result = AbstractManagedType.pick(this.attrs, new PluralCategoryFilter(PluralAttribute.CollectionType.COLLECTION), new ElementTypeFilter(elementType), new AttributeNameFilter(name));
        if (result == null) {
            this.notFoundException("attr-not-found-coll", name, elementType);
        }
        return (CollectionAttribute)result;
    }

    public <E> SetAttribute<? super X, E> getSet(String name, Class<E> elementType) {
        Attribute<? super X, ?> result = AbstractManagedType.pick(this.attrs, new PluralCategoryFilter(PluralAttribute.CollectionType.SET), new ElementTypeFilter(elementType), new AttributeNameFilter(name));
        if (result == null) {
            this.notFoundException("attr-not-found-set", name, elementType);
        }
        return (SetAttribute)result;
    }

    public <E> ListAttribute<? super X, E> getList(String name, Class<E> elementType) {
        Attribute<? super X, ?> result = AbstractManagedType.pick(this.attrs, new PluralCategoryFilter(PluralAttribute.CollectionType.LIST), new ElementTypeFilter(elementType), new AttributeNameFilter(name));
        if (result == null) {
            this.notFoundException("attr-not-found-list", name, elementType);
        }
        return (ListAttribute)result;
    }

    public <K, V> MapAttribute<? super X, K, V> getMap(String name, Class<K> keyType, Class<V> valueType) {
        Attribute<? super X, ?> result = AbstractManagedType.pick(this.attrs, new AttributeNameFilter(name), new PluralCategoryFilter(PluralAttribute.CollectionType.MAP), new EntryTypeFilter(keyType, valueType));
        if (result == null) {
            this.notFoundException("attr-not-found-map", name, keyType, valueType);
        }
        return (MapAttribute)result;
    }

    public <E> CollectionAttribute<X, E> getDeclaredCollection(String name, Class<E> elementType) {
        Attribute<? super X, ?> result = AbstractManagedType.pick(this.attrs, this.declaredAttributeFilter, new PluralCategoryFilter(PluralAttribute.CollectionType.COLLECTION), new ElementTypeFilter(elementType), new AttributeNameFilter(name));
        if (result == null) {
            this.notFoundException("attr-not-found-decl-coll", name, elementType);
        }
        return (CollectionAttribute)result;
    }

    public <E> SetAttribute<X, E> getDeclaredSet(String name, Class<E> elementType) {
        Attribute<? super X, ?> result = AbstractManagedType.pick(this.attrs, this.declaredAttributeFilter, new PluralCategoryFilter(PluralAttribute.CollectionType.SET), new AttributeNameFilter(name));
        if (result == null) {
            this.notFoundException("attr-not-found-decl-set", name, elementType);
        }
        return (SetAttribute)result;
    }

    public <E> ListAttribute<X, E> getDeclaredList(String name, Class<E> elementType) {
        Attribute<? super X, ?> result = AbstractManagedType.pick(this.attrs, this.declaredAttributeFilter, new PluralCategoryFilter(PluralAttribute.CollectionType.LIST), new ElementTypeFilter(elementType), new AttributeNameFilter(name));
        if (result == null) {
            this.notFoundException("attr-not-found-decl-list", name, elementType);
        }
        return (ListAttribute)result;
    }

    public <K, V> MapAttribute<X, K, V> getDeclaredMap(String name, Class<K> keyType, Class<V> valueType) {
        Attribute<? super X, ?> result = AbstractManagedType.pick(this.attrs, this.declaredAttributeFilter, new AttributeNameFilter(name), new PluralCategoryFilter(PluralAttribute.CollectionType.MAP), new EntryTypeFilter(keyType, valueType));
        if (result == null) {
            this.notFoundException("attr-not-found-decl-map", name, keyType, valueType);
        }
        return (MapAttribute)result;
    }

    public Attribute<? super X, ?> getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    public Attribute<X, ?> getDeclaredAttribute(String name) {
        return this.getDeclaredAttribute(name, null);
    }

    public SingularAttribute<? super X, ?> getSingularAttribute(String name) {
        return this.getSingularAttribute(name, null);
    }

    public SingularAttribute<X, ?> getDeclaredSingularAttribute(String name) {
        return this.getDeclaredSingularAttribute(name, null);
    }

    public CollectionAttribute<? super X, ?> getCollection(String name) {
        return this.getCollection(name, null);
    }

    public SetAttribute<? super X, ?> getSet(String name) {
        return this.getSet(name, null);
    }

    public ListAttribute<? super X, ?> getList(String name) {
        return this.getList(name, null);
    }

    public MapAttribute<? super X, ?, ?> getMap(String name) {
        return this.getMap(name, null, null);
    }

    public CollectionAttribute<X, ?> getDeclaredCollection(String name) {
        return this.getDeclaredCollection(name, null);
    }

    public SetAttribute<X, ?> getDeclaredSet(String name) {
        return this.getDeclaredSet(name, null);
    }

    public ListAttribute<X, ?> getDeclaredList(String name) {
        return this.getDeclaredList(name, null);
    }

    public MapAttribute<X, ?, ?> getDeclaredMap(String name) {
        return this.getDeclaredMap(name, null, null);
    }

    public final Set<SingularAttribute<? super X, ?>> getIdClassAttributes() {
        if (this.meta.isOpenJPAIdentity()) {
            throw new IllegalArgumentException(this.meta + " does not use IdClass. Object Id type = " + this.meta.getObjectIdType() + " Identity Type = " + this.meta.getIdentityType());
        }
        return AbstractManagedType.filter(this.attrs, new HashSet(), new IdAttributeFilter());
    }

    public final <Y> SingularAttribute<? super X, Y> getId(Class<Y> type) {
        Attribute<? super X, ?> result = AbstractManagedType.pick(this.attrs, new AttributeTypeFilter(type), new IdAttributeFilter());
        if (result != null) {
            return (SingularAttribute)result;
        }
        throw new IllegalArgumentException();
    }

    public final <Y> SingularAttribute<X, Y> getDeclaredId(Class<Y> type) {
        Attribute<? super X, ?> result = AbstractManagedType.pick(this.attrs, this.declaredAttributeFilter, new AttributeTypeFilter(type), new IdAttributeFilter());
        if (result != null) {
            return (SingularAttribute)result;
        }
        throw new IllegalArgumentException();
    }

    public <Y> SingularAttribute<? super X, Y> getVersion(Class<Y> type) {
        Attribute<? super X, ?> result = AbstractManagedType.pick(this.attrs, new VersionAttributeFilter(), new AttributeTypeFilter(type));
        if (result == null) {
            this.notFoundException("version-not-found", "", type);
        }
        return (SingularAttribute)result;
    }

    public <Y> SingularAttribute<X, Y> getDeclaredVersion(Class<Y> type) {
        Attribute<? super X, ?> result = AbstractManagedType.pick(this.attrs, this.declaredAttributeFilter, new VersionAttributeFilter(), new AttributeTypeFilter(type));
        if (result == null) {
            this.notFoundException("decl-version-not-found", "", type);
        }
        return (SingularAttribute)result;
    }

    FieldMetaData getField(String name) {
        return this.getField(name, null, null, null, false);
    }

    FieldMetaData getField(String name, Class type) {
        return this.getField(name, type, null, null, false);
    }

    FieldMetaData getField(String name, Class type, boolean declaredOnly) {
        return this.getField(name, type, null, null, declaredOnly);
    }

    FieldMetaData getField(String name, Class<?> type, Class<?> elementType, Class<?> keyType, boolean decl) {
        FieldMetaData fmd;
        FieldMetaData fieldMetaData = fmd = decl ? this.meta.getDeclaredField(name) : this.meta.getField(name);
        if (fmd == null) {
            if (decl && this.meta.getField(name) != null) {
                throw new IllegalArgumentException(_loc.get("field-not-decl", name, this.cls, this.meta.getField(name).getDeclaringType()).getMessage());
            }
            throw new IllegalArgumentException(_loc.get("field-missing", name, this.meta.getDescribedType(), Arrays.toString(this.meta.getFieldNames())).getMessage());
        }
        this.assertType("field-type-mismatch", fmd, fmd.getDeclaredType(), type);
        this.assertType("field-element-type-mismatch", fmd, fmd.getElement().getDeclaredType(), elementType);
        this.assertType("field-key-type-mismatch", fmd, fmd.getKey().getDeclaredType(), keyType);
        return fmd;
    }

    void assertType(String msg, FieldMetaData fmd, Class<?> actual, Class<?> expected) {
        if (expected != null && !expected.isAssignableFrom(actual) && this.wrap(expected) != this.wrap(actual)) {
            throw new IllegalArgumentException(_loc.get(msg, fmd.getName(), actual, expected).getMessage());
        }
    }

    Class<?> wrap(Class<?> c) {
        if (c.isPrimitive()) {
            if (c == Integer.TYPE) {
                return Integer.class;
            }
            if (c == Long.TYPE) {
                return Long.class;
            }
            if (c == Boolean.TYPE) {
                return Boolean.class;
            }
            if (c == Byte.TYPE) {
                return Byte.class;
            }
            if (c == Character.TYPE) {
                return Character.class;
            }
            if (c == Double.TYPE) {
                return Double.class;
            }
            if (c == Float.TYPE) {
                return Float.class;
            }
            if (c == Short.TYPE) {
                return Short.class;
            }
        }
        return c;
    }

    private void notFoundException(String msg, String name, Class<?> t1) {
        throw new IllegalArgumentException(_loc.get(msg, name, t1 == null ? "any" : t1.getName(), this.meta).getMessage());
    }

    private void notFoundException(String msg, String name, Class<?> t1, Class<?> t2) {
        throw new IllegalArgumentException(_loc.get(msg, new Object[]{name, t1 == null ? "any" : t1.getName(), t2 == null ? "any" : t1.getName(), this.meta}).getMessage());
    }

    public static <T, C extends Collection<E>, E> C filter(Collection<T> original, C result, Filter<T> f1, Filter<T> f2, Filter<T> f3, Filter<T> f4) {
        for (T t : original) {
            if (f1 != null && !f1.selects(t) || f2 != null && !f2.selects(t) || f3 != null && !f3.selects(t) || f4 != null && !f4.selects(t)) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> T pick(Collection<T> original, Filter<T> f1, Filter<T> f2, Filter<T> f3, Filter<T> f4) {
        for (T t : original) {
            if (f1 != null && !f1.selects(t) || f2 != null && !f2.selects(t) || f3 != null && !f3.selects(t) || f4 != null && !f4.selects(t)) continue;
            return t;
        }
        return null;
    }

    static <T, C extends Collection<E>, E> C filter(Collection<T> original, C result, Filter<T> f1) {
        return AbstractManagedType.filter(original, result, f1, null, null, null);
    }

    static <T, C extends Collection<E>, E> C filter(Collection<T> original, C result, Filter<T> f1, Filter<T> f2) {
        return AbstractManagedType.filter(original, result, f1, f2, null, null);
    }

    static <T, C extends Collection<E>, E> C filter(Collection<T> original, C result, Filter<T> f1, Filter<T> f2, Filter<T> f3) {
        return AbstractManagedType.filter(original, result, f1, f2, f3, null);
    }

    static <T> T pick(Collection<T> original, Filter<T> f1) {
        return AbstractManagedType.pick(original, f1, null, null, null);
    }

    static <T> T pick(Collection<T> original, Filter<T> f1, Filter<T> f2) {
        return AbstractManagedType.pick(original, f1, f2, null, null);
    }

    static <T> T pick(Collection<T> original, Filter<T> f1, Filter<T> f2, Filter<T> f3) {
        return AbstractManagedType.pick(original, f1, f2, f3, null);
    }

    public static final class VersionAttributeFilter<X>
    implements Filter<Attribute<? super X, ?>> {
        private final boolean _invert;

        public VersionAttributeFilter() {
            this(false);
        }

        public VersionAttributeFilter(boolean inverted) {
            this._invert = inverted;
        }

        @Override
        public boolean selects(Attribute<? super X, ?> attr) {
            FieldMetaData fmd = ((Members.Member)attr).fmd;
            boolean result = fmd.isVersion();
            return this._invert ? !result : result;
        }

        @Override
        public IdAttributeFilter<X> inverse() {
            return new IdAttributeFilter(!this._invert);
        }
    }

    public static final class IdAttributeFilter<X>
    implements Filter<Attribute<? super X, ?>> {
        private final boolean _invert;

        public IdAttributeFilter() {
            this(false);
        }

        public IdAttributeFilter(boolean inverted) {
            this._invert = inverted;
        }

        @Override
        public boolean selects(Attribute<? super X, ?> attr) {
            boolean result = ((Members.Member)attr).fmd.isPrimaryKey();
            return this._invert ? !result : result;
        }

        @Override
        public IdAttributeFilter<X> inverse() {
            return new IdAttributeFilter<X>(!this._invert);
        }
    }

    public static final class EntryTypeFilter<X, K, V>
    implements Filter<Attribute<? super X, ?>> {
        private final Class<K> _keyType;
        private final Class<V> _valueType;
        private final boolean _invert;

        public EntryTypeFilter(Class<K> kType, Class<V> vType) {
            this(kType, vType, false);
        }

        public EntryTypeFilter(Class<K> kType, Class<V> vType, boolean inverted) {
            this._keyType = kType;
            this._valueType = vType;
            this._invert = inverted;
        }

        @Override
        public boolean selects(Attribute<? super X, ?> attr) {
            boolean result;
            boolean bl = result = !(!(attr instanceof MapAttribute) || this._keyType != null && ((MapAttribute)attr).getKeyType().getJavaType() != this._keyType || this._valueType != null && ((MapAttribute)attr).getElementType().getJavaType() != this._valueType);
            return this._invert ? !result : result;
        }

        public EntryTypeFilter<X, K, V> inverse() {
            return new EntryTypeFilter<X, K, V>(this._keyType, this._valueType, !this._invert);
        }
    }

    public static final class ElementTypeFilter<X, E>
    implements Filter<Attribute<? super X, ?>> {
        private final Class<E> _elementType;
        private final boolean _invert;

        public ElementTypeFilter(Class<E> eType) {
            this(eType, false);
        }

        public ElementTypeFilter(Class<E> eType, boolean inverted) {
            this._elementType = eType;
            this._invert = inverted;
        }

        @Override
        public boolean selects(Attribute<? super X, ?> attr) {
            boolean result;
            boolean bl = result = attr instanceof PluralAttribute && (this._elementType == null || ((PluralAttribute)attr).getElementType().getJavaType() == this._elementType);
            return this._invert ? !result : result;
        }

        public ElementTypeFilter<X, E> inverse() {
            return new ElementTypeFilter<X, E>(this._elementType, !this._invert);
        }
    }

    public static final class PluralCategoryFilter<X>
    implements Filter<Attribute<? super X, ?>> {
        private final PluralAttribute.CollectionType _category;
        private final boolean _invert;

        public PluralCategoryFilter(PluralAttribute.CollectionType category) {
            this(category, false);
        }

        public PluralCategoryFilter(PluralAttribute.CollectionType category, boolean inverted) {
            this._category = category;
            this._invert = inverted;
        }

        @Override
        public boolean selects(Attribute<? super X, ?> attr) {
            boolean result;
            boolean bl = result = attr instanceof PluralAttribute && ((PluralAttribute)attr).getCollectionType() == this._category;
            return this._invert ? !result : result;
        }

        @Override
        public PluralCategoryFilter<X> inverse() {
            return new PluralCategoryFilter<X>(this._category, !this._invert);
        }
    }

    public static final class AttributeNameFilter<X>
    implements Filter<Attribute<? super X, ?>> {
        private final String _name;
        private final boolean _invert;

        public AttributeNameFilter(String name) {
            this(name, false);
        }

        public AttributeNameFilter(String name, boolean inverted) {
            this._name = name;
            this._invert = inverted;
        }

        @Override
        public boolean selects(Attribute<? super X, ?> attr) {
            return this._invert ? !attr.getName().equals(this._name) : attr.getName().equals(this._name);
        }

        @Override
        public AttributeNameFilter<X> inverse() {
            return new AttributeNameFilter<X>(this._name, !this._invert);
        }
    }

    public static final class AttributeTypeFilter<X, Y>
    implements Filter<Attribute<? super X, ?>> {
        private final Class<Y> _type;
        private final boolean _invert;

        public AttributeTypeFilter(Class<Y> type) {
            this(type, false);
        }

        public AttributeTypeFilter(Class<Y> type, boolean inverted) {
            this._type = type;
            this._invert = inverted;
        }

        @Override
        public boolean selects(Attribute<? super X, ?> attr) {
            boolean result;
            boolean bl = result = this._type == null || Filters.canConvert(attr.getJavaType(), this._type, false);
            return this._invert ? !result : result;
        }

        public AttributeTypeFilter<X, Y> inverse() {
            return new AttributeTypeFilter<X, Y>(this._type, !this._invert);
        }
    }

    public static final class DeclaredAttributeFilter<X>
    implements Filter<Attribute<? super X, ?>> {
        private final ManagedType<X> owner;
        private final boolean _invert;

        DeclaredAttributeFilter(ManagedType<X> owner) {
            this(owner, false);
        }

        DeclaredAttributeFilter(ManagedType<X> owner, boolean inverted) {
            this.owner = owner;
            this._invert = inverted;
        }

        @Override
        public boolean selects(Attribute<? super X, ?> attr) {
            return this._invert ? attr.getDeclaringType() != this.owner : attr.getDeclaringType() == this.owner;
        }

        @Override
        public DeclaredAttributeFilter<X> inverse() {
            return new DeclaredAttributeFilter<X>(this.owner, !this._invert);
        }
    }

    public static final class SingularAttributeFilter<X>
    implements Filter<Attribute<? super X, ?>> {
        private final boolean _invert;

        public SingularAttributeFilter() {
            this(false);
        }

        public SingularAttributeFilter(boolean inverted) {
            this._invert = inverted;
        }

        @Override
        public boolean selects(Attribute<? super X, ?> attr) {
            return this._invert ? attr.isCollection() : !attr.isCollection();
        }

        @Override
        public SingularAttributeFilter<X> inverse() {
            return new SingularAttributeFilter<X>(!this._invert);
        }
    }

    public static interface Filter<T> {
        public boolean selects(T var1);

        public Filter<T> inverse();
    }
}

