/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.webservices;

import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.Filter;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.cxf.rs.CxfRsHttpListener;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.util.HttpUtil;
import org.apache.openejb.server.rest.RsRegistry;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.tomee.catalina.environment.Hosts;
import org.apache.tomee.loader.TomcatHelper;
import org.apache.tomee.webservices.CXFJAXRSFilter;

public class TomcatRsRegistry
implements RsRegistry {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_STARTUP, TomcatRsRegistry.class);
    private final Hosts hosts;
    private List<Connector> connectors;
    private final Map<String, HttpListener> listeners = new TreeMap<String, HttpListener>();

    public TomcatRsRegistry() {
        for (Service service : TomcatHelper.getServer().findServices()) {
            if (!(service.getContainer() instanceof Engine)) continue;
            this.connectors = Arrays.asList(service.findConnectors());
            break;
        }
        this.hosts = (Hosts)SystemInstance.get().getComponent(Hosts.class);
    }

    public RsRegistry.AddressInfo createRsHttpListener(String webContext, HttpListener listener, ClassLoader classLoader, String completePath, String virtualHost, String auth, String realm) {
        String path = webContext;
        if (path == null) {
            throw new NullPointerException("contextRoot is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        Context context = null;
        Host host = virtualHost == null ? this.hosts.getDefault() : this.hosts.get(virtualHost);
        if (host == null) {
            for (Host h : this.hosts) {
                context = TomcatRsRegistry.findContext((Container)h, webContext);
                if (context == null) continue;
                host = h;
                if (classLoader == null || !classLoader.equals(context.getLoader().getClassLoader())) continue;
                break;
            }
            if (host == null) {
                throw new IllegalArgumentException("Invalid virtual host '" + virtualHost + "'.  Do you have a matching Host entry in the server.xml?");
            }
        } else {
            context = TomcatRsRegistry.findContext((Container)host, webContext);
        }
        if (context == null) {
            throw new IllegalStateException("Invalid context '" + webContext + "'.  Cannot find context in host " + host.getName());
        }
        CxfRsHttpListener cxfRsHttpListener = this.findCxfRsHttpListener(listener);
        String description = "tomee-jaxrs-" + listener;
        String mapping = completePath;
        if (!completePath.endsWith("/*")) {
            if (completePath.endsWith("*")) {
                mapping = completePath.substring(0, completePath.length() - 1);
            }
            mapping = mapping + "/*";
        }
        String urlPattern = TomcatRsRegistry.removeWebContext(webContext, mapping);
        cxfRsHttpListener.setUrlPattern(urlPattern.substring(0, urlPattern.length() - 1));
        FilterDef filterDef = new FilterDef();
        filterDef.setAsyncSupported("true");
        filterDef.setDescription(description);
        filterDef.setFilterName(description);
        filterDef.setDisplayName(description);
        filterDef.setFilter((Filter)new CXFJAXRSFilter(cxfRsHttpListener, context.findWelcomeFiles()));
        filterDef.setFilterClass(CXFJAXRSFilter.class.getName());
        filterDef.addInitParameter("mapping", urlPattern.substring(0, urlPattern.length() - "/*".length()));
        context.addFilterDef(filterDef);
        FilterMap filterMap = new FilterMap();
        filterMap.addURLPattern(urlPattern);
        filterMap.setFilterName(filterDef.getFilterName());
        context.addFilterMap(filterMap);
        this.addFilterConfig(context, filterDef);
        path = TomcatRsRegistry.address(this.connectors, host.getName(), webContext);
        String key = TomcatRsRegistry.address(this.connectors, host.getName(), completePath);
        this.listeners.put(key, listener);
        return new RsRegistry.AddressInfo(path, key);
    }

    private void addFilterConfig(Context context, FilterDef filterDef) {
        try {
            Constructor cons = ApplicationFilterConfig.class.getDeclaredConstructor(Context.class, FilterDef.class);
            if (!cons.isAccessible()) {
                cons.setAccessible(true);
            }
            ApplicationFilterConfig config = (ApplicationFilterConfig)cons.newInstance(context, filterDef);
            ((Map)Reflections.get((Object)context, (String)"filterConfigs")).put(filterDef.getFilterName(), config);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private CxfRsHttpListener findCxfRsHttpListener(HttpListener listener) {
        return (CxfRsHttpListener)CxfRsHttpListener.class.cast(listener);
    }

    private static String removeWebContext(String webContext, String completePath) {
        if (webContext == null) {
            return completePath;
        }
        return completePath.substring((webContext.length() > 0 && !webContext.startsWith("/") ? 1 : 0) + webContext.length());
    }

    private static Context findContext(Container host, String webContext) {
        Context webapp = (Context)Context.class.cast(host.findChild(webContext));
        if (webapp == null && "/".equals(webContext)) {
            webapp = (Context)Context.class.cast(host.findChild(""));
        } else if (webapp == null && webContext.length() > 0 && !webContext.startsWith("/")) {
            webapp = (Context)Context.class.cast(host.findChild("/" + webContext));
        }
        return webapp;
    }

    private static String address(Collection<Connector> connectors, String host, String path) {
        ArrayList<String> addresses = new ArrayList<String>();
        for (Connector connector : connectors) {
            URI address;
            try {
                address = new URI(connector.getScheme(), null, host, connector.getPort(), path, null, null);
            }
            catch (Exception e) {
                LOGGER.error("can't add container for path " + path, (Throwable)e);
                continue;
            }
            addresses.add(address.toString());
        }
        return HttpUtil.selectSingleAddress(addresses);
    }

    public HttpListener removeListener(String completePath) {
        String path;
        if (completePath != null && this.listeners.containsKey(path = !(path = completePath).startsWith("/") && !path.startsWith("http://") && !path.startsWith("https://") ? "/" + path : completePath)) {
            return this.listeners.remove(path);
        }
        return null;
    }
}

