/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;
import org.apache.xbean.recipe.UnsetPropertiesRecipe;

public final class ServiceInfos {
    private ServiceInfos() {
    }

    public static Object resolve(Collection<ServiceInfo> services, String id) {
        if (id == null) {
            return null;
        }
        try {
            return ServiceInfos.build(services, ServiceInfos.find(services, id));
        }
        catch (OpenEJBException e) {
            throw new OpenEJBRuntimeException(e);
        }
    }

    public static ServiceInfo find(Collection<ServiceInfo> services, String id) {
        for (ServiceInfo s : services) {
            if (!id.equals(s.id)) continue;
            return s;
        }
        return null;
    }

    public static ServiceInfo findByClass(Collection<ServiceInfo> services, String clazz) {
        for (ServiceInfo s : services) {
            if (!clazz.equals(s.className)) continue;
            return s;
        }
        return null;
    }

    public static List<Object> resolve(Collection<ServiceInfo> serviceInfos, String[] ids) {
        return ServiceInfos.resolve(serviceInfos, ids, null);
    }

    public static List<Object> resolve(Collection<ServiceInfo> serviceInfos, String[] ids, Factory factory) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        ArrayList<Object> instances = new ArrayList<Object>();
        for (String id : ids) {
            Object instance = ServiceInfos.resolve(serviceInfos, id);
            if (instance == null) {
                try {
                    Class<?> aClass = Thread.currentThread().getContextClassLoader().loadClass(id);
                    instance = factory == null ? aClass.newInstance() : factory.newInstance(aClass);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (instance == null) {
                instance = ServiceInfos.resolve(SystemInstance.get().getComponent(OpenEjbConfiguration.class).facilities.services, id);
            }
            if (instance == null) continue;
            instances.add(instance);
        }
        return instances;
    }

    public static Properties serviceProperties(Collection<ServiceInfo> serviceInfos, String id) {
        if (id == null) {
            return null;
        }
        ServiceInfo info = ServiceInfos.find(serviceInfos, id);
        if (info == null) {
            return null;
        }
        return info.properties;
    }

    private static Object build(Collection<ServiceInfo> services, ServiceInfo info) throws OpenEJBException {
        if (info == null) {
            return null;
        }
        ObjectRecipe serviceRecipe = Assembler.prepareRecipe(info);
        return ServiceInfos.build(services, info, serviceRecipe);
    }

    public static Object build(Collection<ServiceInfo> services, ServiceInfo info, ObjectRecipe serviceRecipe) {
        if ("org.apache.openejb.config.sys.MapFactory".equals(info.className)) {
            return info.properties;
        }
        if (!info.properties.containsKey("properties")) {
            info.properties.put("properties", new UnsetPropertiesRecipe());
        }
        serviceRecipe.allow(Option.FIELD_INJECTION);
        serviceRecipe.allow(Option.PRIVATE_PROPERTIES);
        for (Map.Entry<Object, Object> entry : info.properties.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value instanceof String) {
                String valueStr = value.toString();
                if (valueStr.startsWith("$")) {
                    serviceRecipe.setProperty(key, ServiceInfos.resolve(services, valueStr.substring(1)));
                    continue;
                }
                if (valueStr.startsWith("@")) {
                    Context jndiContext = SystemInstance.get().getComponent(ContainerSystem.class).getJNDIContext();
                    try {
                        serviceRecipe.setProperty(key, jndiContext.lookup("openejb/Resource/" + valueStr.substring(1)));
                    }
                    catch (NamingException e) {
                        try {
                            serviceRecipe.setProperty(key, jndiContext.lookup(valueStr.substring(1)));
                        }
                        catch (NamingException e1) {
                            Logger.getInstance(LogCategory.OPENEJB, ServiceInfos.class).warning("Value " + valueStr + " starting with @ but doesn't point to an existing resource, using raw value");
                            serviceRecipe.setProperty(key, value);
                        }
                    }
                    continue;
                }
                serviceRecipe.setProperty(key, value);
                continue;
            }
            serviceRecipe.setProperty(key, entry.getValue());
        }
        Object service = serviceRecipe.create();
        SystemInstance.get().addObserver(service);
        Assembler.logUnusedProperties(serviceRecipe, info);
        return service;
    }

    public static interface Factory {
        public Object newInstance(Class<?> var1) throws Exception;
    }
}

