/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBElement;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.jee.jpa.EntityMappings;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.Jndi;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.jee.wls.JaxbWls;
import org.apache.openejb.jee.wls.WeblogicEjbJar;
import org.apache.openejb.jee.wls.WeblogicEnterpriseBean;
import org.apache.openejb.loader.IO;

public class WlsConversion
implements DynamicDeployer {
    @Override
    public AppModule deploy(AppModule appModule) {
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            this.convertModule(ejbModule, appModule.getCmpMappings());
        }
        return appModule;
    }

    private <T> T getDescriptor(EjbModule ejbModule, String descriptor, Class<T> type) {
        Object altDD = ejbModule.getAltDDs().get(descriptor);
        if (altDD instanceof String) {
            try {
                altDD = JaxbWls.unmarshal(type, (InputStream)new ByteArrayInputStream(((String)altDD).getBytes()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (altDD instanceof URL) {
            try {
                altDD = JaxbWls.unmarshal(type, (InputStream)IO.read((URL)altDD));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (altDD == null) {
            return null;
        }
        if (altDD instanceof JAXBElement) {
            JAXBElement jaxbElement = (JAXBElement)altDD;
            altDD = jaxbElement.getValue();
        }
        return (T)altDD;
    }

    public void convertModule(EjbModule ejbModule, EntityMappings entityMappings) {
        WeblogicEjbJar weblogicEjbJar = this.getDescriptor(ejbModule, "weblogic-ejb-jar.xml", WeblogicEjbJar.class);
        this.mergeEjbConfig(ejbModule, weblogicEjbJar);
    }

    private void mergeEjbConfig(EjbModule ejbModule, WeblogicEjbJar weblogicEjbJar) {
        OpenejbJar openejbJar = ejbModule.getOpenejbJar();
        if (openejbJar == null) {
            return;
        }
        if (weblogicEjbJar == null) {
            return;
        }
        if (weblogicEjbJar.getWeblogicEnterpriseBean().size() == 0) {
            return;
        }
        for (WeblogicEnterpriseBean ejb : weblogicEjbJar.getWeblogicEnterpriseBean()) {
            EjbDeployment deployment = (EjbDeployment)openejbJar.getDeploymentsByEjbName().get(ejb.getEjbName());
            if (deployment == null) continue;
            if (ejb.getJndiName() != null) {
                deployment.getJndi().add(new Jndi(ejb.getJndiName(), "RemoteHome"));
            }
            if (ejb.getLocalJndiName() == null) continue;
            deployment.getJndi().add(new Jndi(ejb.getLocalJndiName(), "LocalHome"));
        }
    }
}

