/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Set;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.classloader.URLClassLoaderFirst;
import org.apache.xbean.asm5.ClassReader;
import org.apache.xbean.asm5.ClassVisitor;
import org.apache.xbean.asm5.shade.commons.EmptyVisitor;

public class TempClassLoader
extends URLClassLoader {
    private static final ClassLoader PARENT_LOADER = ParentClassLoaderFinder.Helper.get();
    private final Set<Skip> skip;
    private final ClassLoader system;
    private final boolean embedded;
    private final ByteArrayOutputStream bout = new ByteArrayOutputStream(6144);

    public TempClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        this.skip = SystemInstance.get().getOptions().getAll("openejb.tempclassloader.skip", new Skip[]{Skip.NONE});
        this.system = ClassLoader.getSystemClassLoader();
        this.embedded = this.getClass().getClassLoader() == this.system;
    }

    public void skip(Skip s) {
        this.skip.add(s);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    public URL getResource(String name) {
        if (!name.startsWith("java/") && !name.startsWith("javax/") && name.endsWith(".class")) {
            try {
                Enumeration<URL> resources = this.getResources(name);
                if (!resources.hasMoreElements()) {
                    return null;
                }
                URL url = resources.nextElement();
                if (resources.hasMoreElements()) {
                    ArrayList<URL> l = new ArrayList<URL>(2);
                    l.add(url);
                    while (resources.hasMoreElements()) {
                        l.add(resources.nextElement());
                    }
                    Collections.sort(l, new ResourceComparator(this.getParent(), name));
                    return (URL)l.iterator().next();
                }
                return url;
            }
            catch (IOException e) {
                return super.getResource(name);
            }
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return URLClassLoaderFirst.filterResources(name, super.getResources(name));
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        String packageName;
        byte[] bytes;
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (this.skip(name) || name.startsWith("javax.faces.") && URLClassLoaderFirst.shouldSkipJsf(this.getParent(), name)) {
            return Class.forName(name, resolve, PARENT_LOADER);
        }
        if (!this.embedded && URLClassLoaderFirst.canBeLoadedFromSystem(name)) {
            try {
                c = this.system.loadClass(name);
                if (c != null) {
                    return c;
                }
            }
            catch (ClassNotFoundException ignored) {
            }
            catch (NoClassDefFoundError ignored) {
                // empty catch block
            }
        }
        String resourceName = name.replace('.', '/') + ".class";
        this.bout.reset();
        InputStream in = null;
        try {
            in = this.getResourceAsStream(resourceName);
            if (in != null && !(in instanceof BufferedInputStream)) {
                in = new BufferedInputStream(in);
            }
            if (in == null) {
                throw new ClassNotFoundException(name);
            }
            IO.copy(in, (OutputStream)this.bout);
            bytes = this.bout.toByteArray();
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        finally {
            IO.close(in);
        }
        if (this.skip.contains((Object)Skip.ANNOTATIONS) && TempClassLoader.isAnnotationClass(bytes)) {
            return Class.forName(name, resolve, PARENT_LOADER);
        }
        if (this.skip.contains((Object)Skip.ENUMS) && TempClassLoader.isEnum(bytes)) {
            return Class.forName(name, resolve, PARENT_LOADER);
        }
        int packageEndIndex = name.lastIndexOf(46);
        if (packageEndIndex != -1 && this.getPackage(packageName = name.substring(0, packageEndIndex)) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        try {
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        catch (SecurityException e) {
            return super.loadClass(name, resolve);
        }
        catch (LinkageError le) {
            return super.loadClass(name, resolve);
        }
    }

    private boolean skip(String name) {
        return this.skip.contains((Object)Skip.ALL) || URLClassLoaderFirst.shouldSkip(name);
    }

    private static boolean isEnum(byte[] bytes) {
        IsEnumVisitor isEnumVisitor = new IsEnumVisitor();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)isEnumVisitor, 2);
        return isEnumVisitor.isEnum;
    }

    private static boolean isAnnotationClass(byte[] bytes) {
        IsAnnotationVisitor isAnnotationVisitor = new IsAnnotationVisitor();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)isAnnotationVisitor, 2);
        return isAnnotationVisitor.isAnnotation;
    }

    private static final class ResourceComparator
    implements Comparator<URL> {
        private static final boolean FORCE_MAVEN_FIRST = "true".equals(SystemInstance.get().getProperty("openejb.classloader.force-maven", "false"));
        private static final ClassLoader STOP_LOADER = ClassLoader.getSystemClassLoader().getParent();
        private final ClassLoader loader;
        private final String name;

        private ResourceComparator(ClassLoader loader, String name) {
            this.loader = loader;
            this.name = name;
        }

        @Override
        public int compare(URL o1, URL o2) {
            int weight2;
            if (o1.equals(o2)) {
                return 0;
            }
            int weight1 = this.weight(o1);
            if (weight1 == (weight2 = this.weight(o2))) {
                String s1 = o1.toExternalForm().replace(File.separatorChar, '/');
                String s2 = o2.toExternalForm().replace(File.separatorChar, '/');
                if (FORCE_MAVEN_FIRST) {
                    if (s1.contains("/target/classes/")) {
                        return -1;
                    }
                    if (s2.contains("/target/classes/")) {
                        return 1;
                    }
                    if (s1.contains("/target/test-classes/")) {
                        return -1;
                    }
                    if (s2.contains("/target/test-classes/")) {
                        return 1;
                    }
                }
                if (s1.contains("/WEB-INF/classes/")) {
                    return -1;
                }
                if (s2.contains("/WEB-INF/classes/")) {
                    return 1;
                }
                return s1.compareTo(s2);
            }
            return weight1 - weight2;
        }

        private int weight(URL url) {
            int w = 0;
            ClassLoader c = this.loader;
            while (c != null) {
                try {
                    if (!Collections.list(c.getResources(this.name)).contains(url)) break;
                    ++w;
                }
                catch (IOException e) {
                    break;
                }
                if ((c = c.getParent()) != STOP_LOADER) continue;
                break;
            }
            return w;
        }
    }

    public static class IsEnumVisitor
    extends EmptyVisitor {
        public boolean isEnum;

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.isEnum = (access & 0x4000) != 0;
        }
    }

    public static class IsAnnotationVisitor
    extends EmptyVisitor {
        public boolean isAnnotation;

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.isAnnotation = (access & 0x2000) != 0;
        }
    }

    public static enum Skip {
        NONE,
        ANNOTATIONS,
        ENUMS,
        ALL;

    }
}

