/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public final class NetworkUtil {
    public static final String TOMEE_LOCK_FILE = "TOMEE_LOCK_FILE";
    public static final int[] RANDOM = new int[]{0};
    private static final ReentrantLock lock = new ReentrantLock();
    private static final ByteBuffer buf = ByteBuffer.allocate(512);
    public static final int PORT_MIN = 1025;
    public static final int PORT_MAX = 65535;
    public static final int EVICTION_TIMEOUT = Integer.getInteger("openejb.network.random-port.cache-timeout", 10000);
    private static File lockFile;

    private NetworkUtil() {
    }

    public static synchronized void clearLockFile() {
        System.clearProperty(TOMEE_LOCK_FILE);
        lockFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int getNextAvailablePortInDefaultRange() {
        ReentrantLock l = lock;
        l.lock();
        try {
            int n = NetworkUtil.getNextAvailablePort(1025, 65535, null);
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int getNextAvailablePort() {
        ReentrantLock l = lock;
        l.lock();
        try {
            int n = NetworkUtil.getNextAvailablePort(RANDOM);
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static synchronized int getNextAvailablePort(int[] portList) {
        int originalRetryCount;
        ReentrantLock l = lock;
        l.lock();
        int retry = originalRetryCount = Integer.getInteger("openejb.network.random-port.retries", 10).intValue();
        ServerSocket s = null;
        while (true) {
            try {
                s = NetworkUtil.create(portList, null);
                int n = s.getLocalPort();
                return n;
            }
            catch (IOException ioe) {
                boolean isRandom;
                boolean bl = isRandom = portList == RANDOM || portList.length == 1 && portList[0] == 0;
                retry = isRandom ? --retry : 0;
                if (retry > 0) continue;
                throw new IllegalStateException("Failed to find a port matching list " + Arrays.toString(portList) + (isRandom ? " with " + originalRetryCount + " retries" : ""));
            }
            finally {
                if (s == null) continue;
                try {
                    s.close();
                }
                catch (Throwable e) {}
                continue;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            break;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int getNextAvailablePort(int min, int max, Collection<Integer> excluded, Collection<LastPort> lastPorts) {
        ReentrantLock l = lock;
        l.lock();
        try {
            NetworkUtil.purgeLast(lastPorts);
            int port = -1;
            ServerSocket s = null;
            for (int i = min; i <= max; ++i) {
                if (excluded != null && excluded.contains(i) || i > 65535 || i < 1025) continue;
                try {
                    s = NetworkUtil.create(new int[]{i}, lastPorts);
                    port = s.getLocalPort();
                    break;
                }
                catch (IOException ioe) {
                    port = -1;
                    continue;
                }
                finally {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable e) {}
                    }
                }
            }
            int n = port;
            return n;
        }
        finally {
            l.unlock();
        }
    }

    public static synchronized int getNextAvailablePort(int min, int max, Collection<Integer> excluded) {
        return NetworkUtil.getNextAvailablePort(min, max, excluded, null);
    }

    private static void purgeLast(Collection<LastPort> lastPort) {
        if (lastPort == null) {
            return;
        }
        Iterator<LastPort> it = lastPort.iterator();
        while (it.hasNext()) {
            LastPort last = it.next();
            if (System.currentTimeMillis() - last.time < (long)EVICTION_TIMEOUT) continue;
            it.remove();
        }
    }

    private static ServerSocket create(int[] ports, Collection<LastPort> lastPort) throws IOException {
        for (int port : ports) {
            try {
                ServerSocket ss = new ServerSocket(port);
                port = ss.getLocalPort();
                LastPort lp = new LastPort(port, System.currentTimeMillis());
                if (lastPort != null && lastPort.contains(lp)) {
                    try {
                        ss.close();
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (!NetworkUtil.checkLockFile(port)) {
                    try {
                        ss.close();
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (lastPort != null) {
                    lastPort.add(lp);
                }
                return ss;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        throw new IOException("No free port found");
    }

    private static File getLockFile() {
        if (null == lockFile) {
            String lf = System.getenv(TOMEE_LOCK_FILE);
            String string = lf = null != lf ? lf : System.getProperty(TOMEE_LOCK_FILE);
            if (null != lf) {
                File f = new File(lf);
                try {
                    lockFile = !f.exists() && !f.createNewFile() ? null : (f.isFile() ? f : null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return lockFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkLockFile(int port) {
        boolean result = true;
        File lf = NetworkUtil.getLockFile();
        if (null != lf) {
            Properties p = new Properties();
            RandomAccessFile raf = null;
            ByteArrayOutputStream baos = null;
            ByteArrayInputStream bais = null;
            FileLock lock = null;
            try {
                raf = new RandomAccessFile(lf, "rw");
                FileChannel fileChannel = raf.getChannel();
                int i = 0;
                while ((lock = fileChannel.tryLock()) == null) {
                    Thread.sleep(10L);
                    if (++i <= 200) continue;
                    boolean bl = false;
                    return bl;
                }
                baos = new ByteArrayOutputStream();
                while (fileChannel.read(buf) > 0) {
                    baos.write((byte[])buf.flip().array());
                    buf.clear();
                }
                bais = new ByteArrayInputStream(baos.toByteArray());
                p.load(bais);
                boolean purged = NetworkUtil.purgeOld(p);
                if (null != p.getProperty(String.valueOf(port))) {
                    result = false;
                } else {
                    p.setProperty(String.valueOf(port), String.valueOf(System.currentTimeMillis()));
                }
                if (result || purged) {
                    baos.reset();
                    p.store(baos, "TomEE port locks");
                    fileChannel.truncate(0L);
                    fileChannel.write(ByteBuffer.wrap(baos.toByteArray()));
                }
            }
            catch (Exception e) {
                result = false;
            }
            finally {
                if (null != lock) {
                    try {
                        lock.release();
                    }
                    catch (Exception e) {}
                }
                if (null != baos) {
                    try {
                        baos.close();
                    }
                    catch (Exception e) {}
                }
                if (null != bais) {
                    try {
                        bais.close();
                    }
                    catch (Exception e) {}
                }
                if (null != raf) {
                    try {
                        raf.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return result;
    }

    private static boolean purgeOld(Properties p) {
        boolean purged = false;
        long now = System.currentTimeMillis();
        Set<String> names = p.stringPropertyNames();
        for (String key : names) {
            String value = p.getProperty(key);
            if (!NetworkUtil.isOld(now, value)) continue;
            purged = true;
            p.remove(key);
        }
        return purged;
    }

    private static boolean isOld(long now, String value) {
        try {
            return now - Long.parseLong(value) > 30000L;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static String getLocalAddress(String start, String end) {
        return start + "localhost:" + NetworkUtil.getNextAvailablePort() + end;
    }

    public static boolean isLocalAddress(String addr) {
        try {
            return NetworkUtil.isLocalAddress(InetAddress.getByName(addr));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isLocalAddress(InetAddress addr) {
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    public static final class LastPort {
        private final int port;
        private final long time;

        private LastPort(int port, long time) {
            this.port = port;
            this.time = time;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LastPort lastPort = (LastPort)o;
            return this.port == lastPort.port;
        }

        public int hashCode() {
            return this.port;
        }
    }
}

