/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.rs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.AnnotationLiteral;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.jaxrs.JAXRSBindingFactory;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.openejb.cdi.WebBeansContextCreated;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.rest.AbstractRestThreadLocalProxy;
import org.apache.openejb.rest.RESTResourceFinder;
import org.apache.openejb.rest.ThreadLocalContextManager;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.cxf.rs.CxfRESTResourceFinder;
import org.apache.openejb.server.cxf.rs.CxfRsHttpListener;
import org.apache.openejb.server.cxf.transport.HttpTransportFactory;
import org.apache.openejb.server.cxf.transport.util.CxfUtil;
import org.apache.openejb.server.rest.RESTService;
import org.apache.openejb.server.rest.RsHttpListener;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.annotation.EmptyAnnotationLiteral;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;

public class CxfRSService
extends RESTService {
    private static final String NAME = "cxf-rs";
    private HttpTransportFactory httpTransportFactory;

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName() + " cannot be invoked directly");
    }

    public void service(Socket socket) throws ServiceException, IOException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName() + " cannot be invoked directly");
    }

    public String getName() {
        return NAME;
    }

    public void integrateCDIAndJaxRsInjections(@Observes WebBeansContextCreated event) {
        this.contextCDIIntegration(event.getContext());
    }

    private void contextCDIIntegration(WebBeansContext wbc) {
        BeanManagerImpl beanManagerImpl = wbc.getBeanManagerImpl();
        beanManagerImpl.addAdditionalQualifier(Context.class);
        beanManagerImpl.addInternalBean(new ContextBean<SecurityContext>(SecurityContext.class, (AbstractRestThreadLocalProxy<SecurityContext>)ThreadLocalContextManager.SECURITY_CONTEXT));
        beanManagerImpl.addInternalBean(new ContextBean<UriInfo>(UriInfo.class, (AbstractRestThreadLocalProxy<UriInfo>)ThreadLocalContextManager.URI_INFO));
        beanManagerImpl.addInternalBean(new ContextBean<HttpServletRequest>(HttpServletRequest.class, (AbstractRestThreadLocalProxy<HttpServletRequest>)ThreadLocalContextManager.HTTP_SERVLET_REQUEST));
        beanManagerImpl.addInternalBean(new ContextBean<HttpServletResponse>(HttpServletResponse.class, (AbstractRestThreadLocalProxy<HttpServletResponse>)ThreadLocalContextManager.HTTP_SERVLET_RESPONSE));
        beanManagerImpl.addInternalBean(new ContextBean<HttpHeaders>(HttpHeaders.class, (AbstractRestThreadLocalProxy<HttpHeaders>)ThreadLocalContextManager.HTTP_HEADERS));
        beanManagerImpl.addInternalBean(new ContextBean<Request>(Request.class, (AbstractRestThreadLocalProxy<Request>)ThreadLocalContextManager.REQUEST));
        beanManagerImpl.addInternalBean(new ContextBean<ServletRequest>(ServletRequest.class, (AbstractRestThreadLocalProxy<ServletRequest>)ThreadLocalContextManager.SERVLET_REQUEST));
        beanManagerImpl.addInternalBean(new ContextBean<ServletContext>(ServletContext.class, (AbstractRestThreadLocalProxy<ServletContext>)ThreadLocalContextManager.SERVLET_CONTEXT));
        beanManagerImpl.addInternalBean(new ContextBean<ServletConfig>(ServletConfig.class, (AbstractRestThreadLocalProxy<ServletConfig>)ThreadLocalContextManager.SERVLET_CONFIG));
        beanManagerImpl.addInternalBean(new ContextBean<Providers>(Providers.class, (AbstractRestThreadLocalProxy<Providers>)ThreadLocalContextManager.PROVIDERS));
        beanManagerImpl.addInternalBean(new ContextBean<ContextResolver>(ContextResolver.class, (AbstractRestThreadLocalProxy<ContextResolver>)ThreadLocalContextManager.CONTEXT_RESOLVER));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Properties properties) throws Exception {
        super.init(properties);
        SystemInstance.get().setComponent(RESTResourceFinder.class, (Object)new CxfRESTResourceFinder());
        CxfUtil.configureBus();
        Bus bus = CxfUtil.getBus();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
        try {
            if (!CxfUtil.hasService((String)"http://apache.org/cxf/binding/jaxrs")) {
                BindingFactoryManager bfm = (BindingFactoryManager)bus.getExtension(BindingFactoryManager.class);
                try {
                    bfm.registerBindingFactory("http://apache.org/cxf/binding/jaxrs", (BindingFactory)new JAXRSBindingFactory(bus));
                }
                catch (Throwable b) {
                    // empty catch block
                }
            }
        }
        finally {
            if (oldLoader != null) {
                CxfUtil.clearBusLoader((ClassLoader)oldLoader);
            }
        }
    }

    public void stop() throws ServiceException {
        super.stop();
        CxfUtil.release();
    }

    protected void beforeStart() {
        super.beforeStart();
        this.httpTransportFactory = new HttpTransportFactory(CxfUtil.getBus());
    }

    protected boolean containsJaxRsConfiguration(Properties properties) {
        return properties.containsKey("cxf.jaxrs.providers") || properties.containsKey("cxf.jaxrs.in-fault-interceptors") || properties.containsKey("cxf.jaxrs.in-interceptors") || properties.containsKey("cxf.jaxrs.out-fault-interceptors") || properties.containsKey("cxf.jaxrs.out-interceptors") || properties.containsKey("cxf.jaxrs.databinding") || properties.containsKey("cxf.jaxrs.features") || properties.containsKey("cxf.jaxrs.address") || properties.containsKey("cxf.jaxrs.properties");
    }

    protected RsHttpListener createHttpListener() {
        return new CxfRsHttpListener((HTTPTransportFactory)this.httpTransportFactory, this.getWildcard());
    }

    private static class DelegateHandler<T>
    implements InvocationHandler {
        private final AbstractRestThreadLocalProxy<T> proxy;

        public DelegateHandler(AbstractRestThreadLocalProxy<T> proxy) {
            this.proxy = proxy;
        }

        @Override
        public Object invoke(Object ignored, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(this.proxy.get(), args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }
    }

    private static class ContextBean<T>
    implements Bean<T> {
        private final Class<T> type;
        private final Set<Type> types;
        private final Set<Annotation> qualifiers;
        private final T proxy;

        public ContextBean(Class<T> type, AbstractRestThreadLocalProxy<T> proxy) {
            this.type = type;
            this.proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{type, Serializable.class}, new DelegateHandler<T>(proxy));
            this.types = new HashSet<Class>(Arrays.asList(Object.class, type));
            this.qualifiers = new HashSet<AnnotationLiteral>(Arrays.asList(ContextLiteral.INSTANCE, AnyLiteral.INSTANCE));
        }

        public Set<Type> getTypes() {
            return this.types;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return ApplicationScoped.class;
        }

        public String getName() {
            return null;
        }

        public boolean isNullable() {
            return false;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }

        public Class<?> getBeanClass() {
            return this.type;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public boolean isAlternative() {
            return false;
        }

        public T create(CreationalContext<T> tCreationalContext) {
            return this.proxy;
        }

        public void destroy(T t, CreationalContext<T> tCreationalContext) {
        }
    }

    private static class ContextLiteral
    extends EmptyAnnotationLiteral<Context>
    implements Context {
        private static final long serialVersionUID = 1L;
        public static final AnnotationLiteral<Context> INSTANCE = new ContextLiteral();

        private ContextLiteral() {
        }
    }
}

