/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.concurrencyutilities.ee.factory;

import java.util.AbstractQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import javax.enterprise.concurrent.ManagedThreadFactory;
import org.apache.openejb.concurrencyutilities.ee.impl.ManagedExecutorServiceImpl;
import org.apache.openejb.concurrencyutilities.ee.impl.ManagedThreadFactoryImpl;
import org.apache.openejb.concurrencyutilities.ee.reject.CURejectHandler;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class ManagedExecutorServiceImplFactory {
    private int core = 5;
    private int max = 25;
    private Duration keepAlive = new Duration("5 second");
    private int queue = 15;
    private String threadFactory;

    public ManagedExecutorServiceImpl create() {
        return new ManagedExecutorServiceImpl(this.createExecutorService());
    }

    private ExecutorService createExecutorService() {
        ManagedThreadFactory managedThreadFactory;
        AbstractQueue blockingQueue = this.queue <= 0 ? new LinkedBlockingQueue() : new ArrayBlockingQueue(this.queue);
        try {
            managedThreadFactory = (ManagedThreadFactory)ManagedThreadFactory.class.cast(Thread.currentThread().getContextClassLoader().loadClass(this.threadFactory).newInstance());
        }
        catch (Exception e) {
            Logger.getInstance((LogCategory)LogCategory.OPENEJB, ManagedExecutorServiceImplFactory.class).warning("Can't create configured thread factory: " + this.threadFactory, (Throwable)e);
            managedThreadFactory = new ManagedThreadFactoryImpl();
        }
        return new ThreadPoolExecutor(this.core, this.max, this.keepAlive.getTime(), this.keepAlive.getUnit(), (BlockingQueue<Runnable>)((Object)blockingQueue), (ThreadFactory)managedThreadFactory, CURejectHandler.INSTANCE);
    }

    public void setCore(int core) {
        this.core = core;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void setKeepAlive(Duration keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setQueue(int queue) {
        this.queue = queue;
    }

    public void setThreadFactory(String threadFactory) {
        this.threadFactory = threadFactory;
    }
}

