/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.concurrencyutilities.ee.task;

import java.util.concurrent.Callable;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.concurrencyutilities.ee.task.ManagedTaskListenerTask;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.SecurityService;

public abstract class CUTask<T>
extends ManagedTaskListenerTask {
    private static final SecurityService<?> SECURITY_SERVICE = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
    private final Context initialContext = new Context(SECURITY_SERVICE.currentState(), ThreadContext.getThreadContext(), Thread.currentThread().getContextClassLoader());

    public CUTask(Object task) {
        super(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T invoke(Callable<T> call) throws Exception {
        this.initialContext.enter();
        Throwable throwable = null;
        try {
            this.taskStarting(this.future, this.executor, this.delegate);
            T t = call.call();
            return t;
        }
        catch (Throwable t) {
            throwable = t;
            this.taskAborted(throwable);
            T t2 = this.rethrow(t);
            return t2;
        }
        finally {
            this.taskDone(this.future, this.executor, this.delegate, throwable);
            this.initialContext.exit();
        }
    }

    private T rethrow(Throwable t) throws Exception {
        if (Exception.class.isInstance(t)) {
            throw (Exception)Exception.class.cast(t);
        }
        if (Error.class.isInstance(t)) {
            throw (Error)Error.class.cast(t);
        }
        throw new OpenEJBRuntimeException(t.getMessage(), t);
    }

    private static class Context {
        private final Object securityServiceState;
        private final ThreadContext threadContext;
        private final ClassLoader loader;
        private Context currentContext = null;

        private Context(Object initialSecurityServiceState, ThreadContext initialThreadContext, ClassLoader initialLoader) {
            this.securityServiceState = initialSecurityServiceState;
            this.threadContext = initialThreadContext;
            this.loader = initialLoader;
        }

        public void enter() {
            Thread thread = Thread.currentThread();
            ClassLoader oldCl = thread.getContextClassLoader();
            thread.setContextClassLoader(this.loader);
            ThreadContext oldCtx = this.threadContext != null ? ThreadContext.enter((ThreadContext)new ThreadContext(this.threadContext)) : null;
            Object threadState = SECURITY_SERVICE.currentState();
            SECURITY_SERVICE.setState(this.securityServiceState);
            this.currentContext = new Context(threadState, oldCtx, oldCl);
        }

        public void exit() {
            SECURITY_SERVICE.setState(this.currentContext.securityServiceState);
            if (this.currentContext.threadContext != null) {
                ThreadContext.exit((ThreadContext)this.currentContext.threadContext);
            }
            Thread.currentThread().setContextClassLoader(this.currentContext.loader);
            this.currentContext = null;
        }
    }
}

