/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.tomcat.loader;

import java.io.File;
import java.util.Properties;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.openejb.tomcat.loader.TomcatEmbedder;

public class OpenEJBListener
implements LifecycleListener {
    private static boolean listenerInstalled;

    public static boolean isListenerInstalled() {
        return listenerInstalled;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if (listenerInstalled) {
            return;
        }
        listenerInstalled = true;
        Properties properties = new Properties();
        File webappDir = OpenEJBListener.findOpenEjbWar();
        properties.setProperty("openejb.war", webappDir.getAbsolutePath());
        properties.setProperty("openejb.embedder.source", this.getClass().getSimpleName());
        TomcatEmbedder.embed(properties, StandardServer.class.getClassLoader());
    }

    private static File findOpenEjbWar() {
        String catalinaBase = System.getProperty("catalina.base");
        File serverWebapps = new File(catalinaBase, "server/webapps");
        File openEjbWar = OpenEJBListener.findOpenEjbWar(serverWebapps);
        if (openEjbWar != null) {
            return openEjbWar;
        }
        for (Service service : ServerFactory.getServer().findServices()) {
            Container container = service.getContainer();
            if (!(container instanceof StandardEngine)) continue;
            StandardEngine engine = (StandardEngine)container;
            for (Container child : engine.findChildren()) {
                if (!(child instanceof StandardHost)) continue;
                StandardHost host = (StandardHost)child;
                String appBase = host.getAppBase();
                File hostDir = new File(appBase);
                if (!hostDir.isAbsolute()) {
                    hostDir = new File(catalinaBase, appBase);
                }
                if ((openEjbWar = OpenEJBListener.findOpenEjbWar(hostDir)) != null) {
                    return openEjbWar;
                }
                return OpenEJBListener.findOpenEjbWar(host);
            }
        }
        return null;
    }

    private static File findOpenEjbWar(StandardHost standardHost) {
        for (Container container : standardHost.findChildren()) {
            File openEjbWar;
            StandardContext standardContext;
            File contextDocBase;
            if (!(container instanceof StandardContext) || !(contextDocBase = new File((standardContext = (StandardContext)container).getDocBase())).isDirectory() || (openEjbWar = OpenEJBListener.findOpenEjbWarInContext(contextDocBase)) == null) continue;
            return openEjbWar;
        }
        return null;
    }

    private static File findOpenEjbWar(File hostDir) {
        if (!hostDir.isDirectory()) {
            return null;
        }
        for (File contextDir : hostDir.listFiles()) {
            File foundContextDir = OpenEJBListener.findOpenEjbWarInContext(contextDir);
            if (foundContextDir == null) continue;
            return foundContextDir;
        }
        return null;
    }

    private static File findOpenEjbWarInContext(File contextDir) {
        File webInfLib = new File(new File(contextDir, "WEB-INF"), "lib");
        if (!webInfLib.isDirectory()) {
            return null;
        }
        for (File file : webInfLib.listFiles()) {
            if (!file.getName().startsWith("openejb-tomcat-loader-") || !file.getName().endsWith(".jar") || !new File(contextDir, "lib").isDirectory()) continue;
            return contextDir;
        }
        return null;
    }
}

