/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.tomcat.loader;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.security.Principal;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Realm;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;

public class TomcatHelper {
    private static boolean stopping = false;

    public static boolean isStopping() {
        return stopping;
    }

    public static void setStopping(boolean stopping) {
        TomcatHelper.stopping = stopping;
    }

    public static StandardServer getServer() {
        StandardServer server = null;
        try {
            Class<?> tomcatServerFactory = Class.forName("org.apache.catalina.ServerFactory");
            Method getServerMethod = tomcatServerFactory.getMethod("getServer", new Class[0]);
            server = (StandardServer)getServerMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (server != null) {
            return server;
        }
        try {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            server = (StandardServer)mbeanServer.getAttribute(new ObjectName("Catalina:type=Server"), "managedResource");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return server;
    }

    public static int getContextState(StandardContext standardContext) {
        try {
            Method getStateMethod = StandardContext.class.getMethod("getState", new Class[0]);
            Object result = getStateMethod.invoke((Object)standardContext, new Object[0]);
            if (Integer.TYPE.equals(result.getClass())) {
                int state = (Integer)result;
                return state;
            }
            if (result.getClass().isEnum()) {
                Enum e = (Enum)result;
                if ("FAILED".equals(e.toString())) {
                    return 4;
                }
                if ("STOPPING".equals(e.toString()) || "STOPPING_PREP".equals(e.toString()) || "MUST_STOP".equals(e.toString()) || "MUST_DESTROY".equals(e.toString())) {
                    return 2;
                }
                if ("RUNNING".equals(e.toString()) || "STARTED".equals(e.toString())) {
                    return 1;
                }
                if ("INITIALIZED".equals(e.toString())) {
                    return 0;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 3;
    }

    public static boolean hasRole(Realm realm, Principal tomcatPrincipal, String logicalRole) {
        Method method = null;
        try {
            if (TomcatHelper.isTomcat7()) {
                method = realm.getClass().getMethod("hasRole", Wrapper.class, Principal.class, String.class);
                return (Boolean)method.invoke((Object)realm, null, tomcatPrincipal, logicalRole);
            }
            method = realm.getClass().getMethod("hasRole", Principal.class, String.class);
            return (Boolean)method.invoke((Object)realm, tomcatPrincipal, logicalRole);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isTomcat7() {
        return System.getProperty("tomcat.version").startsWith("7.");
    }

    public static void configureJarScanner(StandardContext standardContext) {
        try {
            Class<?> cls = Class.forName("org.apache.openejb.tomcat.loader.TomEEJarScanner");
            Class<?> jarScannerCls = Class.forName("org.apache.tomcat.JarScanner");
            Object instance = cls.newInstance();
            StandardContext.class.getMethod("setJarScanner", jarScannerCls).invoke((Object)standardContext, instance);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getJarsToSkip() {
        File openejbApp = new File(System.getProperty("openejb.war"));
        File libFolder = new File(openejbApp, "lib");
        StringBuilder builder = new StringBuilder();
        for (File f : libFolder.listFiles()) {
            if (f.getName().startsWith("javaee-api-embedded") || f.getName().startsWith("myfaces") || !f.getName().toLowerCase().endsWith(".jar")) continue;
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(f.getName());
        }
        return builder.toString();
    }
}

