/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject.xml;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.spi.CreationalContext;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.InjectableConstructor;
import org.apache.webbeans.inject.xml.XMLInjectionPointModel;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.SecurityUtil;

public class XMLInjectableConstructor<T>
extends InjectableConstructor<T> {
    private List<XMLInjectionPointModel> injectionPointModelList = new ArrayList<XMLInjectionPointModel>();

    public XMLInjectableConstructor(Constructor<T> constructor, AbstractOwbBean<?> owner, CreationalContext<?> creationalContext) {
        super(constructor, owner, creationalContext);
    }

    @Override
    public T doInjection() {
        T instance = null;
        ArrayList list = new ArrayList();
        for (XMLInjectionPointModel model : this.injectionPointModelList) {
            Annotation[] anns = new Annotation[model.getBindingTypes().size()];
            anns = model.getBindingTypes().toArray(anns);
        }
        try {
            if (!this.con.isAccessible()) {
                SecurityUtil.doPrivilegedSetAccessible(this.con, true);
            }
            instance = this.con.newInstance(list.toArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WebBeansException(e);
        }
        return instance;
    }

    public Constructor<T> getConstructor() {
        return this.con;
    }

    public void addInjectionPointModel(XMLInjectionPointModel model) {
        Asserts.assertNotNull(model, "model parameter can not be null");
        this.injectionPointModelList.add(model);
    }
}

