/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject.xml;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.webbeans.inject.xml.XMLInjectionModelType;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;

public class XMLInjectionPointModel {
    private Class<?> injectionClassType;
    private boolean parametrized;
    private Type[] actualTypeArguments = new Type[0];
    private Set<Annotation> bindingTypes = new HashSet<Annotation>();
    private Set<Annotation> annotations = new HashSet<Annotation>();
    private Type injectionGenericType;
    private Member injectionMember;
    private XMLInjectionModelType type;
    private boolean array;

    public XMLInjectionPointModel(Class<?> arrayElementType) {
        this.array = true;
        this.injectionClassType = arrayElementType;
        this.injectionGenericType = arrayElementType;
    }

    public XMLInjectionPointModel(Class<?> injectionClassType, Type[] actualTypeArguments) {
        this.injectionClassType = injectionClassType;
        this.injectionGenericType = injectionClassType;
        if (actualTypeArguments != null && actualTypeArguments.length > 0) {
            this.actualTypeArguments = actualTypeArguments;
        }
        if (ClassUtil.isDefinitionConstainsTypeVariables(this.injectionClassType)) {
            this.parametrized = true;
        }
    }

    public void addBindingType(Annotation bindingType) {
        this.bindingTypes.add(bindingType);
    }

    public Class<?> getInjectionClassType() {
        return this.injectionClassType;
    }

    public boolean isParametrized() {
        return this.parametrized;
    }

    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    public Set<Annotation> getBindingTypes() {
        return Collections.unmodifiableSet(this.bindingTypes);
    }

    public Set<Annotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public boolean isArray() {
        return this.array;
    }

    public void addAnnotation(Annotation annotation) {
        Asserts.assertNotNull(annotation, "annotation parameter can not be null");
        this.annotations.add(annotation);
    }

    public Type getInjectionGenericType() {
        return this.injectionGenericType;
    }

    public Member getInjectionMember() {
        return this.injectionMember;
    }

    public void setInjectionMember(Member injectionMember) {
        this.injectionMember = injectionMember;
    }

    public XMLInjectionModelType getType() {
        return this.type;
    }

    public void setType(XMLInjectionModelType type) {
        this.type = type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.actualTypeArguments);
        result = 31 * result + (this.bindingTypes == null ? 0 : ((Object)this.bindingTypes).hashCode());
        result = 31 * result + (this.injectionClassType == null ? 0 : this.injectionClassType.hashCode());
        result = 31 * result + (this.parametrized ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMLInjectionPointModel other = (XMLInjectionPointModel)obj;
        if (!Arrays.equals(this.actualTypeArguments, other.actualTypeArguments)) {
            return false;
        }
        if (this.bindingTypes == null ? other.bindingTypes != null : !((Object)this.bindingTypes).equals(other.bindingTypes)) {
            return false;
        }
        if (this.injectionClassType == null ? other.injectionClassType != null : !this.injectionClassType.equals(other.injectionClassType)) {
            return false;
        }
        return this.parametrized == other.parametrized;
    }
}

