/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.xml;

import java.io.IOException;
import java.io.InputStream;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.util.WebBeansUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebBeansResolver
implements EntityResolver {
    private static WebBeansLogger logger = WebBeansLogger.getLogger(WebBeansResolver.class);

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        logger.debug("Resolving systemId with : [{0}]", systemId);
        if (systemId.equals("http://java.sun.com/jee/web-beans-1.0.xsd")) {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream("org/apache/webbeans/web-beans-1.0.xsd");
            if (stream != null) {
                logger.debug("Resolving is successful with systemId : [{0}]", systemId);
                return this.createInputSource(stream, publicId, systemId);
            }
        } else if (systemId.startsWith("classpath:")) {
            String path = systemId.replaceFirst("classpath:", "");
            InputStream stream = WebBeansUtil.getCurrentClassLoader().getResourceAsStream(path);
            if (stream != null) {
                logger.debug("Resolving is successful with systemId : [{0}]", systemId);
                return this.createInputSource(stream, publicId, systemId);
            }
        }
        logger.debug("Resolving failed using default SAXResolver for systemId : [{0}]", systemId);
        return null;
    }

    private InputSource createInputSource(InputStream stream, String publicId, String systemId) {
        InputSource source = new InputSource();
        source.setPublicId(publicId);
        source.setSystemId(systemId);
        source.setByteStream(stream);
        return source;
    }
}

