/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.tomcat;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import org.apache.AnnotationProcessor;
import org.apache.webbeans.web.tomcat.TomcatUtil;

public class TomcatAnnotProcessor
implements AnnotationProcessor {
    private AnnotationProcessor processor;
    private ClassLoader loader;
    private Map<Object, Object> objects = new ConcurrentHashMap<Object, Object>();

    public TomcatAnnotProcessor(ClassLoader loader, AnnotationProcessor processor) {
        this.processor = processor;
        this.loader = loader;
    }

    public void postConstruct(Object obj) throws IllegalAccessException, InvocationTargetException {
        this.processor.postConstruct(obj);
    }

    public void preDestroy(Object obj) throws IllegalAccessException, InvocationTargetException {
        Object injectorInstance = this.objects.get(obj);
        if (injectorInstance != null) {
            try {
                TomcatUtil.destroy(injectorInstance, this.loader);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.processor.preDestroy(obj);
    }

    public void processAnnotations(Object obj) throws IllegalAccessException, InvocationTargetException, NamingException {
        this.processor.processAnnotations(obj);
        try {
            Object injectorInstance = TomcatUtil.inject(obj, this.loader);
            if (injectorInstance != null) {
                this.objects.put(obj, injectorInstance);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

