/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;
import org.apache.phoenix.pherf.exception.PherfException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceList {
    private static final Logger logger = LoggerFactory.getLogger(ResourceList.class);
    private final String rootResourceDir;

    public ResourceList(String rootResourceDir) {
        this.rootResourceDir = rootResourceDir;
    }

    public Collection<Path> getResourceList(String pattern) throws Exception {
        Collection<Path> paths = this.getResourcesPaths(Pattern.compile(pattern));
        return paths;
    }

    private Collection<Path> getResourcesPaths(Pattern pattern) throws Exception {
        String classPath = System.getProperty("java.class.path", ".");
        String[] classPathElements = classPath.split(":");
        ArrayList<String> strResources = new ArrayList<String>();
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String element : classPathElements) {
            strResources.addAll(this.getResources(element, pattern));
        }
        for (String resource : strResources) {
            URL url = null;
            URI uri = null;
            Path path = null;
            String rName = this.rootResourceDir + resource;
            logger.debug("Trying with the root append.");
            url = ResourceList.class.getResource(rName);
            if (url == null) {
                logger.debug("Failed! Must be using a jar. Trying without the root append.");
                url = ResourceList.class.getResource(resource);
                if (url == null) {
                    throw new PherfException("Could not load resources: " + rName);
                }
                String[] splits = url.toString().split("!");
                uri = URI.create(splits[0]);
                path = splits.length < 2 ? Paths.get(uri) : Paths.get(splits[1], new String[0]);
            } else {
                path = Paths.get(url.toURI());
            }
            logger.debug("Found the correct resource: " + path.toString());
            paths.add(path);
        }
        return paths;
    }

    private Collection<String> getResources(String element, Pattern pattern) {
        ArrayList<String> retVal = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)element)) {
            return retVal;
        }
        File file = new File(element);
        if (file.isDirectory()) {
            retVal.addAll(this.getResourcesFromDirectory(file, pattern));
        } else {
            retVal.addAll(this.getResourcesFromJarFile(file, pattern));
        }
        return retVal;
    }

    Collection<String> getResourcesFromJarFile(File file, Pattern pattern) {
        ZipFile zf;
        ArrayList<String> retVal = new ArrayList<String>();
        try {
            zf = new ZipFile(file);
        }
        catch (FileNotFoundException e) {
            return Collections.emptyList();
        }
        catch (ZipException e) {
            throw new Error(e);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String fileName = ze.getName();
            boolean accept = pattern.matcher(fileName).matches();
            logger.trace("fileName:" + fileName);
            logger.trace("File:" + file.toString());
            logger.trace("Match:" + accept);
            if (!accept) continue;
            logger.trace("Adding File from Jar: " + fileName);
            retVal.add("/" + fileName);
        }
        try {
            zf.close();
        }
        catch (IOException e1) {
            throw new Error(e1);
        }
        return retVal;
    }

    private Collection<String> getResourcesFromDirectory(File directory, Pattern pattern) {
        File[] fileList;
        ArrayList<String> retval = new ArrayList<String>();
        for (File file : fileList = directory.listFiles()) {
            if (file.isDirectory()) {
                retval.addAll(this.getResourcesFromDirectory(file, pattern));
                continue;
            }
            String fileName = file.getName();
            boolean accept = pattern.matcher(file.toString()).matches();
            if (!accept) continue;
            logger.debug("Adding File from directory: " + fileName);
            retval.add("/" + fileName);
        }
        return retval;
    }
}

