/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.workload.Workload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkloadExecutor {
    private static final Logger logger = LoggerFactory.getLogger(WorkloadExecutor.class);
    private final int poolSize;
    private final boolean isPerformance;
    private final Map<Workload, Future> jobs = new ConcurrentHashMap<Workload, Future>();
    private final ExecutorService pool;

    public WorkloadExecutor() throws Exception {
        this(PherfConstants.create().getProperties("pherf.properties", false));
    }

    public WorkloadExecutor(Properties properties) throws Exception {
        this(properties, new ArrayList<Workload>(), true);
    }

    public WorkloadExecutor(Properties properties, List<Workload> workloads, boolean isPerformance) throws Exception {
        this.isPerformance = isPerformance;
        this.poolSize = properties.getProperty("pherf.default.threadpool") == null ? 10 : Integer.parseInt(properties.getProperty("pherf.default.threadpool"));
        this.pool = Executors.newFixedThreadPool(this.poolSize);
        this.init(workloads);
    }

    public void add(Workload workload) throws Exception {
        this.jobs.put(workload, this.pool.submit(workload.execute()));
    }

    public void get() {
        for (Workload workload : this.jobs.keySet()) {
            this.get(workload);
        }
    }

    public void get(Workload workload) {
        try {
            Future future = this.jobs.get(workload);
            future.get();
            this.jobs.remove(workload);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("", (Throwable)e);
        }
    }

    public void complete() {
        for (Workload workload : this.jobs.keySet()) {
            workload.complete();
        }
    }

    public void shutdown() {
        this.complete();
        this.pool.shutdownNow();
    }

    public ExecutorService getPool() {
        return this.pool;
    }

    public boolean isPerformance() {
        return this.isPerformance;
    }

    private void init(List<Workload> workloads) throws Exception {
        for (Workload workload : workloads) {
            this.jobs.put(workload, this.pool.submit(workload.execute()));
        }
    }
}

