/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.beans;

import org.apache.pivot.beans.BeanAdapter;
import org.apache.pivot.beans.BeanMonitor;
import org.apache.pivot.beans.PropertyChangeListener;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.MapListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.json.JSON;

public class NamespaceBinding {
    private Map<String, Object> namespace;
    private String sourcePath;
    private Object source;
    private Map<String, Object> sourceMap;
    private BeanMonitor sourceMonitor;
    private String sourceKey;
    private String targetPath;
    private Object target;
    private Dictionary<String, Object> targetDictionary;
    private String targetKey;
    private BindMapping bindMapping;
    private boolean updating = false;
    private MapListener<String, Object> sourceMapListener = new MapListener.Adapter<String, Object>(){

        @Override
        public void valueUpdated(Map<String, Object> map, String key, Object previousValue) {
            if (key.equals(NamespaceBinding.this.sourceKey) && !NamespaceBinding.this.updating) {
                NamespaceBinding.this.updating = true;
                NamespaceBinding.this.targetDictionary.put(NamespaceBinding.this.targetKey, NamespaceBinding.this.getTransformedSourceValue());
                NamespaceBinding.this.updating = false;
            }
        }
    };
    private PropertyChangeListener sourcePropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChanged(Object bean, String propertyName) {
            if (propertyName.equals(NamespaceBinding.this.sourceKey) && !NamespaceBinding.this.updating) {
                NamespaceBinding.this.updating = true;
                NamespaceBinding.this.targetDictionary.put(NamespaceBinding.this.targetKey, NamespaceBinding.this.getTransformedSourceValue());
                NamespaceBinding.this.updating = false;
            }
        }
    };

    public NamespaceBinding(Map<String, Object> namespace, String sourcePath, String targetPath) {
        this(namespace, sourcePath, targetPath, null);
    }

    public NamespaceBinding(Map<String, Object> namespace, String sourcePath, String targetPath, BindMapping bindMapping) {
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        if (sourcePath == null) {
            throw new IllegalArgumentException();
        }
        if (targetPath == null) {
            throw new IllegalArgumentException();
        }
        this.namespace = namespace;
        this.sourcePath = sourcePath;
        Sequence<String> sourceKeys = JSON.parse(sourcePath);
        this.sourceKey = sourceKeys.remove(sourceKeys.getLength() - 1, 1).get(0);
        this.source = JSON.get(namespace, sourceKeys);
        if (this.source instanceof Map) {
            this.sourceMap = (Map)this.source;
            this.sourceMonitor = null;
        } else {
            this.sourceMap = new BeanAdapter(this.source);
            this.sourceMonitor = new BeanMonitor(this.source);
        }
        if (!this.sourceMap.containsKey(this.sourceKey)) {
            throw new IllegalArgumentException("Source property \"" + sourcePath + "\" does not exist.");
        }
        if (this.sourceMonitor != null && !this.sourceMonitor.isNotifying(this.sourceKey)) {
            throw new IllegalArgumentException("\"" + this.sourceKey + "\" is not a notifying property.");
        }
        this.targetPath = targetPath;
        Sequence<String> targetKeys = JSON.parse(targetPath);
        this.targetKey = targetKeys.remove(targetKeys.getLength() - 1, 1).get(0);
        this.target = JSON.get(namespace, targetKeys);
        this.targetDictionary = this.target instanceof Dictionary ? (Dictionary)this.target : new BeanAdapter(this.target);
        if (!this.targetDictionary.containsKey(this.targetKey)) {
            throw new IllegalArgumentException("Target property \"" + targetPath + "\" does not exist.");
        }
        this.bindMapping = bindMapping;
        this.targetDictionary.put(this.targetKey, this.getTransformedSourceValue());
    }

    public Map<String, Object> getNamespace() {
        return this.namespace;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public Object getSource() {
        return this.source;
    }

    public String getSourceKey() {
        return this.sourceKey;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public Object getTarget() {
        return this.target;
    }

    public String getTargetKey() {
        return this.targetKey;
    }

    public BindMapping getBindMapping() {
        return this.bindMapping;
    }

    public Object getTransformedSourceValue() {
        Object sourceValue = this.sourceMap.get(this.sourceKey);
        return this.bindMapping == null ? sourceValue : this.bindMapping.evaluate(sourceValue);
    }

    public void bind() {
        if (this.source instanceof Map) {
            this.sourceMap.getMapListeners().add(this.sourceMapListener);
        } else {
            this.sourceMonitor.getPropertyChangeListeners().add(this.sourcePropertyChangeListener);
        }
    }

    public void unbind() {
        if (this.source instanceof Map) {
            this.sourceMap.getMapListeners().remove(this.sourceMapListener);
        } else {
            this.sourceMonitor.getPropertyChangeListeners().remove(this.sourcePropertyChangeListener);
        }
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (o instanceof NamespaceBinding) {
            NamespaceBinding namespaceBinding = (NamespaceBinding)o;
            equals = this.source == namespaceBinding.source && this.sourceKey.equals(namespaceBinding.sourceKey) && this.target == namespaceBinding.target && this.targetKey.equals(namespaceBinding.targetKey);
        }
        return equals;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.source.hashCode();
        result = 31 * result + this.sourceKey.hashCode();
        result = 31 * result + this.target.hashCode();
        result = 31 * result + this.targetKey.hashCode();
        return result;
    }

    public static interface BindMapping {
        public Object evaluate(Object var1);
    }
}

