/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Queue;
import org.apache.pivot.collections.QueueListener;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class ArrayQueue<T>
implements Queue<T>,
Serializable {
    private static final long serialVersionUID = -3856732506886968324L;
    private ArrayList<T> arrayList = new ArrayList();
    private transient Queue.QueueListenerList<T> queueListeners = new Queue.QueueListenerList();

    public ArrayQueue() {
        this(null);
    }

    public ArrayQueue(Comparator<T> comparator) {
        this.setComparator(comparator);
    }

    public ArrayQueue(int capacity) {
        this.ensureCapacity(capacity);
    }

    @Override
    public void enqueue(T item) {
        if (this.getComparator() == null) {
            this.arrayList.insert(item, 0);
        } else {
            this.arrayList.add(item);
        }
        this.queueListeners.itemEnqueued(this, item);
    }

    @Override
    public T dequeue() {
        int length = this.arrayList.getLength();
        if (length == 0) {
            throw new IllegalStateException("queue is empty");
        }
        T item = this.arrayList.remove(length - 1, 1).get(0);
        this.queueListeners.itemDequeued(this, item);
        return item;
    }

    @Override
    public T peek() {
        T item = null;
        int length = this.arrayList.getLength();
        if (length > 0) {
            item = this.arrayList.get(length - 1);
        }
        return item;
    }

    @Override
    public void clear() {
        if (this.arrayList.getLength() > 0) {
            this.arrayList.clear();
            this.queueListeners.queueCleared(this);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.arrayList.getLength() == 0;
    }

    @Override
    public int getLength() {
        return this.arrayList.getLength();
    }

    public void ensureCapacity(int capacity) {
        this.arrayList.ensureCapacity(capacity);
    }

    @Override
    public Comparator<T> getComparator() {
        return this.arrayList.getComparator();
    }

    @Override
    public void setComparator(Comparator<T> comparator) {
        Comparator<T> previousComparator = this.getComparator();
        this.arrayList.setComparator(comparator);
        this.queueListeners.comparatorChanged(this, previousComparator);
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator(this.arrayList.iterator());
    }

    @Override
    public ListenerList<QueueListener<T>> getQueueListeners() {
        return this.queueListeners;
    }
}

