/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;

public class EnumList<E extends Enum<E>>
implements List<E>,
Serializable {
    private static final long serialVersionUID = 5104856822133576300L;
    private Class<E> enumClass;
    private E[] items;
    private transient List.ListListenerList<E> listListeners = new List.ListListenerList();

    public EnumList(Class<E> enumClass) {
        this.enumClass = enumClass;
        this.items = (Enum[])enumClass.getEnumConstants();
    }

    public Class<E> getEnumClass() {
        return this.enumClass;
    }

    @Override
    public int add(E item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(E item, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E update(int index, E item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int remove(E item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Sequence<E> remove(int index, int count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E get(int index) {
        return this.items[index];
    }

    @Override
    public int indexOf(E item) {
        if (item == null) {
            throw new IllegalArgumentException("item cannot be null.");
        }
        return ((Enum)item).ordinal();
    }

    @Override
    public boolean isEmpty() {
        return this.items.length == 0;
    }

    @Override
    public int getLength() {
        return this.items.length;
    }

    public E[] toArray() {
        return (Enum[])Arrays.copyOf(this.items, this.items.length);
    }

    @Override
    public Comparator<E> getComparator() {
        return null;
    }

    @Override
    public void setComparator(Comparator<E> comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        return new ItemIterator();
    }

    @Override
    public ListenerList<ListListener<E>> getListListeners() {
        return this.listListeners;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" [");
        for (int i = 0; i < this.items.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.items[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        return o instanceof EnumList && ((EnumList)o).enumClass == this.enumClass;
    }

    public int hashCode() {
        return this.enumClass.hashCode();
    }

    private class ItemIterator
    implements Iterator<E> {
        private int i = 0;

        private ItemIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < EnumList.this.items.length;
        }

        @Override
        public E next() {
            if (this.i >= EnumList.this.items.length) {
                throw new NoSuchElementException();
            }
            return EnumList.this.items[this.i++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

