/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.EnumSet;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.MapListener;
import org.apache.pivot.util.ListenerList;

public class EnumMap<E extends Enum<E>, V>
implements Map<E, V>,
Serializable {
    private static final long serialVersionUID = -8446839779287452516L;
    private EnumSet<E> keySet;
    private Object[] values;
    private transient Map.MapListenerList<E, V> mapListeners = new Map.MapListenerList();

    public EnumMap(Class<E> enumClass) {
        this.keySet = new EnumSet<E>(enumClass);
        Enum[] constants = (Enum[])enumClass.getEnumConstants();
        this.values = new Object[constants.length];
    }

    @Override
    public V get(E key) {
        EnumMap.verifyNotNull("key", key);
        return (V)this.values[((Enum)key).ordinal()];
    }

    @Override
    public V put(E key, V value) {
        EnumMap.verifyNotNull("key", key);
        int ordinal = ((Enum)key).ordinal();
        Object previousValue = this.values[ordinal];
        this.values[ordinal] = value;
        if (this.keySet.contains(key)) {
            this.mapListeners.valueUpdated(this, key, previousValue);
        } else {
            this.keySet.add(key);
            this.mapListeners.valueAdded(this, key);
        }
        return (V)previousValue;
    }

    @Override
    public V remove(E key) {
        EnumMap.verifyNotNull("key", key);
        Object value = null;
        if (this.keySet.contains(key)) {
            int ordinal = ((Enum)key).ordinal();
            value = this.values[ordinal];
            this.values[ordinal] = null;
            this.keySet.remove(key);
            this.mapListeners.valueRemoved(this, key, value);
        }
        return (V)value;
    }

    @Override
    public void clear() {
        if (!this.keySet.isEmpty()) {
            this.values = new Object[this.values.length];
            this.keySet.clear();
            this.mapListeners.mapCleared(this);
        }
    }

    @Override
    public boolean containsKey(E key) {
        return this.keySet.contains(key);
    }

    @Override
    public boolean isEmpty() {
        return this.keySet.isEmpty();
    }

    @Override
    public int getCount() {
        return this.keySet.getCount();
    }

    @Override
    public Comparator<E> getComparator() {
        return null;
    }

    @Override
    public void setComparator(Comparator<E> comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        return this.keySet.iterator();
    }

    @Override
    public ListenerList<MapListener<E, V>> getMapListeners() {
        return this.mapListeners;
    }

    private static void verifyNotNull(String argument, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(argument + " cannot be null.");
        }
    }
}

