/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pivot.collections.Set;
import org.apache.pivot.collections.SetListener;
import org.apache.pivot.util.ListenerList;

public class EnumSet<E extends Enum<E>>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = 3544488357505145448L;
    private Class<E> enumClass;
    private E[] elements;
    private boolean[] members;
    private int count = 0;
    private transient Set.SetListenerList<E> setListeners = new Set.SetListenerList();

    public EnumSet(Class<E> enumClass) {
        this.enumClass = enumClass;
        this.elements = (Enum[])enumClass.getEnumConstants();
        this.members = new boolean[this.elements.length];
    }

    public Class<E> getEnumClass() {
        return this.enumClass;
    }

    @Override
    public boolean add(E element) {
        boolean added = false;
        int ordinal = ((Enum)element).ordinal();
        if (!this.members[ordinal]) {
            this.members[ordinal] = true;
            added = true;
            ++this.count;
            this.setListeners.elementAdded(this, element);
        }
        return added;
    }

    @Override
    public boolean remove(E element) {
        boolean removed = false;
        int ordinal = ((Enum)element).ordinal();
        if (this.members[ordinal]) {
            this.members[ordinal] = false;
            removed = true;
            --this.count;
            this.setListeners.elementRemoved(this, element);
        }
        return removed;
    }

    @Override
    public void clear() {
        if (this.count > 0) {
            this.members = new boolean[this.members.length];
            this.count = 0;
            this.setListeners.setCleared(this);
        }
    }

    @Override
    public boolean contains(E element) {
        return this.members[((Enum)element).ordinal()];
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public Comparator<E> getComparator() {
        return null;
    }

    @Override
    public void setComparator(Comparator<E> comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        return new ElementIterator();
    }

    @Override
    public ListenerList<SetListener<E>> getSetListeners() {
        return this.setListeners;
    }

    private class ElementIterator
    implements Iterator<E> {
        private int i = 0;
        private E next = null;

        private ElementIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                while (this.i < EnumSet.this.elements.length && !EnumSet.this.members[this.i]) {
                    ++this.i;
                }
                this.next = this.i < EnumSet.this.elements.length ? EnumSet.this.elements[this.i] : null;
            }
            return this.next != null;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object nextLocal = this.next;
            this.next = null;
            ++this.i;
            return nextLocal;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

