/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;

public class LinkedList<T>
implements List<T>,
Serializable {
    private static final long serialVersionUID = 2100691224732602812L;
    private Node<T> first = null;
    private Node<T> last = null;
    private int length = 0;
    private Comparator<T> comparator = null;
    private transient int modificationCount = 0;
    private transient List.ListListenerList<T> listListeners;

    public LinkedList() {
    }

    public LinkedList(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public LinkedList(T ... items) {
        for (int i = 0; i < items.length; ++i) {
            this.add(items[i]);
        }
    }

    public LinkedList(Sequence<T> items) {
        if (items == null) {
            throw new IllegalArgumentException();
        }
        int n = items.getLength();
        for (int i = 0; i < n; ++i) {
            this.add(items.get(i));
        }
    }

    @Override
    public int add(T item) {
        int index;
        if (this.comparator == null) {
            index = this.length;
            this.insert(item, index);
        } else {
            index = 0;
            Node next = null;
            Node previous = null;
            if (this.length > 0) {
                next = this.first;
                while (next != null && this.comparator.compare(item, next.item) > 0) {
                    next = next.next;
                    ++index;
                }
                previous = next == null ? this.last : next.previous;
            }
            this.insert(item, previous, next);
            ++this.length;
            ++this.modificationCount;
            if (this.listListeners != null) {
                this.listListeners.itemInserted(this, index);
            }
        }
        return index;
    }

    @Override
    public void insert(T item, int index) {
        LinkedList.verifyIndexBounds(index, 0, this.length);
        Node<T> next = null;
        Node previous = null;
        if (this.length > 0) {
            next = index == this.length ? null : this.getNode(index);
            previous = next == null ? this.last : ((Node)next).previous;
            this.verifyLocation(item, previous, next);
        }
        this.insert(item, previous, next);
        ++this.length;
        ++this.modificationCount;
        if (this.listListeners != null) {
            this.listListeners.itemInserted(this, index);
        }
    }

    private void insert(T item, Node<T> previous, Node<T> next) {
        Node<T> node = new Node<T>(previous, next, item);
        if (previous == null) {
            this.first = node;
        } else {
            ((Node)previous).next = (Node)node;
        }
        if (next == null) {
            this.last = node;
        } else {
            ((Node)next).previous = (Node)node;
        }
    }

    @Override
    public T update(int index, T item) {
        LinkedList.verifyIndexBounds(index, 0, this.length - 1);
        Node<T> node = this.getNode(index);
        Object previousItem = ((Node)node).item;
        if (previousItem != item) {
            this.verifyLocation(item, ((Node)node).previous, ((Node)node).next);
            ((Node)node).item = item;
            ++this.modificationCount;
            if (this.listListeners != null) {
                this.listListeners.itemUpdated(this, index, previousItem);
            }
        }
        return (T)previousItem;
    }

    private void verifyLocation(T item, Node<T> previous, Node<T> next) {
        if (this.comparator != null && (previous != null && this.comparator.compare(item, ((Node)previous).item) < 0 || next != null && this.comparator.compare(item, ((Node)next).item) > 0)) {
            throw new IllegalArgumentException("Illegal item modification.");
        }
    }

    @Override
    public int remove(T item) {
        int index = 0;
        LinkedListItemIterator nodeIterator = new LinkedListItemIterator();
        while (nodeIterator.hasNext()) {
            if (nodeIterator.next() == item) {
                nodeIterator.remove();
                break;
            }
            ++index;
        }
        if (!nodeIterator.hasNext()) {
            index = -1;
        }
        return index;
    }

    @Override
    public Sequence<T> remove(int index, int count) {
        LinkedList.verifyIndexBounds(index, count, 0, this.length);
        LinkedList<Object> removed = new LinkedList<Object>();
        if (count > 0) {
            Node<T> start;
            Node<T> end = start = this.getNode(index);
            for (int i = 0; i < count; ++i) {
                removed.add(((Node)end).item);
                end = ((Node)end).next;
            }
            end = end == null ? this.last : ((Node)end).previous;
            if (((Node)start).previous != null) {
                ((Node)start).previous.next = ((Node)end).next;
            }
            if (index + count == this.length) {
                this.last = ((Node)start).previous;
            }
            if (((Node)end).next != null) {
                ((Node)end).next.previous = ((Node)start).previous;
            }
            if (index == 0) {
                this.first = ((Node)end).next;
            }
            ((Node)start).previous = null;
            ((Node)end).next = null;
            this.length -= count;
            ++this.modificationCount;
            if (this.listListeners != null) {
                this.listListeners.itemsRemoved(this, index, removed);
            }
        }
        return removed;
    }

    @Override
    public void clear() {
        if (this.length > 0) {
            this.first = null;
            this.last = null;
            this.length = 0;
            ++this.modificationCount;
            if (this.listListeners != null) {
                this.listListeners.listCleared(this);
            }
        }
    }

    @Override
    public T get(int index) {
        LinkedList.verifyIndexBounds(index, 0, this.length - 1);
        Node<T> node = this.getNode(index);
        return (T)((Node)node).item;
    }

    private Node<T> getNode(int index) {
        Node node;
        if (index == 0) {
            node = this.first;
        } else if (index == this.length - 1) {
            node = this.last;
        } else if (index < this.length / 2) {
            node = this.first;
            for (int i = 0; i < index; ++i) {
                node = node.next;
            }
        } else {
            node = this.last;
            for (int i = this.length - 1; i > index; --i) {
                node = node.previous;
            }
        }
        return node;
    }

    @Override
    public int indexOf(T item) {
        int index = 0;
        Node node = this.first;
        while (node != null && !(item == null ? node.item == null : item.equals(node.item))) {
            node = node.next;
            ++index;
        }
        if (node == null) {
            index = -1;
        }
        return index;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public Comparator<T> getComparator() {
        return this.comparator;
    }

    @Override
    public void setComparator(Comparator<T> comparator) {
        Comparator<T> previousComparator = this.comparator;
        if (comparator != null) {
            Object[] array = new Object[this.length];
            int i = 0;
            for (Object item : this) {
                array[i++] = item;
            }
            Arrays.sort(array, comparator);
            this.first = null;
            Node<Object> node = null;
            for (i = 0; i < this.length; ++i) {
                Node<Object> previousNode = node;
                node = new Node<Object>(previousNode, null, array[i]);
                if (previousNode == null) {
                    this.first = node;
                    continue;
                }
                ((Node)previousNode).next = (Node)node;
            }
            this.last = node;
            ++this.modificationCount;
        }
        this.comparator = comparator;
        if (this.listListeners != null) {
            this.listListeners.comparatorChanged(this, previousComparator);
        }
    }

    @Override
    public List.ItemIterator<T> iterator() {
        return new LinkedListItemIterator();
    }

    @Override
    public ListenerList<ListListener<T>> getListListeners() {
        if (this.listListeners == null) {
            this.listListeners = new List.ListListenerList();
        }
        return this.listListeners;
    }

    public boolean equals(Object o) {
        List otherList;
        boolean equals = false;
        if (this == o) {
            equals = true;
        } else if (o instanceof List && this.length == (otherList = (List)o).getLength()) {
            Iterator iterator = otherList.iterator();
            equals = true;
            for (Object element : this) {
                if (iterator.hasNext() && element.equals(iterator.next())) continue;
                equals = false;
                break;
            }
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = 1;
        for (Object item : this) {
            hashCode = 31 * hashCode + (item == null ? 0 : item.hashCode());
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" [");
        int i = 0;
        for (Object item : this) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(item);
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    private static void verifyIndexBounds(int index, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("end (" + end + ") < " + "start (" + start + ")");
        }
        if (index < start || index > end) {
            throw new IndexOutOfBoundsException("index " + index + " out of bounds.");
        }
    }

    private static void verifyIndexBounds(int index, int count, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("end (" + end + ") < " + "start (" + start + ")");
        }
        if (count < 0 || start < 0) {
            throw new IllegalArgumentException("count (" + count + ") < 0 or start (" + start + ") < 0");
        }
        if (index < start) {
            throw new IndexOutOfBoundsException("index " + index + " out of bounds.");
        }
        if (index + count > end) {
            throw new IndexOutOfBoundsException("index + count " + index + "," + count + " out of range.");
        }
    }

    private class LinkedListItemIterator
    implements List.ItemIterator<T> {
        private int index = 0;
        private Node<T> current = null;
        private boolean forward = false;
        private int modificationCountLocal;

        public LinkedListItemIterator() {
            this.modificationCountLocal = LinkedList.this.modificationCount;
        }

        @Override
        public boolean hasNext() {
            if (this.modificationCountLocal != LinkedList.this.modificationCount) {
                throw new ConcurrentModificationException();
            }
            return this.index < LinkedList.this.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.current == null) {
                this.current = LinkedList.this.first;
            } else if (this.forward) {
                this.current = this.current.next;
            }
            ++this.index;
            this.forward = true;
            return this.current.item;
        }

        @Override
        public boolean hasPrevious() {
            if (this.modificationCountLocal != LinkedList.this.modificationCount) {
                throw new ConcurrentModificationException();
            }
            return this.index > 0;
        }

        @Override
        public T previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            if (!this.forward) {
                this.current = this.current.previous;
            }
            --this.index;
            this.forward = false;
            return this.current.item;
        }

        @Override
        public void toStart() {
            this.index = 0;
            this.current = null;
            this.forward = true;
        }

        @Override
        public void toEnd() {
            this.index = LinkedList.this.length;
            this.current = LinkedList.this.last;
            this.forward = true;
        }

        @Override
        public void insert(T item) {
            Node next = null;
            Node previous = null;
            if (LinkedList.this.length > 0) {
                if (this.index == 0) {
                    next = LinkedList.this.first;
                } else if (this.index < LinkedList.this.length) {
                    if (this.forward) {
                        next = this.current.next;
                        previous = this.current;
                    } else {
                        next = this.current;
                        previous = this.current.previous;
                    }
                } else {
                    previous = LinkedList.this.last;
                }
                LinkedList.this.verifyLocation(item, previous, next);
                if (!this.forward) {
                    ++this.index;
                }
            }
            LinkedList.this.insert(item, previous, next);
            LinkedList.this.length++;
            ++this.modificationCountLocal;
            LinkedList.this.modificationCount++;
            if (LinkedList.this.listListeners != null) {
                LinkedList.this.listListeners.itemInserted(LinkedList.this, this.index);
            }
        }

        @Override
        public void update(T item) {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            Object previousItem = this.current.item;
            if (previousItem != item) {
                LinkedList.this.verifyLocation(item, this.current.previous, this.current.next);
                this.current.item = item;
                ++this.modificationCountLocal;
                LinkedList.this.modificationCount++;
                if (LinkedList.this.listListeners != null) {
                    LinkedList.this.listListeners.itemUpdated(LinkedList.this, this.index, previousItem);
                }
            }
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            Object item = this.current.item;
            if (this.current.previous == null) {
                LinkedList.this.first = this.current.next;
            } else {
                this.current.previous.next = this.current.next;
            }
            if (this.current.next == null) {
                LinkedList.this.last = this.current.previous;
            } else {
                this.current.next.previous = this.current.previous;
            }
            if (this.forward) {
                this.current = this.current.previous;
                --this.index;
            }
            LinkedList.this.length--;
            ++this.modificationCountLocal;
            LinkedList.this.modificationCount++;
            if (LinkedList.this.listListeners != null) {
                LinkedList<Object> removed = new LinkedList<Object>(item);
                LinkedList.this.listListeners.itemsRemoved(LinkedList.this, this.index, removed);
            }
        }
    }

    private static class Node<T>
    implements Serializable {
        private static final long serialVersionUID = -848937850230412572L;
        private Node<T> previous;
        private Node<T> next;
        private T item;

        public Node(Node<T> previous, Node<T> next, T item) {
            this.previous = previous;
            this.next = next;
            this.item = item;
        }
    }
}

