/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.Collection;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;

public interface List<T>
extends Sequence<T>,
Collection<T> {
    @Override
    public int add(T var1);

    @Override
    public void insert(T var1, int var2);

    @Override
    public T update(int var1, T var2);

    @Override
    public Sequence<T> remove(int var1, int var2);

    @Override
    public void clear();

    @Override
    public int getLength();

    @Override
    public void setComparator(Comparator<T> var1);

    public ListenerList<ListListener<T>> getListListeners();

    public static class ListListenerList<T>
    extends ListenerList<ListListener<T>>
    implements ListListener<T> {
        @Override
        public void itemInserted(List<T> list, int index) {
            for (ListListener listener : this) {
                listener.itemInserted(list, index);
            }
        }

        @Override
        public void itemsRemoved(List<T> list, int index, Sequence<T> items) {
            for (ListListener listener : this) {
                listener.itemsRemoved(list, index, items);
            }
        }

        @Override
        public void itemUpdated(List<T> list, int index, T previousItem) {
            for (ListListener listener : this) {
                listener.itemUpdated(list, index, previousItem);
            }
        }

        @Override
        public void listCleared(List<T> list) {
            for (ListListener listener : this) {
                listener.listCleared(list);
            }
        }

        @Override
        public void comparatorChanged(List<T> list, Comparator<T> previousComparator) {
            for (ListListener listener : this) {
                listener.comparatorChanged(list, previousComparator);
            }
        }
    }

    public static interface ItemIterator<T>
    extends Iterator<T> {
        public boolean hasPrevious();

        public T previous();

        public void toStart();

        public void toEnd();

        public void insert(T var1);

        public void update(T var1);
    }
}

