/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.ArrayStack;
import org.apache.pivot.util.ImmutableIterator;

public interface Sequence<T> {
    public int add(T var1);

    public void insert(T var1, int var2);

    public T update(int var1, T var2);

    public int remove(T var1);

    public Sequence<T> remove(int var1, int var2);

    public T get(int var1);

    public int indexOf(T var1);

    public int getLength();

    public static class Tree<T> {
        public static <T> int add(Sequence<T> sequence, T item, Path path) {
            return ((Sequence)Tree.get(sequence, path)).add(item);
        }

        public static <T> void insert(Sequence<T> sequence, T item, Path path, int index) {
            ((Sequence)Tree.get(sequence, path)).insert(item, index);
        }

        public static <T> T update(Sequence<T> sequence, Path path, T item) {
            if (sequence == null) {
                throw new IllegalArgumentException("sequence is null.");
            }
            if (path == null) {
                throw new IllegalArgumentException("path is null.");
            }
            int i = 0;
            int n = path.getLength() - 1;
            while (i < n) {
                sequence = (Sequence)sequence.get(path.get(i++));
            }
            return sequence.update(path.get(i), item);
        }

        public static <T> Path remove(Sequence<T> sequence, T item) {
            Path path = Tree.pathOf(sequence, item);
            if (path == null) {
                throw new IllegalArgumentException("item is not a descendant of sequence.");
            }
            Tree.remove(sequence, path, 1);
            return path;
        }

        public static <T> Sequence<T> remove(Sequence<T> sequence, Path path, int count) {
            if (sequence == null) {
                throw new IllegalArgumentException("sequence is null.");
            }
            if (path == null) {
                throw new IllegalArgumentException("path is null.");
            }
            int i = 0;
            int n = path.getLength() - 1;
            while (i < n) {
                sequence = (Sequence)sequence.get(path.get(i++));
            }
            return sequence.remove(path.get(i), count);
        }

        public static <T> T get(Sequence<T> sequence, Path path) {
            T item;
            if (sequence == null) {
                throw new IllegalArgumentException("sequence is null.");
            }
            if (path == null) {
                throw new IllegalArgumentException("path is null.");
            }
            if (path.getLength() == 0) {
                item = null;
            } else {
                int i = 0;
                int n = path.getLength() - 1;
                while (i < n) {
                    sequence = (Sequence)sequence.get(path.get(i++));
                }
                item = sequence.get(path.get(i));
            }
            return item;
        }

        public static <T> Path pathOf(Sequence<T> sequence, T item) {
            if (sequence == null) {
                throw new IllegalArgumentException("sequence is null.");
            }
            if (item == null) {
                throw new IllegalArgumentException("item is null.");
            }
            Path path = null;
            int n = sequence.getLength();
            for (int i = 0; i < n && path == null; ++i) {
                T t = sequence.get(i);
                if (t.equals(item)) {
                    path = new Path();
                    path.add(i);
                    continue;
                }
                if (!(t instanceof Sequence) || (path = Tree.pathOf((Sequence)t, item)) == null) continue;
                path.insert(i, 0);
            }
            return path;
        }

        public static <T> ItemIterator<T> depthFirstIterator(Sequence<T> sequence) {
            return new DepthFirstItemIterator<T>(sequence);
        }

        public static boolean isDescendant(Path ancestorPath, Path descendantPath) {
            int descendantLength;
            boolean result;
            int ancestorLength = ancestorPath.getLength();
            boolean bl = result = ancestorLength <= (descendantLength = descendantPath.getLength());
            if (result) {
                int n = ancestorLength;
                for (int i = 0; i < n; ++i) {
                    int index2;
                    int index1 = ancestorPath.get(i);
                    if (index1 == (index2 = descendantPath.get(i).intValue())) continue;
                    result = false;
                    break;
                }
            }
            return result;
        }

        private static class DepthFirstItemIterator<T>
        implements ItemIterator<T> {
            private ArrayStack<Sequence<T>> stack = new ArrayStack();
            private Path previousPath = null;
            private Path nextPath = new Path();

            public DepthFirstItemIterator(Sequence<T> sequence) {
                this.stack.push(sequence);
                this.nextPath.add(0);
                this.normalize();
            }

            @Override
            public boolean hasNext() {
                return this.stack.peek() != null;
            }

            @Override
            public T next() {
                Sequence<T> sequence = this.stack.peek();
                if (sequence == null) {
                    throw new NoSuchElementException();
                }
                this.previousPath = new Path(this.nextPath);
                int n = this.nextPath.getLength();
                int index = this.nextPath.get(n - 1);
                T item = sequence.get(index);
                if (item instanceof Sequence) {
                    this.stack.push((Sequence)item);
                    this.nextPath.add(0);
                } else {
                    this.nextPath.update(n - 1, index + 1);
                }
                this.normalize();
                return item;
            }

            private void normalize() {
                Sequence<T> sequence = this.stack.peek();
                int n = this.nextPath.getLength();
                int index = this.nextPath.get(n - 1);
                while (sequence != null && index >= sequence.getLength()) {
                    this.stack.pop();
                    sequence = this.stack.peek();
                    this.nextPath.remove(--n, 1);
                    if (n <= 0) continue;
                    index = this.nextPath.get(n - 1);
                    this.nextPath.update(n - 1, ++index);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Path getPath() {
                if (this.previousPath == null) {
                    throw new IllegalStateException();
                }
                return this.previousPath;
            }
        }

        public static interface ItemIterator<T>
        extends Iterator<T> {
            public Path getPath();
        }

        public static class ImmutablePath
        extends Path {
            public ImmutablePath(Integer ... elements) {
                super(elements);
            }

            public ImmutablePath(Path path) {
                super(path);
            }

            @Override
            public int add(Integer element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void insert(Integer element, int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Integer update(int index, Integer element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Sequence<Integer> remove(int index, int count) {
                throw new UnsupportedOperationException();
            }
        }

        public static class Path
        implements Sequence<Integer>,
        Iterable<Integer> {
            private ArrayList<Integer> elements;

            public Path() {
                this.elements = new ArrayList();
            }

            public Path(Integer ... elements) {
                this.elements = new ArrayList<Integer>(elements);
            }

            public Path(Path path) {
                this.elements = new ArrayList<Integer>(path.elements);
            }

            public Path(Path path, int depth) {
                this.elements = new ArrayList<Integer>(path.elements, 0, depth);
            }

            private Path(ArrayList<Integer> elements) {
                this.elements = elements;
            }

            @Override
            public int add(Integer element) {
                return this.elements.add(element);
            }

            @Override
            public void insert(Integer element, int index) {
                this.elements.insert(element, index);
            }

            @Override
            public Integer update(int index, Integer element) {
                return this.elements.update(index, element);
            }

            @Override
            public int remove(Integer element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Sequence<Integer> remove(int index, int count) {
                return this.elements.remove(index, count);
            }

            @Override
            public Integer get(int index) {
                return this.elements.get(index);
            }

            @Override
            public int indexOf(Integer element) {
                return this.elements.indexOf(element);
            }

            @Override
            public int getLength() {
                return this.elements.getLength();
            }

            @Override
            public Iterator<Integer> iterator() {
                return new ImmutableIterator<Integer>(this.elements.iterator());
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                int i = 0;
                for (Integer element : this.elements) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(element);
                    ++i;
                }
                sb.append("]");
                return sb.toString();
            }

            public Integer[] toArray() {
                return this.elements.toArray(Integer[].class);
            }

            public static Path forDepth(int depth) {
                return new Path(new ArrayList<Integer>(depth));
            }
        }
    }
}

