/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections.adapter;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.RandomAccess;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class ListAdapter<T>
implements List<T>,
Serializable {
    private static final long serialVersionUID = 1649736907064653706L;
    private java.util.List<T> list = null;
    private Comparator<T> comparator = null;
    private transient List.ListListenerList<T> listListeners = new List.ListListenerList();

    public ListAdapter(java.util.List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException("list is null.");
        }
        this.list = list;
    }

    public java.util.List<T> getList() {
        return this.list;
    }

    @Override
    public int add(T item) {
        int index = -1;
        if (this.comparator == null) {
            index = this.getLength();
        } else {
            index = Collections.binarySearch(this.list, item, this.comparator);
            if (index < 0) {
                index = -(index + 1);
            }
        }
        this.list.add(index, item);
        this.listListeners.itemInserted(this, index);
        return index;
    }

    @Override
    public void insert(T item, int index) {
        if (this.comparator != null && Collections.binarySearch(this.list, item, this.comparator) != -(index + 1)) {
            throw new IllegalArgumentException("Illegal insertion point.");
        }
        this.list.add(index, item);
        this.listListeners.itemInserted(this, index);
    }

    @Override
    public T update(int index, T item) {
        T previousItem;
        if (this.comparator != null) {
            Object predecessor = null;
            Object successor = null;
            if (this.list instanceof RandomAccess) {
                if (index > 0) {
                    predecessor = this.list.get(index - 1);
                }
                if (index < this.getLength() - 1) {
                    successor = this.list.get(index + 1);
                }
            } else if (index == 0) {
                successor = this.list.get(1);
            } else {
                ListIterator<T> listIterator = this.list.listIterator(index - 1);
                predecessor = listIterator.next();
                listIterator.next();
                if (listIterator.hasNext()) {
                    successor = listIterator.next();
                }
            }
            if (predecessor != null && this.comparator.compare(item, predecessor) < 0 || successor != null && this.comparator.compare(item, successor) > 0) {
                throw new IllegalArgumentException("Illegal item modification.");
            }
        }
        if (this.list instanceof RandomAccess) {
            previousItem = this.list.get(index);
            if (previousItem != item) {
                this.list.set(index, item);
            }
            this.listListeners.itemUpdated(this, index, previousItem);
        } else {
            ListIterator<T> listIterator = this.list.listIterator(index);
            previousItem = listIterator.next();
            if (previousItem != item) {
                try {
                    listIterator.set(item);
                }
                catch (UnsupportedOperationException exception) {
                    this.list.set(index, item);
                }
            }
            this.listListeners.itemUpdated(this, index, previousItem);
        }
        return previousItem;
    }

    @Override
    public int remove(T item) {
        int index = this.indexOf(item);
        if (index != -1) {
            this.remove(index, 1);
        }
        return index;
    }

    @Override
    public Sequence<T> remove(int index, int count) {
        java.util.List removedList = null;
        try {
            removedList = (java.util.List)this.list.getClass().newInstance();
        }
        catch (IllegalAccessException exception) {
            throw new RuntimeException(exception);
        }
        catch (InstantiationException exception) {
            throw new RuntimeException(exception);
        }
        ListAdapter<T> removed = new ListAdapter<T>(removedList);
        if (count > 0) {
            for (int i = count - 1; i >= 0; --i) {
                removedList.add(0, this.list.remove(index + i));
            }
            this.listListeners.itemsRemoved(this, index, removed);
        }
        return removed;
    }

    @Override
    public void clear() {
        if (this.getLength() > 0) {
            this.list.clear();
            this.listListeners.listCleared(this);
        }
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public int indexOf(T item) {
        return this.list.indexOf(item);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public int getLength() {
        return this.list.size();
    }

    @Override
    public Comparator<T> getComparator() {
        return this.comparator;
    }

    @Override
    public void setComparator(Comparator<T> comparator) {
        Comparator<T> previousComparator = this.comparator;
        if (previousComparator != comparator) {
            if (comparator != null) {
                Collections.sort(this.list, comparator);
            }
            this.comparator = comparator;
            this.listListeners.comparatorChanged(this, previousComparator);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator<T>(this.list.iterator());
    }

    @Override
    public ListenerList<ListListener<T>> getListListeners() {
        return this.listListeners;
    }

    public String toString() {
        return this.list.toString();
    }
}

