/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections.adapter;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.MapListener;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class MapAdapter<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 4005649560306864969L;
    private java.util.Map<K, V> map = null;
    private transient Map.MapListenerList<K, V> mapListeners = new Map.MapListenerList();

    public MapAdapter(java.util.Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException("map is null.");
        }
        this.map = map;
    }

    public java.util.Map<K, V> getMap() {
        return this.map;
    }

    @Override
    public V get(K key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        boolean update = this.containsKey(key);
        V previousValue = this.map.put(key, value);
        if (update) {
            this.mapListeners.valueUpdated(this, key, previousValue);
        } else {
            this.mapListeners.valueAdded(this, key);
        }
        return previousValue;
    }

    @Override
    public V remove(K key) {
        Object value = null;
        if (this.containsKey(key)) {
            value = this.map.remove(key);
            this.mapListeners.valueRemoved(this, key, value);
        }
        return value;
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            this.map.clear();
            this.mapListeners.mapCleared(this);
        }
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int getCount() {
        return this.map.size();
    }

    @Override
    public Comparator<K> getComparator() {
        if (this.map instanceof SortedMap) {
            return ((SortedMap)this.map).comparator();
        }
        return null;
    }

    @Override
    public void setComparator(Comparator<K> comparator) {
        Comparator<K> previousComparator = this.getComparator();
        if (this.map instanceof SortedMap) {
            try {
                Constructor<?> constructor = this.map.getClass().getConstructor(Comparator.class);
                if (constructor != null) {
                    java.util.Map mapLocal = (java.util.Map)constructor.newInstance(comparator);
                    mapLocal.putAll(this.map);
                    this.map = mapLocal;
                }
            }
            catch (SecurityException exception) {
                throw new RuntimeException(exception);
            }
            catch (NoSuchMethodException exception) {
                throw new RuntimeException(exception);
            }
            catch (IllegalArgumentException exception) {
                throw new RuntimeException(exception);
            }
            catch (InstantiationException exception) {
                throw new RuntimeException(exception);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
            catch (InvocationTargetException exception) {
                throw new RuntimeException(exception);
            }
        }
        this.mapListeners.comparatorChanged(this, previousComparator);
    }

    @Override
    public Iterator<K> iterator() {
        return new ImmutableIterator<K>(this.map.keySet().iterator());
    }

    @Override
    public ListenerList<MapListener<K, V>> getMapListeners() {
        return this.mapListeners;
    }

    public String toString() {
        return this.map.toString();
    }
}

