/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections.concurrent;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.MapListener;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class SynchronizedMap<K, V>
implements Map<K, V> {
    private Map<K, V> map;
    private SynchronizedMapListenerList<K, V> mapListeners = new SynchronizedMapListenerList();

    public SynchronizedMap(Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException("map cannot be null.");
        }
        this.map = map;
    }

    @Override
    public synchronized V get(K key) {
        return this.map.get(key);
    }

    @Override
    public synchronized V put(K key, V value) {
        boolean update = this.containsKey(key);
        V previousValue = this.map.put(key, value);
        if (update) {
            this.mapListeners.valueUpdated(this, key, previousValue);
        } else {
            this.mapListeners.valueAdded(this, key);
        }
        return previousValue;
    }

    @Override
    public synchronized V remove(K key) {
        Object value = null;
        if (this.containsKey(key)) {
            value = this.map.remove(key);
            this.mapListeners.valueRemoved(this, key, value);
        }
        return value;
    }

    @Override
    public synchronized void clear() {
        if (!this.map.isEmpty()) {
            this.map.clear();
            this.mapListeners.mapCleared(this);
        }
    }

    @Override
    public synchronized boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public synchronized int getCount() {
        return this.map.getCount();
    }

    @Override
    public synchronized Comparator<K> getComparator() {
        return this.map.getComparator();
    }

    @Override
    public synchronized void setComparator(Comparator<K> comparator) {
        Comparator<K> previousComparator = this.getComparator();
        this.map.setComparator(comparator);
        this.mapListeners.comparatorChanged(this, previousComparator);
    }

    @Override
    public Iterator<K> iterator() {
        return new ImmutableIterator(this.map.iterator());
    }

    @Override
    public ListenerList<MapListener<K, V>> getMapListeners() {
        return this.mapListeners;
    }

    private static class SynchronizedMapListenerList<K, V>
    extends Map.MapListenerList<K, V> {
        private SynchronizedMapListenerList() {
        }

        @Override
        public synchronized void add(MapListener<K, V> listener) {
            super.add(listener);
        }

        @Override
        public synchronized void remove(MapListener<K, V> listener) {
            super.remove(listener);
        }

        @Override
        public synchronized void valueAdded(Map<K, V> map, K key) {
            super.valueAdded(map, key);
        }

        @Override
        public synchronized void valueRemoved(Map<K, V> map, K key, V value) {
            super.valueRemoved(map, key, value);
        }

        @Override
        public synchronized void valueUpdated(Map<K, V> map, K key, V previousValue) {
            super.valueUpdated(map, key, previousValue);
        }

        @Override
        public synchronized void mapCleared(Map<K, V> map) {
            super.mapCleared(map);
        }

        @Override
        public synchronized void comparatorChanged(Map<K, V> map, Comparator<K> previousComparator) {
            super.comparatorChanged(map, previousComparator);
        }
    }
}

