/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections.concurrent;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.Stack;
import org.apache.pivot.collections.StackListener;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class SynchronizedStack<T>
implements Stack<T> {
    private Stack<T> stack;
    private SynchronizedStackListenerList<T> stackListeners = new SynchronizedStackListenerList();

    public SynchronizedStack(Stack<T> stack) {
        if (stack == null) {
            throw new IllegalArgumentException("stack cannot be null.");
        }
        this.stack = stack;
    }

    @Override
    public synchronized void push(T item) {
        this.stack.push(item);
        this.stackListeners.itemPushed(this, item);
        this.notify();
    }

    @Override
    public synchronized T pop() {
        Object item = null;
        try {
            while (this.stack.isEmpty()) {
                this.wait();
            }
            item = this.stack.pop();
            this.stackListeners.itemPopped(this, item);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return item;
    }

    @Override
    public synchronized T peek() {
        return this.stack.peek();
    }

    @Override
    public synchronized void clear() {
        if (!this.stack.isEmpty()) {
            this.stack.clear();
            this.stackListeners.stackCleared(this);
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @Override
    public synchronized int getDepth() {
        return this.stack.getDepth();
    }

    @Override
    public synchronized Comparator<T> getComparator() {
        return this.stack.getComparator();
    }

    @Override
    public synchronized void setComparator(Comparator<T> comparator) {
        Comparator<T> previousComparator = this.getComparator();
        this.stack.setComparator(comparator);
        this.stackListeners.comparatorChanged(this, previousComparator);
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator(this.stack.iterator());
    }

    @Override
    public ListenerList<StackListener<T>> getStackListeners() {
        return this.stackListeners;
    }

    private static class SynchronizedStackListenerList<T>
    extends Stack.StackListenerList<T> {
        private SynchronizedStackListenerList() {
        }

        @Override
        public synchronized void add(StackListener<T> listener) {
            super.add(listener);
        }

        @Override
        public synchronized void remove(StackListener<T> listener) {
            super.remove(listener);
        }

        @Override
        public synchronized void itemPushed(Stack<T> stack, T item) {
            super.itemPushed(stack, item);
        }

        @Override
        public synchronized void itemPopped(Stack<T> stack, T item) {
            super.itemPopped(stack, item);
        }
    }
}

