/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class ListenerList<T>
implements Iterable<T> {
    private Node first = null;

    public void add(T listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null.");
        }
        Node node = this.first;
        if (node == null) {
            this.first = new Node(null, null, listener);
        } else {
            while (node.next != null && node.listener != listener) {
                node = node.next;
            }
            if (node.next == null && node.listener != listener) {
                node.next = new Node(node, null, listener);
            } else {
                System.err.println("Duplicate listener " + listener + " added to " + this);
            }
        }
    }

    public void remove(T listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null.");
        }
        Node node = this.first;
        while (node != null && node.listener != listener) {
            node = node.next;
        }
        if (node == null) {
            System.err.println("Nonexistent listener " + listener + " removed from " + this);
        } else if (node.previous == null) {
            this.first = node.next;
            if (this.first != null) {
                this.first.previous = null;
            }
        } else {
            node.previous.next = node.next;
            if (node.next != null) {
                node.next.previous = node.previous;
            }
        }
    }

    public boolean contains(T listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null.");
        }
        Node node = this.first;
        while (node != null && node.listener != listener) {
            node = node.next;
        }
        return node != null;
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    @Override
    public Iterator<T> iterator() {
        return new NodeIterator();
    }

    private class NodeIterator
    implements Iterator<T> {
        private Node node;

        public NodeIterator() {
            this.node = ListenerList.this.first;
        }

        @Override
        public boolean hasNext() {
            return this.node != null;
        }

        @Override
        public T next() {
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            Object listener = this.node.listener;
            this.node = this.node.next;
            return listener;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class Node {
        private Node previous;
        private Node next;
        private T listener;

        public Node(Node previous, Node next, T listener) {
            this.previous = previous;
            this.next = next;
            this.listener = listener;
        }
    }
}

