/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util;

import java.io.Serializable;

public class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = -3677773163272115116L;
    private byte majorRevision = 0;
    private byte minorRevision = 0;
    private byte maintenanceRevision = 0;
    private byte updateRevision = 0;
    private String build = null;

    public Version(int majorRevision, int minorRevision, int maintenanceRevision, int updateRevision) {
        this(majorRevision, minorRevision, maintenanceRevision, updateRevision, null);
    }

    public Version(int majorRevision, int minorRevision, int maintenanceRevision, int updateRevision, String build) {
        if (majorRevision > 127) {
            throw new IllegalArgumentException("majorRevision must be less than 127.");
        }
        if (minorRevision > 255) {
            throw new IllegalArgumentException("minorRevision must be less than 255.");
        }
        if (maintenanceRevision > 255) {
            throw new IllegalArgumentException("maintenanceRevision must be less than 255.");
        }
        if (updateRevision > 255) {
            throw new IllegalArgumentException("updateRevision must be less than 255.");
        }
        this.majorRevision = (byte)majorRevision;
        this.minorRevision = (byte)minorRevision;
        this.maintenanceRevision = (byte)maintenanceRevision;
        this.updateRevision = (byte)updateRevision;
        this.build = build;
    }

    public byte getMajorRevision() {
        return this.majorRevision;
    }

    public byte getMinorRevision() {
        return this.minorRevision;
    }

    public byte getMaintenanceRevision() {
        return this.maintenanceRevision;
    }

    public byte getUpdateRevision() {
        return this.updateRevision;
    }

    public int getNumber() {
        int number = (this.majorRevision & 0xFF) << 24 | (this.minorRevision & 0xFF) << 16 | (this.maintenanceRevision & 0xFF) << 8 | (this.updateRevision & 0xFF) << 0;
        return number;
    }

    @Override
    public int compareTo(Version version) {
        return this.getNumber() - version.getNumber();
    }

    public boolean equals(Object object) {
        return object instanceof Version && this.compareTo((Version)object) == 0;
    }

    public int hashCode() {
        return this.getNumber();
    }

    public String toString() {
        String string = this.majorRevision + "." + this.minorRevision + "." + this.maintenanceRevision + "_" + String.format("%02d", this.updateRevision);
        if (this.build != null) {
            string = string + "-" + this.build;
        }
        return string;
    }

    public static Version decode(String string) {
        String revision;
        Version version = null;
        byte majorRevision = 0;
        byte minorRevision = 0;
        int maintenanceRevision = 0;
        int updateRevision = 0;
        String build = null;
        int i = string.indexOf("-");
        if (i == -1) {
            revision = string;
        } else {
            revision = string.substring(0, i);
            build = string.substring(i + 1);
        }
        String[] revisionNumbers = revision.split("\\.");
        if (revisionNumbers.length > 0) {
            majorRevision = Byte.parseByte(revisionNumbers[0]);
            if (revisionNumbers.length > 1) {
                String[] maintenanceRevisionNumbers;
                minorRevision = Byte.parseByte(revisionNumbers[1]);
                if (revisionNumbers.length > 2 && (maintenanceRevisionNumbers = revisionNumbers[2].split("_")).length > 0) {
                    maintenanceRevision = Byte.parseByte(maintenanceRevisionNumbers[0]);
                    if (maintenanceRevisionNumbers.length > 1) {
                        updateRevision = Byte.parseByte(maintenanceRevisionNumbers[1]);
                    }
                }
            }
            version = new Version(majorRevision, minorRevision, maintenanceRevision, updateRevision, build);
        }
        return version;
    }
}

