/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.util.concurrent.TaskListener;

public abstract class Task<V> {
    private ExecutorService executorService;
    private V result = null;
    private Throwable fault = null;
    private TaskListener<V> taskListener = null;
    protected volatile long timeout = Long.MAX_VALUE;
    protected volatile boolean abort = false;
    public static final ExecutorService DEFAULT_EXECUTOR_SERVICE = new DefaultExecutorService();

    public Task() {
        this(DEFAULT_EXECUTOR_SERVICE);
    }

    public Task(ExecutorService executorService) {
        if (executorService == null) {
            throw new IllegalArgumentException("executorService is null.");
        }
        this.executorService = executorService;
    }

    public abstract V execute() throws TaskExecutionException;

    public synchronized void execute(TaskListener<V> taskListenerArgument) {
        this.execute(taskListenerArgument, this.executorService);
    }

    public synchronized void execute(TaskListener<V> taskListenerArgument, ExecutorService executorServiceArgument) {
        if (taskListenerArgument == null) {
            throw new IllegalArgumentException("taskListener is null.");
        }
        if (executorServiceArgument == null) {
            throw new IllegalThreadStateException("executorService is null.");
        }
        if (this.taskListener != null) {
            throw new IllegalThreadStateException("Task is already pending.");
        }
        this.taskListener = taskListenerArgument;
        this.result = null;
        this.fault = null;
        this.abort = false;
        ExecuteCallback executeCallback = new ExecuteCallback();
        executorServiceArgument.submit(executeCallback);
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public synchronized V getResult() {
        return this.result;
    }

    public synchronized Throwable getFault() {
        return this.fault;
    }

    public synchronized boolean isPending() {
        return this.taskListener != null;
    }

    public synchronized long getTimeout() {
        return this.timeout;
    }

    public synchronized void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public synchronized void abort() {
        this.abort = true;
    }

    private static class DefaultExecutorService
    extends AbstractExecutorService {
        private boolean shutdown = false;

        private DefaultExecutorService() {
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public void shutdown() {
            this.shutdownNow();
        }

        @Override
        public List<Runnable> shutdownNow() {
            this.shutdown = true;
            return new ArrayList<Runnable>();
        }

        @Override
        public boolean isShutdown() {
            return this.shutdown;
        }

        @Override
        public boolean isTerminated() {
            return this.isShutdown();
        }

        @Override
        public void execute(Runnable command) {
            Thread thread = new Thread(command);
            thread.start();
        }
    }

    private class ExecuteCallback
    implements Runnable {
        private ExecuteCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TaskListener taskListenerLocal;
            Object resultLocal = null;
            Throwable faultLocal = null;
            try {
                resultLocal = Task.this.execute();
            }
            catch (Throwable throwable) {
                faultLocal = throwable;
            }
            Task task = Task.this;
            synchronized (task) {
                Task.this.result = resultLocal;
                Task.this.fault = faultLocal;
                Task.this.abort = false;
                taskListenerLocal = Task.this.taskListener;
                Task.this.taskListener = null;
            }
            if (faultLocal == null) {
                taskListenerLocal.taskExecuted(Task.this);
            } else {
                taskListenerLocal.executeFailed(Task.this);
            }
        }
    }
}

