/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util.concurrent;

import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.concurrent.AbortException;
import org.apache.pivot.util.concurrent.Task;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.util.concurrent.TaskListener;

public class TaskSequence
extends Task<Void>
implements Sequence<Task<?>>,
Iterable<Task<?>> {
    private ArrayList<Task<?>> tasks = new ArrayList();

    public TaskSequence() {
        this(DEFAULT_EXECUTOR_SERVICE);
    }

    public TaskSequence(ExecutorService executorService) {
        super(executorService);
    }

    @Override
    public synchronized Void execute() throws TaskExecutionException {
        TaskListener<Object> taskListener = new TaskListener<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void taskExecuted(Task<Object> task) {
                TaskSequence taskSequence = TaskSequence.this;
                synchronized (taskSequence) {
                    TaskSequence.this.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void executeFailed(Task<Object> task) {
                TaskSequence taskSequence = TaskSequence.this;
                synchronized (taskSequence) {
                    TaskSequence.this.notify();
                }
            }
        };
        for (Task task : this.tasks) {
            if (this.abort) {
                throw new AbortException();
            }
            task.execute(taskListener);
            try {
                this.wait();
            }
            catch (InterruptedException exception) {
                throw new TaskExecutionException(exception);
            }
        }
        return null;
    }

    @Override
    public synchronized int add(Task<?> task) {
        int index = this.tasks.getLength();
        this.insert(task, index);
        return index;
    }

    @Override
    public synchronized void insert(Task<?> task, int index) {
        if (this.isPending()) {
            throw new IllegalStateException();
        }
        this.tasks.insert(task, index);
    }

    @Override
    public synchronized Task<?> update(int index, Task<?> task) {
        if (this.isPending()) {
            throw new IllegalStateException();
        }
        return this.tasks.update(index, task);
    }

    @Override
    public synchronized int remove(Task<?> task) {
        int index = this.tasks.indexOf(task);
        if (index != -1) {
            this.tasks.remove(index, 1);
        }
        return index;
    }

    @Override
    public synchronized Sequence<Task<?>> remove(int index, int count) {
        if (this.isPending()) {
            throw new IllegalStateException();
        }
        return this.tasks.remove(index, count);
    }

    @Override
    public synchronized Task<?> get(int index) {
        return this.tasks.get(index);
    }

    @Override
    public synchronized int indexOf(Task<?> task) {
        return this.tasks.indexOf(task);
    }

    @Override
    public synchronized int getLength() {
        return this.tasks.getLength();
    }

    @Override
    public Iterator<Task<?>> iterator() {
        return new ImmutableIterator(this.tasks.iterator());
    }
}

