/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.xml;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.xml.ElementListener;
import org.apache.pivot.xml.Node;
import org.apache.pivot.xml.TextNode;

public class Element
extends Node
implements List<Node> {
    private String namespacePrefix;
    private String localName;
    private String defaultNamespaceURI = null;
    private HashMap<String, String> namespaces = new HashMap();
    private NamespaceDictionary namespaceDictionary = new NamespaceDictionary();
    private ElementDictionary elementDictionary = new ElementDictionary();
    private ArrayList<Attribute> attributes = new ArrayList();
    private AttributeSequence attributeSequence = new AttributeSequence();
    private HashMap<String, Attribute> attributeMap = new HashMap();
    private ArrayList<Node> nodes = new ArrayList();
    private List.ListListenerList<Node> listListeners = new List.ListListenerList();
    private ElementListenerList elementListeners = new ElementListenerList();

    public Element(String localName) {
        this(null, localName);
    }

    public Element(String namespacePrefix, String localName) {
        Element.validateName(namespacePrefix, localName);
        this.namespacePrefix = namespacePrefix;
        this.localName = localName;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getName() {
        String name = this.namespacePrefix == null ? this.localName : this.namespacePrefix + ":" + this.localName;
        return name;
    }

    public String getDefaultNamespaceURI() {
        return this.defaultNamespaceURI;
    }

    public void setDefaultNamespaceURI(String defaultNamespaceURI) {
        String previousDefaultNamespaceURI = this.defaultNamespaceURI;
        if (previousDefaultNamespaceURI != defaultNamespaceURI) {
            this.defaultNamespaceURI = defaultNamespaceURI;
            this.elementListeners.defaultNamespaceURIChanged(this, previousDefaultNamespaceURI);
        }
    }

    public NamespaceDictionary getNamespaces() {
        return this.namespaceDictionary;
    }

    public String getNamespaceURI(String prefix) {
        Element parent = this.getParent();
        String namespaceURI = prefix == null ? (this.defaultNamespaceURI == null ? parent.getDefaultNamespaceURI() : this.defaultNamespaceURI) : (this.namespaces.containsKey(prefix) ? this.namespaces.get(prefix) : parent.getNamespaceURI(prefix));
        return namespaceURI;
    }

    public ElementDictionary getElementDictionary() {
        return this.elementDictionary;
    }

    public AttributeSequence getAttributes() {
        return this.attributeSequence;
    }

    @Override
    public int add(Node node) {
        if (node.getParent() != null) {
            throw new IllegalArgumentException();
        }
        int index = this.getLength();
        this.insert(node, index);
        return index;
    }

    @Override
    public void insert(Node node, int index) {
        if (node.getParent() != null) {
            throw new IllegalArgumentException();
        }
        this.nodes.insert(node, index);
        node.setParent(this);
        this.listListeners.itemInserted(this, index);
    }

    @Override
    public Node update(int index, Node node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int remove(Node node) {
        int index = this.indexOf(node);
        if (index != -1) {
            this.remove(index, 1);
        }
        return index;
    }

    @Override
    public Sequence<Node> remove(int index, int count) {
        Sequence<Node> removed = this.nodes.remove(index, count);
        if (count > 0) {
            int n = removed.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = removed.get(i);
                node.setParent(null);
            }
            this.listListeners.itemsRemoved(this, index, removed);
        }
        return removed;
    }

    @Override
    public void clear() {
        if (this.getLength() > 0) {
            int n = this.nodes.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = this.nodes.get(i);
                node.setParent(null);
            }
            this.nodes.clear();
            this.listListeners.listCleared(this);
        }
    }

    @Override
    public Node get(int index) {
        return this.nodes.get(index);
    }

    @Override
    public int indexOf(Node node) {
        return this.nodes.indexOf(node);
    }

    @Override
    public int getLength() {
        return this.nodes.getLength();
    }

    @Override
    public Comparator<Node> getComparator() {
        return null;
    }

    @Override
    public void setComparator(Comparator<Node> comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Node> iterator() {
        return new ImmutableIterator<Node>(this.nodes.iterator());
    }

    @Override
    public boolean isEmpty() {
        return this.attributeMap.isEmpty();
    }

    public List<Element> getElements(String name) {
        ArrayList<Element> elements = new ArrayList<Element>();
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            Element element;
            Node node = this.get(i);
            if (!(node instanceof Element) || !(element = (Element)node).getName().equals(name)) continue;
            elements.add(element);
        }
        return elements;
    }

    public String getText() {
        Node node;
        String text = null;
        if (this.getLength() == 1 && (node = this.get(0)) instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            text = textNode.getText();
        }
        return text;
    }

    @Override
    public ListenerList<ListListener<Node>> getListListeners() {
        return this.listListeners;
    }

    public ListenerList<ElementListener> getElementListeners() {
        return this.elementListeners;
    }

    private static void validateName(String namespacePrefix, String localName) {
        int i;
        int n;
        char c;
        if (namespacePrefix != null) {
            if (namespacePrefix.length() == 0) {
                throw new IllegalArgumentException("Namespace prefix is empty.");
            }
            c = namespacePrefix.charAt(0);
            if (!Character.isLetter(c)) {
                throw new IllegalArgumentException("'" + c + "' is not a valid start" + " character for a namespace prefix.");
            }
            n = namespacePrefix.length();
            for (i = 1; i < n; ++i) {
                c = namespacePrefix.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.') continue;
                throw new IllegalArgumentException("'" + c + "' is not a valid character" + " for a namespace prefix.");
            }
        }
        if (localName == null) {
            throw new IllegalArgumentException();
        }
        if (localName.length() == 0) {
            throw new IllegalArgumentException("Local name is empty.");
        }
        c = localName.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            throw new IllegalArgumentException("'" + c + "' is not a valid start" + " character for a local name.");
        }
        n = localName.length();
        for (i = 1; i < n; ++i) {
            c = localName.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.') continue;
            throw new IllegalArgumentException("'" + c + "' is not a valid character" + " for a local name.");
        }
    }

    public String toString() {
        String string = "<";
        if (this.namespacePrefix != null) {
            string = string + this.namespacePrefix + ":";
        }
        string = string + this.localName + ">";
        return string;
    }

    public class ElementDictionary
    implements Dictionary<String, String> {
        private ElementDictionary() {
        }

        @Override
        public String get(String attributeName) {
            Attribute attribute = (Attribute)Element.this.attributeMap.get(attributeName);
            return attribute == null ? null : attribute.getValue();
        }

        @Override
        public String put(String attributeName, String value) {
            String previousValue;
            Attribute attribute = (Attribute)Element.this.attributeMap.get(attributeName);
            if (attribute == null) {
                String localNameElementDictionary;
                String namespacePrefixElementDictionary;
                previousValue = null;
                int i = attributeName.indexOf(58);
                if (i == -1) {
                    namespacePrefixElementDictionary = null;
                    localNameElementDictionary = attributeName;
                } else {
                    namespacePrefixElementDictionary = attributeName.substring(0, i);
                    localNameElementDictionary = attributeName.substring(i + 1);
                }
                Element.this.attributeSequence.add(new Attribute(namespacePrefixElementDictionary, localNameElementDictionary, value));
            } else {
                previousValue = attribute.getValue();
                attribute.setValue(value);
            }
            return previousValue;
        }

        @Override
        public String remove(String attributeName) {
            Attribute attribute = (Attribute)Element.this.attributeMap.get(attributeName);
            if (attribute != null) {
                Element.this.attributeSequence.remove(attribute);
            }
            return attribute == null ? null : attribute.getValue();
        }

        @Override
        public boolean containsKey(String attributeName) {
            return Element.this.attributeMap.containsKey(attributeName);
        }
    }

    private static class ElementListenerList
    extends ListenerList<ElementListener>
    implements ElementListener {
        private ElementListenerList() {
        }

        @Override
        public void defaultNamespaceURIChanged(Element element, String previousDefaultNamespaceURI) {
            for (ElementListener listener : this) {
                listener.defaultNamespaceURIChanged(element, previousDefaultNamespaceURI);
            }
        }

        @Override
        public void namespaceAdded(Element element, String prefix) {
            for (ElementListener listener : this) {
                listener.namespaceAdded(element, prefix);
            }
        }

        @Override
        public void namespaceUpdated(Element element, String prefix, String previousURI) {
            for (ElementListener listener : this) {
                listener.namespaceUpdated(element, prefix, previousURI);
            }
        }

        @Override
        public void namespaceRemoved(Element element, String prefix, String uri) {
            for (ElementListener listener : this) {
                listener.namespaceRemoved(element, prefix, uri);
            }
        }

        @Override
        public void attributeInserted(Element element, int index) {
            for (ElementListener listener : this) {
                listener.attributeInserted(element, index);
            }
        }

        @Override
        public void attributesRemoved(Element element, int index, Sequence<Attribute> attributes) {
            for (ElementListener listener : this) {
                listener.attributesRemoved(element, index, attributes);
            }
        }

        @Override
        public void attributeValueChanged(Attribute attribute, String previousValue) {
            for (ElementListener listener : this) {
                listener.attributeValueChanged(attribute, previousValue);
            }
        }
    }

    public class NamespaceDictionary
    implements Dictionary<String, String>,
    Iterable<String> {
        private NamespaceDictionary() {
        }

        @Override
        public String get(String prefix) {
            return (String)Element.this.namespaces.get(prefix);
        }

        @Override
        public String put(String prefix, String uri) {
            if (uri == null) {
                throw new IllegalArgumentException("uri is null.");
            }
            boolean update = this.containsKey(prefix);
            String previousURI = Element.this.namespaces.put(prefix, uri);
            if (update) {
                Element.this.elementListeners.namespaceUpdated(Element.this, prefix, previousURI);
            } else {
                Element.this.elementListeners.namespaceAdded(Element.this, prefix);
            }
            return previousURI;
        }

        @Override
        public String remove(String prefix) {
            String uri = null;
            if (this.containsKey(prefix)) {
                uri = (String)Element.this.namespaces.remove(prefix);
                Element.this.elementListeners.namespaceRemoved(Element.this, prefix, uri);
            }
            return uri;
        }

        @Override
        public boolean containsKey(String prefix) {
            return Element.this.namespaces.containsKey(prefix);
        }

        @Override
        public Iterator<String> iterator() {
            return new ImmutableIterator<String>(Element.this.namespaces.iterator());
        }
    }

    public class AttributeSequence
    implements Sequence<Attribute>,
    Iterable<Attribute> {
        private AttributeSequence() {
        }

        @Override
        public int add(Attribute attribute) {
            int index = this.getLength();
            this.insert(attribute, index);
            return index;
        }

        @Override
        public void insert(Attribute attribute, int index) {
            if (attribute == null) {
                throw new IllegalArgumentException();
            }
            if (attribute.getElement() != null) {
                throw new IllegalArgumentException();
            }
            String attributeName = attribute.getName();
            if (Element.this.attributeMap.containsKey(attributeName)) {
                throw new IllegalArgumentException("Attribute \"" + attributeName + "\" already exists.");
            }
            Element.this.attributes.insert(attribute, index);
            Element.this.attributeMap.put(attributeName, attribute);
            attribute.element = Element.this;
            Element.this.elementListeners.attributeInserted(Element.this, index);
        }

        @Override
        public Attribute update(int index, Attribute item) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int remove(Attribute attribute) {
            int index = this.indexOf(attribute);
            if (index != -1) {
                this.remove(index, 1);
            }
            return index;
        }

        @Override
        public Sequence<Attribute> remove(int index, int count) {
            Sequence<Attribute> removed = Element.this.attributes.remove(index, count);
            if (count > 0) {
                int n = removed.getLength();
                for (int i = 0; i < n; ++i) {
                    Attribute attribute = removed.get(i);
                    String attributeName = attribute.getName();
                    Element.this.attributeMap.remove(attributeName);
                    attribute.element = null;
                }
                Element.this.elementListeners.attributesRemoved(Element.this, index, removed);
            }
            return removed;
        }

        @Override
        public Attribute get(int index) {
            return (Attribute)Element.this.attributes.get(index);
        }

        @Override
        public int indexOf(Attribute attribute) {
            return Element.this.attributes.indexOf(attribute);
        }

        @Override
        public int getLength() {
            return Element.this.attributes.getLength();
        }

        @Override
        public Iterator<Attribute> iterator() {
            return new ImmutableIterator<Attribute>(Element.this.attributes.iterator());
        }
    }

    public static class Attribute {
        private Element element = null;
        private String namespacePrefix;
        private String localName;
        private String value;

        public Attribute(String localName, String value) {
            this(null, localName, value);
        }

        public Attribute(String namespacePrefix, String localName, String value) {
            Element.validateName(namespacePrefix, localName);
            this.namespacePrefix = namespacePrefix;
            this.localName = localName;
            this.setValue(value);
        }

        public Element getElement() {
            return this.element;
        }

        public String getNamespacePrefix() {
            return this.namespacePrefix;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String getName() {
            String name = this.namespacePrefix == null ? this.localName : this.namespacePrefix + ":" + this.localName;
            return name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            String previousValue = this.value;
            if (previousValue != value) {
                this.value = value;
                if (this.element != null) {
                    this.element.elementListeners.attributeValueChanged(this, previousValue);
                }
            }
        }

        public boolean equals(Object o) {
            boolean equals = false;
            if (this == o) {
                equals = true;
            } else if (o instanceof Attribute) {
                Attribute attribute = (Attribute)o;
                equals = this.namespacePrefix == null ? attribute.namespacePrefix == null : this.namespacePrefix.equals(attribute.namespacePrefix);
                equals &= this.localName.equals(attribute.localName) && this.value.equals(attribute.value);
            }
            return equals;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            if (this.namespacePrefix != null) {
                result = 31 * result + this.namespacePrefix.hashCode();
            }
            result = 31 * result + this.localName.hashCode();
            return result;
        }

        public String toString() {
            String string = "";
            if (this.namespacePrefix != null) {
                string = string + this.namespacePrefix + ":";
            }
            string = string + this.localName + "=\"" + this.value + "\"";
            return string;
        }
    }
}

