/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.web.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.serialization.Serializer;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.web.Query;
import org.apache.pivot.web.QueryDictionary;
import org.apache.pivot.web.QueryException;

public abstract class QueryServlet
extends HttpServlet {
    private static final long serialVersionUID = 4881638232902478092L;
    private boolean determineContentLength = false;
    private transient ThreadLocal<String> hostname = new ThreadLocal();
    private transient ThreadLocal<Integer> port = new ThreadLocal();
    private transient ThreadLocal<String> contextPath = new ThreadLocal();
    private transient ThreadLocal<String> servletPath = new ThreadLocal();
    private transient ThreadLocal<Boolean> secure = new ThreadLocal();
    private transient ThreadLocal<QueryDictionary> parameters = new ThreadLocal();
    private transient ThreadLocal<QueryDictionary> requestHeaders = new ThreadLocal();
    private transient ThreadLocal<QueryDictionary> responseHeaders = new ThreadLocal();
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String URL_ENCODING = "UTF-8";
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String CONTENT_LENGTH_HEADER = "Content-Length";
    public static final String LOCATION_HEADER = "Location";

    public String getHostname() {
        return this.hostname.get();
    }

    public int getPort() {
        return this.port.get();
    }

    public String getContextPath() {
        return this.contextPath.get();
    }

    public String getServletPath() {
        return this.servletPath.get();
    }

    public boolean isSecure() {
        return this.secure.get();
    }

    public String getProtocol() {
        return this.isSecure() ? HTTPS_PROTOCOL : HTTP_PROTOCOL;
    }

    public URL getLocation() {
        URL location;
        try {
            location = new URL(this.isSecure() ? HTTPS_PROTOCOL : HTTP_PROTOCOL, this.getHostname(), this.getPort(), this.getContextPath() + this.getServletPath() + "/");
        }
        catch (MalformedURLException exception) {
            throw new RuntimeException(exception);
        }
        return location;
    }

    public QueryDictionary getParameters() {
        return this.parameters.get();
    }

    public QueryDictionary getRequestHeaders() {
        return this.requestHeaders.get();
    }

    public QueryDictionary getResponseHeaders() {
        return this.responseHeaders.get();
    }

    protected void prepare() throws ServletException {
    }

    protected void dispose() throws ServletException {
    }

    protected void validate(Query.Method method, Path path) throws QueryException {
    }

    protected Object doGet(Path path) throws QueryException {
        throw new QueryException(405);
    }

    protected URL doPost(Path path, Object value) throws QueryException {
        throw new QueryException(405);
    }

    protected boolean doPut(Path path, Object value) throws QueryException {
        throw new QueryException(405);
    }

    protected void doDelete(Path path) throws QueryException {
        throw new QueryException(405);
    }

    protected abstract Serializer<?> createSerializer(Query.Method var1, Path var2) throws QueryException;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            try {
                URL url = new URL(request.getRequestURL().toString());
                this.hostname.set(url.getHost());
                this.port.set(request.getLocalPort());
                this.contextPath.set(request.getContextPath());
                this.servletPath.set(request.getServletPath());
                this.secure.set(url.getProtocol().equalsIgnoreCase(HTTPS_PROTOCOL));
            }
            catch (MalformedURLException exception) {
                throw new ServletException((Throwable)exception);
            }
            this.parameters.set(new QueryDictionary(true));
            this.requestHeaders.set(new QueryDictionary(false));
            this.responseHeaders.set(new QueryDictionary(false));
            String queryString = request.getQueryString();
            if (queryString != null) {
                QueryDictionary parametersDictionary = this.parameters.get();
                String[] pairs = queryString.split("&");
                int n = pairs.length;
                for (int i = 0; i < n; ++i) {
                    String[] pair = pairs[i].split("=");
                    String key = URLDecoder.decode(pair[0], URL_ENCODING);
                    String value = URLDecoder.decode(pair.length > 1 ? pair[1] : "", URL_ENCODING);
                    parametersDictionary.add(key, value);
                }
            }
            QueryDictionary requestHeaderDictionary = this.requestHeaders.get();
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String headerValue = request.getHeader(headerName);
                requestHeaderDictionary.add(headerName, headerValue);
            }
            this.prepare();
            super.service(request, response);
        }
        catch (IOException exception) {
            System.err.println(exception);
            throw exception;
        }
        catch (RuntimeException exception) {
            System.err.println(exception);
            throw exception;
        }
        finally {
            this.hostname.remove();
            this.port.remove();
            this.contextPath.remove();
            this.servletPath.remove();
            this.secure.remove();
            this.parameters.remove();
            this.requestHeaders.remove();
            this.responseHeaders.remove();
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Path path = QueryServlet.getPath(request);
        Object result = null;
        Serializer<?> serializer = null;
        try {
            this.validate(Query.Method.GET, path);
            result = this.doGet(path);
            serializer = this.createSerializer(Query.Method.GET, path);
        }
        catch (QueryException exception) {
            response.setStatus(exception.getStatus());
            response.flushBuffer();
        }
        if (!response.isCommitted() && serializer != null) {
            response.setStatus(200);
            this.setResponseHeaders(response);
            response.setContentType(serializer.getMIMEType(result));
            ServletOutputStream responseOutputStream = response.getOutputStream();
            if (this.determineContentLength) {
                File tempFile = File.createTempFile(((Object)((Object)this)).getClass().getName(), null);
                FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
                try {
                    serializer.writeObject(result, (OutputStream)fileOutputStream);
                }
                catch (SerializationException exception) {
                    throw new ServletException((Throwable)exception);
                }
                finally {
                    fileOutputStream.close();
                }
                response.setHeader(CONTENT_LENGTH_HEADER, String.valueOf(tempFile.length()));
                FileInputStream fileInputStream = new FileInputStream(tempFile);
                try {
                    int nBytes;
                    byte[] buffer = new byte[1024];
                    do {
                        if ((nBytes = fileInputStream.read(buffer)) <= 0) continue;
                        responseOutputStream.write(buffer, 0, nBytes);
                    } while (nBytes != -1);
                }
                finally {
                    fileInputStream.close();
                }
            }
            try {
                serializer.writeObject(result, (OutputStream)responseOutputStream);
            }
            catch (SerializationException exception) {
                throw new ServletException((Throwable)exception);
            }
            response.flushBuffer();
        }
    }

    protected final void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Path path = QueryServlet.getPath(request);
        URL location = null;
        try {
            this.validate(Query.Method.POST, path);
            Object value = null;
            if (request.getContentLength() > 0) {
                Serializer<?> serializer = this.createSerializer(Query.Method.POST, path);
                value = serializer.readObject((InputStream)request.getInputStream());
            }
            location = this.doPost(path, value);
        }
        catch (SerializationException exception) {
            throw new ServletException((Throwable)exception);
        }
        catch (QueryException exception) {
            response.setStatus(exception.getStatus());
            response.flushBuffer();
        }
        if (!response.isCommitted()) {
            if (location == null) {
                response.setStatus(204);
            } else {
                response.setStatus(201);
                response.setHeader(LOCATION_HEADER, location.toString());
            }
            this.setResponseHeaders(response);
            response.setContentLength(0);
        }
    }

    protected final void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Path path = QueryServlet.getPath(request);
        boolean created = false;
        try {
            this.validate(Query.Method.PUT, path);
            Object value = null;
            if (request.getContentLength() > 0) {
                Serializer<?> serializer = this.createSerializer(Query.Method.PUT, path);
                value = serializer.readObject((InputStream)request.getInputStream());
            }
            created = this.doPut(path, value);
        }
        catch (SerializationException exception) {
            throw new ServletException((Throwable)exception);
        }
        catch (QueryException exception) {
            response.setStatus(exception.getStatus());
            response.flushBuffer();
        }
        if (!response.isCommitted()) {
            response.setStatus(created ? 201 : 204);
            this.setResponseHeaders(response);
            response.setContentLength(0);
            response.flushBuffer();
        }
    }

    protected final void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            Path path = QueryServlet.getPath(request);
            this.validate(Query.Method.DELETE, path);
            this.doDelete(path);
        }
        catch (QueryException exception) {
            response.setStatus(exception.getStatus());
            response.flushBuffer();
        }
        if (!response.isCommitted()) {
            response.setStatus(204);
            this.setResponseHeaders(response);
            response.setContentLength(0);
            response.flushBuffer();
        }
    }

    protected final void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setStatus(405);
        response.flushBuffer();
    }

    protected final void doOptions(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setStatus(405);
        response.flushBuffer();
    }

    protected final void doTrace(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setStatus(405);
        response.flushBuffer();
    }

    private static Path getPath(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        Path path = pathInfo == null || pathInfo.length() == 0 ? new Path() : new Path(pathInfo.substring(1).split("/"));
        return path;
    }

    private void setResponseHeaders(HttpServletResponse response) {
        QueryDictionary responseHeaderDictionary = this.responseHeaders.get();
        for (String key : responseHeaderDictionary) {
            int n = responseHeaderDictionary.getLength(key);
            for (int i = 0; i < n; ++i) {
                response.addHeader(key, responseHeaderDictionary.get(key, i));
            }
        }
    }

    public static class Path
    implements Sequence<String>,
    Iterable<String> {
        private ArrayList<String> elements;

        public Path() {
            this(new String[0]);
        }

        public Path(String[] elements) {
            this.elements = new ArrayList((Object[])elements);
        }

        public int add(String element) {
            throw new UnsupportedOperationException();
        }

        public void insert(String element, int index) {
            throw new UnsupportedOperationException();
        }

        public String update(int index, String element) {
            throw new UnsupportedOperationException();
        }

        public int remove(String element) {
            throw new UnsupportedOperationException();
        }

        public Sequence<String> remove(int index, int count) {
            return this.elements.remove(index, count);
        }

        public String get(int index) {
            return (String)this.elements.get(index);
        }

        public int indexOf(String element) {
            return this.elements.indexOf((Object)element);
        }

        public int getLength() {
            return this.elements.getLength();
        }

        @Override
        public Iterator<String> iterator() {
            return new ImmutableIterator((Iterator)this.elements.iterator());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (String element : this.elements) {
                sb.append("/");
                sb.append(element);
            }
            return sb.toString();
        }
    }
}

