/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.camel;

import java.util.Map;
import java.util.Objects;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.plc4x.camel.Plc4XConsumer;
import org.apache.plc4x.camel.Plc4XProducer;
import org.apache.plc4x.java.PlcDriverManager;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.utils.connectionpool.PooledPlcDriverManager;

@UriEndpoint(scheme="plc4x", title="PLC4X", syntax="plc4x:driver", label="plc4x")
public class Plc4XEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required=true)
    private String driver;
    @UriParam
    private Map<String, Object> tags;
    @UriParam
    private String trigger;
    @UriParam
    private int period;
    private PlcDriverManager plcDriverManager = new PlcDriverManager();
    private PlcConnection connection;
    private String uri;

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public String getUri() {
        return this.uri;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public void setTrigger(String trigger) {
        String plc4xURI;
        this.trigger = trigger;
        this.plcDriverManager = new PooledPlcDriverManager();
        this.uri = plc4xURI = this.uri.replaceFirst("plc4x:/?/?", "");
        try {
            this.connection = this.plcDriverManager.getConnection(plc4xURI);
        }
        catch (PlcConnectionException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
    }

    public Plc4XEndpoint(String endpointUri, Component component) throws PlcConnectionException {
        super(endpointUri, component);
        this.uri = endpointUri.replaceFirst("plc4x:/?/?", "");
        this.connection = this.plcDriverManager.getConnection(this.uri);
    }

    public PlcConnection getConnection() {
        return this.connection;
    }

    public void setProperties(Object bean, Map<String, Object> parameters) {
    }

    public Producer createProducer() throws Exception {
        if (!this.connection.isConnected()) {
            this.connection = this.plcDriverManager.getConnection(this.uri.replaceFirst("plc4x:/?/?", ""));
        }
        return new Plc4XProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (!this.connection.isConnected()) {
            this.connection = this.plcDriverManager.getConnection(this.uri.replaceFirst("plc4x:/?/?", ""));
        }
        return new Plc4XConsumer(this, processor);
    }

    public boolean isSingleton() {
        return true;
    }

    public PlcDriverManager getPlcDriverManager() {
        return this.plcDriverManager;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public Map<String, Object> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, Object> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Plc4XEndpoint)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Plc4XEndpoint that = (Plc4XEndpoint)((Object)o);
        return Objects.equals(this.getDriver(), that.getDriver()) && Objects.equals(this.getTags(), that.getTags()) && Objects.equals(this.getPlcDriverManager(), that.getPlcDriverManager());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDriver(), this.getTags(), this.getPlcDriverManager());
    }

    public void doStop() throws Exception {
        if (this.connection != null && this.connection.isConnected()) {
            this.connection.close();
        }
    }
}

