/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.jline;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.gogo.jline.Shell;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Process;
import org.jline.builtins.Commands;
import org.jline.builtins.Less;
import org.jline.builtins.Nano;
import org.jline.builtins.Options;
import org.jline.builtins.Source;
import org.jline.builtins.TTop;
import org.jline.terminal.Attributes;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedCharSequence;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.InfoCmp;
import org.jline.utils.OSUtils;
import org.jline.utils.StyleResolver;

public class Posix {
    static final String[] functions;
    public static final String DEFAULT_LS_COLORS = "dr=1;91:ex=1;92:sl=1;96:ot=34;43";
    public static final String DEFAULT_GREP_COLORS = "mt=1;31:fn=35:ln=32:se=36";
    private static final LinkOption[] NO_FOLLOW_OPTIONS;
    private static final List<String> WINDOWS_EXECUTABLE_EXTENSIONS;
    private static final LinkOption[] EMPTY_LINK_OPTIONS;
    private final CommandProcessor processor;

    public Posix(CommandProcessor processor) {
        this.processor = processor;
    }

    public void _main(CommandSession session, String[] argv) {
        if (argv == null || argv.length < 1) {
            throw new IllegalArgumentException();
        }
        Process process = Process.Utils.current();
        try {
            this.run(session, process, argv);
        }
        catch (IllegalArgumentException e) {
            process.err().println(e.getMessage());
            process.error(2);
        }
        catch (HelpException e) {
            process.err().println(e.getMessage());
            process.error(0);
        }
        catch (Exception e) {
            process.err().println(argv[0] + ": " + e.toString());
            process.error(1);
        }
    }

    protected Options parseOptions(CommandSession session, String[] usage, Object[] argv) throws Exception {
        Options opt = Options.compile((String[])usage, s -> this.get(session, (String)s)).parse(argv, true);
        if (opt.isSet("help")) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            opt.usage(new PrintStream(baos));
            throw new HelpException(baos.toString());
        }
        return opt;
    }

    protected String get(CommandSession session, String name) {
        Object o = session.get(name);
        return o != null ? o.toString() : null;
    }

    protected Object run(CommandSession session, Process process, String[] argv) throws Exception {
        switch (argv[0]) {
            case "cat": {
                this.cat(session, process, argv);
                break;
            }
            case "echo": {
                this.echo(session, process, argv);
                break;
            }
            case "grep": {
                this.grep(session, process, argv);
                break;
            }
            case "sort": {
                this.sort(session, process, argv);
                break;
            }
            case "sleep": {
                this.sleep(session, process, argv);
                break;
            }
            case "cd": {
                this.cd(session, process, argv);
                break;
            }
            case "pwd": {
                this.pwd(session, process, argv);
                break;
            }
            case "ls": {
                this.ls(session, process, argv);
                break;
            }
            case "less": {
                this.less(session, process, argv);
                break;
            }
            case "watch": {
                this.watch(session, process, argv);
                break;
            }
            case "nano": {
                this.nano(session, process, argv);
                break;
            }
            case "tmux": {
                this.tmux(session, process, argv);
                break;
            }
            case "ttop": {
                this.ttop(session, process, argv);
                break;
            }
            case "clear": {
                this.clear(session, process, argv);
                break;
            }
            case "head": {
                this.head(session, process, argv);
                break;
            }
            case "tail": {
                this.tail(session, process, argv);
                break;
            }
            case "wc": {
                this.wc(session, process, argv);
                break;
            }
            case "date": {
                this.date(session, process, argv);
            }
        }
        return null;
    }

    protected void date(CommandSession session, Process process, String[] argv) throws Exception {
        CharSequence[] usage = new String[]{"date -  display date", "Usage: date [-r seconds] [-v[+|-]val[mwdHMS] ...] [-f input_fmt new_date] [+output_fmt]", "  -? --help                    Show help", "  -u                           Use UTC", "  -r                           Print the date represented by 'seconds' since January 1, 1970", "  -f                           Use 'input_fmt' to parse 'new_date'"};
        Date input = new Date();
        String output = null;
        for (int i = 1; i < argv.length; ++i) {
            if ("-?".equals(argv[i]) || "--help".equals(argv[i])) {
                throw new HelpException(String.join((CharSequence)"\n", usage));
            }
            if ("-r".equals(argv[i])) {
                if (i + 1 < argv.length) {
                    input = new Date(Long.parseLong(argv[++i]) * 1000L);
                    continue;
                }
                throw new IllegalArgumentException("usage: date [-u] [-r seconds] [-v[+|-]val[mwdHMS] ...] [-f input_fmt new_date] [+output_fmt]");
            }
            if ("-f".equals(argv[i])) {
                if (i + 2 < argv.length) {
                    String fmt = argv[++i];
                    String inp = argv[++i];
                    String jfmt = this.toJavaDateFormat(fmt);
                    input = new SimpleDateFormat(jfmt).parse(inp);
                    continue;
                }
                throw new IllegalArgumentException("usage: date [-u] [-r seconds] [-v[+|-]val[mwdHMS] ...] [-f input_fmt new_date] [+output_fmt]");
            }
            if (argv[i].startsWith("+")) {
                if (output == null) {
                    output = argv[i].substring(1);
                    continue;
                }
                throw new IllegalArgumentException("usage: date [-u] [-r seconds] [-v[+|-]val[mwdHMS] ...] [-f input_fmt new_date] [+output_fmt]");
            }
            throw new IllegalArgumentException("usage: date [-u] [-r seconds] [-v[+|-]val[mwdHMS] ...] [-f input_fmt new_date] [+output_fmt]");
        }
        if (output == null) {
            output = "%c";
        }
        process.out().println(new SimpleDateFormat(this.toJavaDateFormat(output)).format(input));
    }

    private String toJavaDateFormat(String format) {
        StringBuilder sb = new StringBuilder();
        boolean quote = false;
        for (int i = 0; i < format.length(); ++i) {
            char c = format.charAt(i);
            if (c == '%') {
                if (i + 1 < format.length()) {
                    if (quote) {
                        sb.append('\'');
                        quote = false;
                    }
                    c = format.charAt(++i);
                    switch (c) {
                        case '+': 
                        case 'A': {
                            sb.append("MMM EEE d HH:mm:ss yyyy");
                            break;
                        }
                        case 'a': {
                            sb.append("EEE");
                            break;
                        }
                        case 'B': {
                            sb.append("MMMMMMM");
                            break;
                        }
                        case 'b': {
                            sb.append("MMM");
                            break;
                        }
                        case 'C': {
                            sb.append("yy");
                            break;
                        }
                        case 'c': {
                            sb.append("MMM EEE d HH:mm:ss yyyy");
                            break;
                        }
                        case 'D': {
                            sb.append("MM/dd/yy");
                            break;
                        }
                        case 'd': {
                            sb.append("dd");
                            break;
                        }
                        case 'e': {
                            sb.append("dd");
                            break;
                        }
                        case 'F': {
                            sb.append("yyyy-MM-dd");
                            break;
                        }
                        case 'G': {
                            sb.append("YYYY");
                            break;
                        }
                        case 'g': {
                            sb.append("YY");
                            break;
                        }
                        case 'H': {
                            sb.append("HH");
                            break;
                        }
                        case 'h': {
                            sb.append("MMM");
                            break;
                        }
                        case 'I': {
                            sb.append("hh");
                            break;
                        }
                        case 'j': {
                            sb.append("DDD");
                            break;
                        }
                        case 'k': {
                            sb.append("HH");
                            break;
                        }
                        case 'l': {
                            sb.append("hh");
                            break;
                        }
                        case 'M': {
                            sb.append("mm");
                            break;
                        }
                        case 'm': {
                            sb.append("MM");
                            break;
                        }
                        case 'N': {
                            sb.append("S");
                            break;
                        }
                        case 'n': {
                            sb.append("\n");
                            break;
                        }
                        case 'P': {
                            sb.append("aa");
                            break;
                        }
                        case 'p': {
                            sb.append("aa");
                            break;
                        }
                        case 'r': {
                            sb.append("hh:mm:ss aa");
                            break;
                        }
                        case 'R': {
                            sb.append("HH:mm");
                            break;
                        }
                        case 'S': {
                            sb.append("ss");
                            break;
                        }
                        case 's': {
                            sb.append("S");
                            break;
                        }
                        case 'T': {
                            sb.append("HH:mm:ss");
                            break;
                        }
                        case 't': {
                            sb.append("\t");
                            break;
                        }
                        case 'U': {
                            sb.append("w");
                            break;
                        }
                        case 'u': {
                            sb.append("u");
                            break;
                        }
                        case 'V': {
                            sb.append("W");
                            break;
                        }
                        case 'v': {
                            sb.append("dd-MMM-yyyy");
                            break;
                        }
                        case 'W': {
                            sb.append("w");
                            break;
                        }
                        case 'w': {
                            sb.append("u");
                            break;
                        }
                        case 'X': {
                            sb.append("HH:mm:ss");
                            break;
                        }
                        case 'x': {
                            sb.append("MM/dd/yy");
                            break;
                        }
                        case 'Y': {
                            sb.append("yyyy");
                            break;
                        }
                        case 'y': {
                            sb.append("yy");
                            break;
                        }
                        case 'Z': {
                            sb.append("z");
                            break;
                        }
                        case 'z': {
                            sb.append("X");
                            break;
                        }
                        case '%': {
                            sb.append("%");
                        }
                    }
                    continue;
                }
                if (!quote) {
                    sb.append('\'');
                }
                sb.append(c);
                sb.append('\'');
                continue;
            }
            if ((c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') && !quote) {
                sb.append('\'');
                quote = true;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected void wc(CommandSession session, Process process, String[] argv) throws Exception {
        String[] usage = new String[]{"wc -  word, line, character, and byte count", "Usage: wc [OPTIONS] [FILES]", "  -? --help                    Show help", "  -l --lines                   Print line counts", "  -c --bytes                   Print byte counts", "  -m --chars                   Print character counts", "  -w --words                   Print word counts"};
        Options opt = this.parseOptions(session, usage, argv);
        ArrayList<StdInSource> sources = new ArrayList<StdInSource>();
        if (opt.args().isEmpty()) {
            opt.args().add("-");
        }
        for (String arg : opt.args()) {
            if ("-".equals(arg)) {
                sources.add(new StdInSource(process));
                continue;
            }
            sources.add((StdInSource)new Source.PathSource(session.currentDir().resolve(arg), arg));
        }
        boolean displayLines = opt.isSet("lines");
        boolean displayWords = opt.isSet("words");
        boolean displayChars = opt.isSet("chars");
        boolean displayBytes = opt.isSet("bytes");
        if (displayChars) {
            displayBytes = false;
        }
        if (!(displayLines || displayWords || displayChars || displayBytes)) {
            displayLines = true;
            displayWords = true;
            displayBytes = true;
        }
        String format = "";
        if (displayLines) {
            format = format + "%1$8d";
        }
        if (displayWords) {
            format = format + "%2$8d";
        }
        if (displayChars) {
            format = format + "%3$8d";
        }
        if (displayBytes) {
            format = format + "%4$8d";
        }
        format = format + "  %5s";
        int totalLines = 0;
        int totalBytes = 0;
        int totalChars = 0;
        int totalWords = 0;
        for (Source source : sources) {
            InputStream is = source.read();
            Throwable throwable = null;
            try {
                AtomicInteger lines = new AtomicInteger();
                final AtomicInteger bytes = new AtomicInteger();
                AtomicInteger chars = new AtomicInteger();
                AtomicInteger words = new AtomicInteger();
                AtomicBoolean inWord = new AtomicBoolean();
                AtomicBoolean lastNl = new AtomicBoolean(true);
                FilterInputStream isc = new FilterInputStream(is){

                    @Override
                    public int read() throws IOException {
                        int b = super.read();
                        if (b >= 0) {
                            bytes.incrementAndGet();
                        }
                        return b;
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        int nb = super.read(b, off, len);
                        if (nb > 0) {
                            bytes.addAndGet(nb);
                        }
                        return nb;
                    }
                };
                IntConsumer consumer = cp -> {
                    chars.incrementAndGet();
                    boolean ws = Character.isWhitespace(cp);
                    if (inWord.getAndSet(!ws) && ws) {
                        words.incrementAndGet();
                    }
                    if (cp == 10) {
                        lines.incrementAndGet();
                        lastNl.set(true);
                    } else {
                        lastNl.set(false);
                    }
                };
                InputStreamReader reader = new InputStreamReader(isc);
                while (true) {
                    int h;
                    if (Character.isHighSurrogate((char)(h = ((Reader)reader).read()))) {
                        int l = ((Reader)reader).read();
                        if (Character.isLowSurrogate((char)l)) {
                            int cp2 = Character.toCodePoint((char)h, (char)l);
                            consumer.accept(cp2);
                            continue;
                        }
                        consumer.accept(h);
                        if (l < 0) break;
                        consumer.accept(l);
                        continue;
                    }
                    if (h < 0) break;
                    consumer.accept(h);
                }
                if (inWord.get()) {
                    words.incrementAndGet();
                }
                if (!lastNl.get()) {
                    lines.incrementAndGet();
                }
                process.out().println(String.format(format, lines.get(), words.get(), chars.get(), bytes.get(), source.getName()));
                totalBytes += bytes.get();
                totalChars += chars.get();
                totalWords += words.get();
                totalLines += lines.get();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        if (sources.size() > 1) {
            process.out().println(String.format(format, totalLines, totalWords, totalChars, totalBytes, "total"));
        }
    }

    protected void head(CommandSession session, Process process, String[] argv) throws Exception {
        String[] usage = new String[]{"head -  displays first lines of file", "Usage: head [-n lines | -c bytes] [file ...]", "  -? --help                    Show help", "  -n --lines=LINES             Print line counts", "  -c --bytes=BYTES             Print byte counts"};
        Options opt = this.parseOptions(session, usage, argv);
        if (opt.isSet("lines") && opt.isSet("bytes")) {
            throw new IllegalArgumentException("usage: head [-n # | -c #] [file ...]");
        }
        int nbLines = Integer.MAX_VALUE;
        int nbBytes = Integer.MAX_VALUE;
        if (opt.isSet("lines")) {
            nbLines = opt.getNumber("lines");
        } else if (opt.isSet("bytes")) {
            nbBytes = opt.getNumber("bytes");
        } else {
            nbLines = 10;
        }
        ArrayList<StdInSource> sources = new ArrayList<StdInSource>();
        if (opt.args().isEmpty()) {
            opt.args().add("-");
        }
        for (String string : opt.args()) {
            if ("-".equals(string)) {
                sources.add(new StdInSource(process));
                continue;
            }
            sources.add((StdInSource)new Source.PathSource(session.currentDir().resolve(string), string));
        }
        for (Source source : sources) {
            int bytes = nbBytes;
            int lines = nbLines;
            if (sources.size() > 1) {
                if (source != sources.get(0)) {
                    process.out().println();
                }
                process.out().println("==> " + source.getName() + " <==");
            }
            InputStream is = source.read();
            Throwable throwable = null;
            try {
                int nb;
                byte[] buf = new byte[1024];
                do {
                    if ((nb = is.read(buf)) <= 0 || lines <= 0 || bytes <= 0) continue;
                    nb = Math.min(nb, bytes);
                    for (int i = 0; i < nb; ++i) {
                        if (buf[i] != 10 || --lines > 0) continue;
                        nb = i + 1;
                        break;
                    }
                    bytes -= nb;
                    process.out().write(buf, 0, nb);
                } while (nb > 0 && lines > 0 && bytes > 0);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tail(final CommandSession session, final Process process, String[] argv) throws Exception {
        int bytes;
        int lines;
        String[] usage = new String[]{"tail -  displays last lines of file", "Usage: tail [-f] [-q] [-c # | -n #] [file ...]", "  -? --help                    Show help", "  -q --quiet                   Suppress headers when printing multiple sources", "  -f --follow                  Do not stop at end of file", "  -F --FOLLOW                  Follow and check for file renaming or rotation", "  -n --lines=LINES             Number of lines to print", "  -c --bytes=BYTES             Number of bytes to print"};
        final Options opt = this.parseOptions(session, usage, argv);
        if (opt.isSet("lines") && opt.isSet("bytes")) {
            throw new IllegalArgumentException("usage: tail [-f] [-q] [-c # | -n #] [file ...]");
        }
        if (opt.isSet("lines")) {
            lines = opt.getNumber("lines");
            bytes = Integer.MAX_VALUE;
        } else if (opt.isSet("bytes")) {
            lines = Integer.MAX_VALUE;
            bytes = opt.getNumber("bytes");
        } else {
            lines = 10;
            bytes = Integer.MAX_VALUE;
        }
        final boolean follow = opt.isSet("follow") || opt.isSet("FOLLOW");
        final AtomicReference lastPrinted = new AtomicReference();
        final WatchService watchService = follow ? session.currentDir().getFileSystem().newWatchService() : null;
        final HashSet watched = new HashSet();
        if (opt.args().isEmpty()) {
            opt.args().add("-");
        }
        class Input
        implements Closeable {
            String name;
            Path path;
            Reader reader;
            StringBuilder buffer;
            long ino;
            long size;

            public Input(String name) {
                this.name = name;
                this.buffer = new StringBuilder();
            }

            public void open() {
                if (this.reader == null) {
                    try {
                        InputStream is;
                        if ("-".equals(this.name)) {
                            is = new StdInSource(process).read();
                        } else {
                            this.path = session.currentDir().resolve(this.name);
                            is = Files.newInputStream(this.path, new OpenOption[0]);
                            if (opt.isSet("FOLLOW")) {
                                try {
                                    this.ino = (Long)Files.getAttribute(this.path, "unix:ino", new LinkOption[0]);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            this.size = Files.size(this.path);
                        }
                        this.reader = new InputStreamReader(is);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void close() throws IOException {
                if (this.reader != null) {
                    try {
                        this.reader.close();
                    }
                    finally {
                        this.reader = null;
                    }
                }
            }

            public boolean tail() throws IOException {
                this.open();
                if (this.reader != null) {
                    if (this.buffer != null) {
                        Path parent;
                        int nb;
                        char[] buf = new char[1024];
                        while ((nb = this.reader.read(buf)) > 0) {
                            this.buffer.append(buf, 0, nb);
                            if (bytes > 0 && this.buffer.length() > bytes) {
                                this.buffer.delete(0, this.buffer.length() - bytes);
                                continue;
                            }
                            int l = 0;
                            int i = -1;
                            while ((i = this.buffer.indexOf("\n", i + 1)) >= 0) {
                                ++l;
                            }
                            if (l <= lines) continue;
                            i = -1;
                            l -= lines;
                            while (--l >= 0) {
                                i = this.buffer.indexOf("\n", i + 1);
                            }
                            this.buffer.delete(0, i + 1);
                        }
                        String toPrint = this.buffer.toString();
                        this.print(toPrint);
                        this.buffer = null;
                        if (follow && this.path != null && !watched.contains(parent = this.path.getParent())) {
                            parent.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                            watched.add(parent);
                        }
                        return follow;
                    }
                    if (follow && this.path != null) {
                        while (true) {
                            long newSize;
                            if (this.size != (newSize = Files.size(this.path))) {
                                int nb;
                                char[] buf = new char[1024];
                                while ((nb = this.reader.read(buf)) > 0) {
                                    this.print(new String(buf, 0, nb));
                                }
                                this.size = newSize;
                            }
                            if (!opt.isSet("FOLLOW")) break;
                            long newIno = 0L;
                            try {
                                newIno = (Long)Files.getAttribute(this.path, "unix:ino", new LinkOption[0]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (this.ino == newIno) break;
                            this.close();
                            this.open();
                            this.ino = newIno;
                            this.size = -1L;
                        }
                        return true;
                    }
                    return false;
                }
                Path parent = this.path.getParent();
                if (!watched.contains(parent)) {
                    parent.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                    watched.add(parent);
                }
                return true;
            }

            private void print(String toPrint) {
                if (lastPrinted.get() != this && opt.args().size() > 1 && !opt.isSet("quiet")) {
                    process.out().println();
                    process.out().println("==> " + this.name + " <==");
                }
                process.out().print(toPrint);
                lastPrinted.set(this);
            }
        }
        ArrayList<Input> inputs = new ArrayList<Input>();
        for (Object name : opt.args()) {
            Input input = new Input((String)name);
            inputs.add(input);
        }
        try {
            boolean cont = true;
            while (cont) {
                cont = false;
                for (Input input : inputs) {
                    cont |= input.tail();
                }
                if (!cont) continue;
                WatchKey key = watchService.take();
                key.pollEvents();
                key.reset();
            }
        }
        catch (InterruptedException interruptedException) {
            for (Input input : inputs) {
                input.close();
            }
        }
        finally {
            for (Input input : inputs) {
                input.close();
            }
        }
    }

    protected void clear(CommandSession session, Process process, String[] argv) throws Exception {
        String[] usage = new String[]{"clear -  clear screen", "Usage: clear [OPTIONS]", "  -? --help                    Show help"};
        Options opt = this.parseOptions(session, usage, argv);
        if (process.isTty(1)) {
            Shell.getTerminal(session).puts(InfoCmp.Capability.clear_screen, new Object[0]);
            Shell.getTerminal(session).flush();
        }
    }

    protected void tmux(CommandSession session, Process process, String[] argv) throws Exception {
        Commands.tmux((Terminal)Shell.getTerminal(session), (PrintStream)process.out(), (PrintStream)System.err, () -> session.get(".tmux"), t -> session.put(".tmux", t), c -> this.startShell(session, (Terminal)c), (String[])Arrays.copyOfRange(argv, 1, argv.length));
    }

    private void startShell(CommandSession session, Terminal terminal) {
        new Thread(() -> this.runShell(session, terminal), terminal.getName() + " shell").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runShell(CommandSession session, final Terminal terminal) {
        InputStream in = terminal.input();
        OutputStream out = terminal.output();
        CommandSession newSession = this.processor.createSession(in, out, out);
        newSession.put(".terminal", terminal);
        newSession.put(".tmux", session.get(".tmux"));
        Shell.Context context = new Shell.Context(){

            @Override
            public String getProperty(String name) {
                return System.getProperty(name);
            }

            @Override
            public void exit() throws Exception {
                terminal.close();
            }
        };
        try {
            new Shell(context, this.processor).gosh(newSession, new String[]{"--login"});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                terminal.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void ttop(CommandSession session, Process process, String[] argv) throws Exception {
        TTop.ttop((Terminal)Shell.getTerminal(session), (PrintStream)process.out(), (PrintStream)process.err(), (String[])argv);
    }

    protected void nano(CommandSession session, Process process, String[] argv) throws Exception {
        String[] usage = new String[]{"nano -  edit files", "Usage: nano [FILES]", "  -? --help                    Show help"};
        Options opt = this.parseOptions(session, usage, argv);
        Nano edit = new Nano(Shell.getTerminal(session), session.currentDir());
        edit.open(opt.args());
        edit.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void watch(CommandSession session, Process process, String[] argv) throws Exception {
        String[] usage = new String[]{"watch - watches & refreshes the output of a command", "Usage: watch [OPTIONS] COMMAND", "  -? --help                    Show help", "  -n --interval                Interval between executions of the command in seconds", "  -a --append                  The output should be appended but not clear the console"};
        Options opt = this.parseOptions(session, usage, argv);
        List args = opt.args();
        if (args.isEmpty()) {
            throw new IllegalArgumentException("usage: watch COMMAND");
        }
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        Terminal terminal = Shell.getTerminal(session);
        CommandProcessor processor = Shell.getProcessor(session);
        try {
            int interval = 1;
            if (opt.isSet("interval") && (interval = opt.getNumber("interval")) < 1) {
                interval = 1;
            }
            String cmd = String.join((CharSequence)" ", args);
            Runnable task = () -> {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream os = new PrintStream(baos);
                ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
                if (opt.isSet("append") || !terminal.puts(InfoCmp.Capability.clear_screen, new Object[0])) {
                    terminal.writer().println();
                }
                try {
                    CommandSession ns = processor.createSession(is, os, os);
                    Set<String> vars = Shell.getCommands(session);
                    for (String n : vars) {
                        ns.put(n, session.get(n));
                    }
                    ns.execute(cmd);
                }
                catch (Throwable t) {
                    t.printStackTrace(os);
                }
                os.flush();
                terminal.writer().print(baos.toString());
                terminal.writer().flush();
            };
            executorService.scheduleAtFixedRate(task, 0L, interval, TimeUnit.SECONDS);
            Attributes attr = terminal.enterRawMode();
            terminal.reader().read();
            terminal.setAttributes(attr);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    protected void less(CommandSession session, Process process, String[] argv) throws Exception {
        String[] usage = new String[]{"less -  file pager", "Usage: less [OPTIONS] [FILES]", "  -? --help                    Show help", "  -e --quit-at-eof             Exit on second EOF", "  -E --QUIT-AT-EOF             Exit on EOF", "  -F --quit-if-one-screen      Exit if entire file fits on first screen", "  -q --quiet --silent          Silent mode", "  -Q --QUIET --SILENT          Completely  silent", "  -S --chop-long-lines         Do not fold long lines", "  -i --ignore-case             Search ignores lowercase case", "  -I --IGNORE-CASE             Search ignores all case", "  -x --tabs                    Set tab stops", "  -N --LINE-NUMBERS            Display line number for each line", "     --no-init                 Disable terminal initialization", "     --no-keypad               Disable keypad handling"};
        boolean hasExtendedOptions = false;
        try {
            Less.class.getField("quitIfOneScreen");
            hasExtendedOptions = true;
        }
        catch (NoSuchFieldException e) {
            ArrayList<String> ustrs = new ArrayList<String>(Arrays.asList(usage));
            ustrs.removeIf(s -> s.contains("--quit-if-one-screen") || s.contains("--no-init") || s.contains("--no-keypad"));
            usage = ustrs.toArray(new String[ustrs.size()]);
        }
        Options opt = this.parseOptions(session, usage, argv);
        ArrayList<StdInSource> sources = new ArrayList<StdInSource>();
        if (opt.args().isEmpty()) {
            opt.args().add("-");
        }
        for (String string : opt.args()) {
            if ("-".equals(string)) {
                sources.add(new StdInSource(process));
                continue;
            }
            sources.add((StdInSource)new Source.PathSource(session.currentDir().resolve(string), string));
        }
        if (!process.isTty(1)) {
            for (Source source : sources) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(source.read()));
                Throwable throwable = null;
                try {
                    Posix.cat(process, reader, opt.isSet("LINE-NUMBERS"));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            return;
        }
        Less less = new Less(Shell.getTerminal(session));
        less.quitAtFirstEof = opt.isSet("QUIT-AT-EOF");
        less.quitAtSecondEof = opt.isSet("quit-at-eof");
        less.quiet = opt.isSet("quiet");
        less.veryQuiet = opt.isSet("QUIET");
        less.chopLongLines = opt.isSet("chop-long-lines");
        less.ignoreCaseAlways = opt.isSet("IGNORE-CASE");
        less.ignoreCaseCond = opt.isSet("ignore-case");
        if (opt.isSet("tabs")) {
            less.tabs = opt.getNumber("tabs");
        }
        less.printLineNumbers = opt.isSet("LINE-NUMBERS");
        if (hasExtendedOptions) {
            Less.class.getField("quitIfOneScreen").set(less, opt.isSet("quit-if-one-screen"));
            Less.class.getField("noInit").set(less, opt.isSet("no-init"));
            Less.class.getField("noKeypad").set(less, opt.isSet("no-keypad"));
        }
        less.run(sources);
    }

    protected void sort(CommandSession session, Process process, String[] argv) throws Exception {
        String[] usage = new String[]{"sort -  writes sorted standard input to standard output.", "Usage: sort [OPTIONS] [FILES]", "  -? --help                    show help", "  -f --ignore-case             fold lower case to upper case characters", "  -r --reverse                 reverse the result of comparisons", "  -u --unique                  output only the first of an equal run", "  -t --field-separator=SEP     use SEP instead of non-blank to blank transition", "  -b --ignore-leading-blanks   ignore leading blancks", "     --numeric-sort            compare according to string numerical value", "  -k --key=KEY                 fields to use for sorting separated by whitespaces"};
        Options opt = this.parseOptions(session, usage, argv);
        List args = opt.args();
        ArrayList<String> lines = new ArrayList<String>();
        if (!args.isEmpty()) {
            for (String filename : args) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(session.currentDir().toUri().resolve(filename).toURL().openStream()));
                Throwable throwable = null;
                try {
                    Posix.read(reader, lines);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        } else {
            BufferedReader r = new BufferedReader(new InputStreamReader(process.in()));
            Posix.read(r, lines);
        }
        String separator = opt.get("field-separator");
        boolean caseInsensitive = opt.isSet("ignore-case");
        boolean reverse = opt.isSet("reverse");
        boolean ignoreBlanks = opt.isSet("ignore-leading-blanks");
        boolean numeric = opt.isSet("numeric-sort");
        boolean unique = opt.isSet("unique");
        List sortFields = opt.getList("key");
        char sep = separator == null || separator.length() == 0 ? (char)'\u0000' : separator.charAt(0);
        lines.sort(new SortComparator(caseInsensitive, reverse, ignoreBlanks, numeric, sep, sortFields));
        String last = null;
        for (String s : lines) {
            if (!unique || last == null || !s.equals(last)) {
                process.out().println(s);
            }
            last = s;
        }
    }

    protected void pwd(CommandSession session, Process process, String[] argv) throws Exception {
        String[] usage = new String[]{"pwd - get current directory", "Usage: pwd [OPTIONS]", "  -? --help                show help"};
        Options opt = this.parseOptions(session, usage, argv);
        if (!opt.args().isEmpty()) {
            throw new IllegalArgumentException("usage: pwd");
        }
        process.out().println(session.currentDir());
    }

    protected void cd(CommandSession session, Process process, String[] argv) throws Exception {
        String[] usage = new String[]{"cd - get current directory", "Usage: cd [OPTIONS] DIRECTORY", "  -? --help                show help"};
        Options opt = this.parseOptions(session, usage, argv);
        if (opt.args().size() != 1) {
            throw new IllegalArgumentException("usage: cd DIRECTORY");
        }
        Path cwd = session.currentDir();
        if (!Files.exists(cwd = cwd.resolve((String)opt.args().get(0)).toAbsolutePath(), new LinkOption[0])) {
            throw new IOException("no such file or directory: " + (String)opt.args().get(0));
        }
        if (!Files.isDirectory(cwd, new LinkOption[0])) {
            throw new IOException("not a directory: " + (String)opt.args().get(0));
        }
        session.currentDir(cwd);
    }

    protected void ls(CommandSession session, Process process, String[] argv) throws Exception {
        class PathEntry
        implements Comparable<PathEntry> {
            final Path abs;
            final Path path;
            final Map<String, Object> attributes;

            public PathEntry(Path abs, Path root) {
                this.abs = abs;
                this.path = abs.startsWith(root) ? root.relativize(abs) : abs;
                this.attributes = this.readAttributes(abs);
            }

            @Override
            public int compareTo(PathEntry o) {
                int c = this.doCompare(o);
                return opt.isSet("r") ? -c : c;
            }

            private int doCompare(PathEntry o) {
                if (opt.isSet("f")) {
                    return -1;
                }
                if (opt.isSet("S")) {
                    long s1;
                    long s0 = this.attributes.get("size") != null ? ((Number)this.attributes.get("size")).longValue() : 0L;
                    long l = s1 = o.attributes.get("size") != null ? ((Number)o.attributes.get("size")).longValue() : 0L;
                    return s0 > s1 ? -1 : (s0 < s1 ? 1 : this.path.toString().compareTo(o.path.toString()));
                }
                if (opt.isSet("t")) {
                    long t1;
                    long t0 = this.attributes.get("lastModifiedTime") != null ? ((FileTime)this.attributes.get("lastModifiedTime")).toMillis() : 0L;
                    long l = t1 = o.attributes.get("lastModifiedTime") != null ? ((FileTime)o.attributes.get("lastModifiedTime")).toMillis() : 0L;
                    return t0 > t1 ? -1 : (t0 < t1 ? 1 : this.path.toString().compareTo(o.path.toString()));
                }
                return this.path.toString().compareTo(o.path.toString());
            }

            boolean isNotDirectory() {
                return this.is("isRegularFile") || this.is("isSymbolicLink") || this.is("isOther");
            }

            boolean isDirectory() {
                return this.is("isDirectory");
            }

            private boolean is(String attr) {
                Object d = this.attributes.get(attr);
                return d instanceof Boolean && (Boolean)d != false;
            }

            String display() {
                String suffix;
                String type;
                String link = "";
                if (this.is("isSymbolicLink")) {
                    type = "sl";
                    suffix = "@";
                    try {
                        Path l = Files.readSymbolicLink(this.abs);
                        link = " -> " + l.toString();
                    }
                    catch (IOException l) {}
                } else if (this.is("isDirectory")) {
                    type = "dr";
                    suffix = "/";
                } else if (this.is("isExecutable")) {
                    type = "ex";
                    suffix = "*";
                } else if (this.is("isOther")) {
                    type = "ot";
                    suffix = "";
                } else {
                    type = "";
                    suffix = "";
                }
                boolean addSuffix = opt.isSet("F");
                return Posix.applyStyle(this.path.toString(), (Map<String, String>)colors, type) + (addSuffix ? suffix : "") + link;
            }

            String longDisplay() {
                String lengthString;
                String username = this.attributes.containsKey("owner") ? Objects.toString(this.attributes.get("owner"), null) : "owner";
                if (username.length() > 8) {
                    username = username.substring(0, 8);
                } else {
                    for (int i = username.length(); i < 8; ++i) {
                        username = username + " ";
                    }
                }
                String group = this.attributes.containsKey("group") ? Objects.toString(this.attributes.get("group"), null) : "group";
                if (group.length() > 8) {
                    group = group.substring(0, 8);
                } else {
                    for (int i = group.length(); i < 8; ++i) {
                        group = group + " ";
                    }
                }
                Number length = (Number)this.attributes.get("size");
                if (length == null) {
                    length = 0L;
                }
                if (opt.isSet("h")) {
                    double l = length.longValue();
                    String unit = "B";
                    if (l >= 1000.0) {
                        l /= 1024.0;
                        unit = "K";
                        if (l >= 1000.0) {
                            l /= 1024.0;
                            unit = "M";
                            if (l >= 1000.0) {
                                l /= 1024.0;
                                unit = "T";
                            }
                        }
                    }
                    lengthString = l < 10.0 && length.longValue() > 1000L ? String.format("%.1f", l) + unit : String.format("%3.0f", l) + unit;
                } else {
                    lengthString = String.format("%1$8s", length);
                }
                EnumSet<PosixFilePermission> perms = (EnumSet<PosixFilePermission>)this.attributes.get("permissions");
                if (perms == null) {
                    perms = EnumSet.noneOf(PosixFilePermission.class);
                }
                return (this.is("isDirectory") ? "d" : (this.is("isSymbolicLink") ? "l" : (this.is("isOther") ? "o" : "-"))) + PosixFilePermissions.toString(perms) + " " + String.format("%3s", this.attributes.containsKey("nlink") ? this.attributes.get("nlink").toString() : "1") + " " + username + " " + group + " " + lengthString + " " + this.toString((FileTime)this.attributes.get("lastModifiedTime")) + " " + this.display();
            }

            protected String toString(FileTime time) {
                long millis;
                long l = millis = time != null ? time.toMillis() : -1L;
                if (millis < 0L) {
                    return "------------";
                }
                ZonedDateTime dt = Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault());
                if (System.currentTimeMillis() - millis < 15811200000L) {
                    return DateTimeFormatter.ofPattern("MMM ppd HH:mm").format(dt);
                }
                return DateTimeFormatter.ofPattern("MMM ppd  yyyy").format(dt);
            }

            protected Map<String, Object> readAttributes(Path path) {
                TreeMap<String, Object> attrs = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
                for (String view : path.getFileSystem().supportedFileAttributeViews()) {
                    try {
                        Map<String, Object> ta = Files.readAttributes(path, view + ":*", Posix.getLinkOptions(opt.isSet("L")));
                        ta.forEach(attrs::putIfAbsent);
                    }
                    catch (IOException iOException) {}
                }
                attrs.computeIfAbsent("isExecutable", s -> Files.isExecutable(path));
                attrs.computeIfAbsent("permissions", s -> Posix.getPermissionsFromFile(path.toFile()));
                return attrs;
            }
        }
        boolean colored;
        String color;
        String[] usage = new String[]{"ls - list files", "Usage: ls [OPTIONS] [PATTERNS...]", "  -? --help                show help", "  -1                       list one entry per line", "  -C                       multi-column output", "     --color=WHEN          colorize the output, may be `always', `never' or `auto'", "  -a                       list entries starting with .", "  -F                       append file type indicators", "  -m                       comma separated", "  -l                       long listing", "  -S                       sort by size", "  -f                       output is not sorted", "  -r                       reverse sort order", "  -t                       sort by modification time", "  -x                       sort horizontally", "  -L                       list referenced file for links", "  -h                       print sizes in human readable form"};
        final Options opt = this.parseOptions(session, usage, argv);
        switch (color = opt.isSet("color") ? opt.get("color") : "auto") {
            case "always": 
            case "yes": 
            case "force": {
                colored = true;
                break;
            }
            case "never": 
            case "no": 
            case "none": {
                colored = false;
                break;
            }
            case "auto": 
            case "tty": 
            case "if-tty": {
                colored = process.isTty(1);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid argument \u2018" + color + "\u2019 for \u2018--color\u2019");
            }
        }
        final Map<Object, Object> colors = colored ? Posix.getLsColorMap(session) : Collections.emptyMap();
        Path currentDir = session.currentDir();
        ArrayList<Path> expanded = new ArrayList<Path>();
        if (opt.args().isEmpty()) {
            expanded.add(currentDir);
        } else {
            opt.args().forEach(s -> expanded.add(currentDir.resolve((String)s)));
        }
        boolean listAll = opt.isSet("a");
        Predicate<Path> filter = p -> listAll || !p.getFileName().toString().startsWith(".");
        List all = expanded.stream().filter(filter).map(p -> new PathEntry((Path)p, currentDir)).sorted().collect(Collectors.toList());
        List files = all.stream().filter(PathEntry::isNotDirectory).collect(Collectors.toList());
        PrintStream out = process.out();
        Consumer<Stream> display = s -> {
            boolean optLine = opt.isSet("1");
            boolean optComma = opt.isSet("m");
            boolean optLong = opt.isSet("l");
            boolean optCol = opt.isSet("C");
            if (!(optLine || optComma || optLong || optCol)) {
                if (process.isTty(1)) {
                    optCol = true;
                } else {
                    optLine = true;
                }
            }
            if (optLine) {
                s.map(PathEntry::display).forEach(out::println);
            } else if (optComma) {
                out.println(s.map(PathEntry::display).collect(Collectors.joining(", ")));
            } else if (optLong) {
                s.map(PathEntry::longDisplay).forEach(out::println);
            } else if (optCol) {
                this.toColumn(session, process, out, s.map(PathEntry::display), opt.isSet("x"));
            }
        };
        boolean space = false;
        if (!files.isEmpty()) {
            display.accept(files.stream());
            space = true;
        }
        List directories = all.stream().filter(PathEntry::isDirectory).collect(Collectors.toList());
        for (PathEntry entry : directories) {
            if (space) {
                out.println();
            }
            space = true;
            Path path = currentDir.resolve(entry.path);
            if (expanded.size() > 1) {
                out.println(currentDir.relativize(path).toString() + ":");
            }
            display.accept(Stream.concat(Stream.of(".", "..").map(path::resolve), Files.list(path)).filter(filter).map(p -> new PathEntry((Path)p, path)).sorted());
        }
    }

    private void toColumn(CommandSession session, Process process, PrintStream out, Stream<String> ansi, boolean horizontal) {
        Terminal terminal = Shell.getTerminal(session);
        int width = process.isTty(1) ? terminal.getWidth() : 80;
        List strings = ansi.map(AttributedString::fromAnsi).collect(Collectors.toList());
        if (!strings.isEmpty()) {
            int c;
            int max = strings.stream().mapToInt(AttributedCharSequence::columnLength).max().getAsInt();
            for (c = Math.max(1, width / max); c > 1 && c * max + (c - 1) >= width; --c) {
            }
            int columns = c;
            int lines = (strings.size() + columns - 1) / columns;
            IntBinaryOperator index = horizontal ? (i, j) -> i * columns + j : (i, j) -> j * lines + i;
            AttributedStringBuilder sb = new AttributedStringBuilder();
            for (int i2 = 0; i2 < lines; ++i2) {
                for (int j2 = 0; j2 < columns; ++j2) {
                    int idx = index.applyAsInt(i2, j2);
                    if (idx >= strings.size()) continue;
                    AttributedString str = (AttributedString)strings.get(idx);
                    boolean hasRightItem = j2 < columns - 1 && index.applyAsInt(i2, j2 + 1) < strings.size();
                    sb.append(str);
                    if (!hasRightItem) continue;
                    for (int k = 0; k <= max - str.length(); ++k) {
                        sb.append(' ');
                    }
                }
                sb.append('\n');
            }
            out.print(sb.toAnsi(terminal));
        }
    }

    protected void cat(CommandSession session, Process process, String[] argv) throws Exception {
        String[] usage = new String[]{"cat - concatenate and print FILES", "Usage: cat [OPTIONS] [FILES]", "  -? --help                show help", "  -n                       number the output lines, starting at 1"};
        Options opt = this.parseOptions(session, usage, argv);
        List<String> args = opt.args();
        if (args.isEmpty()) {
            args = Collections.singletonList("-");
        }
        Path cwd = session.currentDir();
        for (String arg : args) {
            InputStream is = "-".equals(arg) ? process.in() : cwd.toUri().resolve(arg).toURL().openStream();
            Posix.cat(process, new BufferedReader(new InputStreamReader(is)), opt.isSet("n"));
        }
    }

    protected void echo(CommandSession session, Process process, Object[] argv) throws Exception {
        String[] usage = new String[]{"echo - echoes or prints ARGUMENT to standard output", "Usage: echo [OPTIONS] [ARGUMENTS]", "  -? --help                show help", "  -n                       no trailing new line"};
        Options opt = this.parseOptions(session, usage, argv);
        List args = opt.args();
        StringBuilder buf = new StringBuilder();
        if (args != null) {
            for (String arg : args) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                for (int i = 0; i < arg.length(); ++i) {
                    int c = arg.charAt(i);
                    if (c == 92) {
                        c = i < arg.length() - 1 ? (int)arg.charAt(++i) : 92;
                        switch (c) {
                            case 97: {
                                buf.append('\u0007');
                                break;
                            }
                            case 110: {
                                buf.append('\n');
                                break;
                            }
                            case 116: {
                                buf.append('\t');
                                break;
                            }
                            case 114: {
                                buf.append('\r');
                                break;
                            }
                            case 92: {
                                buf.append('\\');
                                break;
                            }
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                int j;
                                int ch = 0;
                                for (j = 0; j < 3; ++j) {
                                    int n = c = i < arg.length() - 1 ? (int)arg.charAt(++i) : -1;
                                    if (c < 0) continue;
                                    ch = ch * 8 + (c - 48);
                                }
                                buf.append((char)ch);
                                break;
                            }
                            case 117: {
                                int j;
                                int ch = 0;
                                for (j = 0; j < 4; ++j) {
                                    int n = c = i < arg.length() - 1 ? (int)arg.charAt(++i) : -1;
                                    if (c < 0) continue;
                                    if (c >= 65 && c <= 90) {
                                        ch = ch * 16 + (c - 65 + 10);
                                        continue;
                                    }
                                    if (c >= 97 && c <= 122) {
                                        ch = ch * 16 + (c - 97 + 10);
                                        continue;
                                    }
                                    if (c < 48 || c > 57) break;
                                    ch = ch * 16 + (c - 48);
                                }
                                buf.append((char)ch);
                                break;
                            }
                            default: {
                                buf.append((char)c);
                                break;
                            }
                        }
                        continue;
                    }
                    buf.append((char)c);
                }
            }
        }
        if (opt.isSet("n")) {
            process.out().print(buf);
        } else {
            process.out().println(buf);
        }
    }

    protected void grep(CommandSession session, Process process, String[] argv) throws Exception {
        boolean colored;
        String color;
        String lineFmt;
        Pattern p2;
        Pattern p;
        String regex;
        String[] usage = new String[]{"grep -  search for PATTERN in each FILE or standard input.", "Usage: grep [OPTIONS] PATTERN [FILES]", "  -? --help                Show help", "  -i --ignore-case         Ignore case distinctions", "  -n --line-number         Prefix each line with line number within its input file", "  -q --quiet, --silent     Suppress all normal output", "  -v --invert-match        Select non-matching lines", "  -w --word-regexp         Select only whole words", "  -x --line-regexp         Select only whole lines", "  -c --count               Only print a count of matching lines per file", "     --color=WHEN          Use markers to distinguish the matching string, may be `always', `never' or `auto'", "  -B --before-context=NUM  Print NUM lines of leading context before matching lines", "  -A --after-context=NUM   Print NUM lines of trailing context after matching lines", "  -C --context=NUM         Print NUM lines of output context", "     --pad-lines           Pad line numbers"};
        Options opt = this.parseOptions(session, usage, argv);
        List args = opt.args();
        if (args.isEmpty()) {
            throw new IllegalArgumentException("no pattern supplied");
        }
        String regexp = regex = (String)args.remove(0);
        if (opt.isSet("word-regexp")) {
            regexp = "\\b" + regexp + "\\b";
        }
        regexp = opt.isSet("line-regexp") ? "^" + regexp + "$" : ".*" + regexp + ".*";
        if (opt.isSet("ignore-case")) {
            p = Pattern.compile(regexp, 2);
            p2 = Pattern.compile(regex, 2);
        } else {
            p = Pattern.compile(regexp);
            p2 = Pattern.compile(regex);
        }
        int after = opt.isSet("after-context") ? opt.getNumber("after-context") : -1;
        int before = opt.isSet("before-context") ? opt.getNumber("before-context") : -1;
        int context = opt.isSet("context") ? opt.getNumber("context") : 0;
        String string = lineFmt = opt.isSet("pad-lines") ? "%6d" : "%d";
        if (after < 0) {
            after = context;
        }
        if (before < 0) {
            before = context;
        }
        ArrayList<String> lines = new ArrayList<String>();
        boolean invertMatch = opt.isSet("invert-match");
        boolean lineNumber = opt.isSet("line-number");
        boolean count = opt.isSet("count");
        switch (color = opt.isSet("color") ? opt.get("color") : "auto") {
            case "always": 
            case "yes": 
            case "force": {
                colored = true;
                break;
            }
            case "never": 
            case "no": 
            case "none": {
                colored = false;
                break;
            }
            case "auto": 
            case "tty": 
            case "if-tty": {
                colored = process.isTty(1);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid argument \u2018" + color + "\u2019 for \u2018--color\u2019");
            }
        }
        Map<String, String> colors = colored ? Posix.getColorMap(session, "GREP", DEFAULT_GREP_COLORS) : Collections.emptyMap();
        ArrayList<StdInSource> sources = new ArrayList<StdInSource>();
        if (opt.args().isEmpty()) {
            opt.args().add("-");
        }
        for (String arg : opt.args()) {
            if ("-".equals(arg)) {
                sources.add(new StdInSource(process));
                continue;
            }
            sources.add((StdInSource)new Source.PathSource(session.currentDir().resolve(arg), arg));
        }
        boolean match = false;
        for (Source source : sources) {
            boolean firstPrint = true;
            int nb = 0;
            int lineno = 1;
            int lineMatch = 0;
            BufferedReader r = new BufferedReader(new InputStreamReader(source.read()));
            Throwable throwable = null;
            try {
                String line;
                while ((line = r.readLine()) != null && (line.length() != 1 || line.charAt(0) != '\n')) {
                    boolean matches = p.matcher(line).matches();
                    AttributedStringBuilder sbl = new AttributedStringBuilder();
                    if (!count) {
                        String style;
                        if (sources.size() > 1) {
                            if (colored) {
                                Posix.applyStyle(sbl, colors, "fn");
                            }
                            sbl.append((CharSequence)source.getName());
                            if (colored) {
                                Posix.applyStyle(sbl, colors, "se");
                            }
                            sbl.append((CharSequence)":");
                        }
                        if (lineNumber) {
                            if (colored) {
                                Posix.applyStyle(sbl, colors, "ln");
                            }
                            sbl.append((CharSequence)String.format(lineFmt, lineno));
                            if (colored) {
                                Posix.applyStyle(sbl, colors, "se");
                            }
                            sbl.append((CharSequence)(matches ^ invertMatch ? ":" : "-"));
                        }
                        String string2 = style = matches ^ invertMatch ^ (invertMatch && colors.containsKey("rv")) ? "sl" : "cx";
                        if (colored) {
                            Posix.applyStyle(sbl, colors, style);
                        }
                        AttributedString aLine = AttributedString.fromAnsi((String)line);
                        Matcher matcher2 = p2.matcher(aLine.toString());
                        int cur = 0;
                        while (matcher2.find()) {
                            int index = matcher2.start(0);
                            AttributedString prefix = aLine.subSequence(cur, index);
                            sbl.append(prefix);
                            cur = matcher2.end();
                            if (colored) {
                                Posix.applyStyle(sbl, colors, invertMatch ? "mc" : "ms", "mt");
                            }
                            sbl.append(aLine.subSequence(index, cur));
                            if (colored) {
                                Posix.applyStyle(sbl, colors, style);
                            }
                            ++nb;
                        }
                        sbl.append(aLine.subSequence(cur, aLine.length()));
                    }
                    if (matches ^ invertMatch) {
                        lines.add(sbl.toAnsi(Shell.getTerminal(session)));
                        lineMatch = lines.size();
                    } else {
                        if (lineMatch != 0 & lineMatch + after + before <= lines.size()) {
                            if (!count) {
                                if (!firstPrint && before + after > 0) {
                                    AttributedStringBuilder sbl2 = new AttributedStringBuilder();
                                    if (colored) {
                                        Posix.applyStyle(sbl2, colors, "se");
                                    }
                                    sbl2.append((CharSequence)"--");
                                    process.out().println(sbl2.toAnsi(Shell.getTerminal(session)));
                                } else {
                                    firstPrint = false;
                                }
                                for (int i = 0; i < lineMatch + after; ++i) {
                                    process.out().println((String)lines.get(i));
                                }
                            }
                            while (lines.size() > before) {
                                lines.remove(0);
                            }
                            lineMatch = 0;
                        }
                        lines.add(sbl.toAnsi(Shell.getTerminal(session)));
                        while (lineMatch == 0 && lines.size() > before) {
                            lines.remove(0);
                        }
                    }
                    ++lineno;
                }
                if (!count && lineMatch > 0) {
                    if (!firstPrint && before + after > 0) {
                        AttributedStringBuilder sbl2 = new AttributedStringBuilder();
                        if (colored) {
                            Posix.applyStyle(sbl2, colors, "se");
                        }
                        sbl2.append((CharSequence)"--");
                        process.out().println(sbl2.toAnsi(Shell.getTerminal(session)));
                    } else {
                        firstPrint = false;
                    }
                    for (int i = 0; i < lineMatch + after && i < lines.size(); ++i) {
                        process.out().println((String)lines.get(i));
                    }
                }
                if (count) {
                    process.out().println(nb);
                }
                match |= nb > 0;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (r == null) continue;
                if (throwable != null) {
                    try {
                        r.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                r.close();
            }
        }
        Process.Utils.current().error(match ? 0 : 1);
    }

    protected void sleep(CommandSession session, Process process, String[] argv) throws Exception {
        String[] usage = new String[]{"sleep -  suspend execution for an interval of time", "Usage: sleep seconds", "  -? --help                    show help"};
        Options opt = this.parseOptions(session, usage, argv);
        List args = opt.args();
        if (args.size() != 1) {
            throw new IllegalArgumentException("usage: sleep seconds");
        }
        int s = Integer.parseInt((String)args.get(0));
        Thread.sleep(s * 1000);
    }

    protected static void read(BufferedReader r, List<String> lines) throws IOException {
        String s = r.readLine();
        while (s != null) {
            lines.add(s);
            s = r.readLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cat(Process process, BufferedReader reader, boolean displayLineNumbers) throws IOException {
        int lineno = 1;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (displayLineNumbers) {
                    process.out().print(String.format("%6d  ", lineno++));
                }
                process.out().println(line);
            }
        }
        finally {
            reader.close();
        }
    }

    private static LinkOption[] getLinkOptions(boolean followLinks) {
        if (followLinks) {
            return EMPTY_LINK_OPTIONS;
        }
        return (LinkOption[])NO_FOLLOW_OPTIONS.clone();
    }

    private static boolean isWindowsExecutable(String fileName) {
        if (fileName == null || fileName.length() <= 0) {
            return false;
        }
        for (String suffix : WINDOWS_EXECUTABLE_EXTENSIONS) {
            if (!fileName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private static Set<PosixFilePermission> getPermissionsFromFile(File f) {
        EnumSet<PosixFilePermission> perms = EnumSet.noneOf(PosixFilePermission.class);
        if (f.canRead()) {
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.GROUP_READ);
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if (f.canWrite()) {
            perms.add(PosixFilePermission.OWNER_WRITE);
            perms.add(PosixFilePermission.GROUP_WRITE);
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if (f.canExecute() || OSUtils.IS_WINDOWS && Posix.isWindowsExecutable(f.getName())) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
            perms.add(PosixFilePermission.GROUP_EXECUTE);
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return perms;
    }

    public static Map<String, String> getLsColorMap(CommandSession session) {
        return Posix.getColorMap(session, "LS", DEFAULT_LS_COLORS);
    }

    public static Map<String, String> getColorMap(CommandSession session, String name, String def) {
        String str;
        Object obj = session.get(name + "_COLORS");
        String string = str = obj != null ? obj.toString() : null;
        if (str == null) {
            str = def;
        }
        String sep = str.matches("[a-z]{2}=[0-9]*(;[0-9]+)*(:[a-z]{2}=[0-9]*(;[0-9]+)*)*") ? ":" : " ";
        return Arrays.stream(str.split(sep)).collect(Collectors.toMap(s -> s.substring(0, s.indexOf(61)), s -> s.substring(s.indexOf(61) + 1)));
    }

    static String applyStyle(String text, Map<String, String> colors, String ... types) {
        String t = null;
        for (String type : types) {
            if (colors.get(type) == null) continue;
            t = type;
            break;
        }
        return new AttributedString((CharSequence)text, new StyleResolver(colors::get).resolve("." + t)).toAnsi();
    }

    static void applyStyle(AttributedStringBuilder sb, Map<String, String> colors, String ... types) {
        String t = null;
        for (String type : types) {
            if (colors.get(type) == null) continue;
            t = type;
            break;
        }
        sb.style(new StyleResolver(colors::get).resolve("." + t));
    }

    static {
        String[] func;
        try {
            Class<TTop> cl = TTop.class;
            func = new String[]{"cat", "echo", "grep", "sort", "sleep", "cd", "pwd", "ls", "less", "watch", "nano", "tmux", "head", "tail", "clear", "wc", "date", "ttop"};
        }
        catch (Throwable t) {
            func = new String[]{"cat", "echo", "grep", "sort", "sleep", "cd", "pwd", "ls", "less", "watch", "nano", "tmux", "head", "tail", "clear", "wc", "date"};
        }
        functions = func;
        NO_FOLLOW_OPTIONS = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
        WINDOWS_EXECUTABLE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(".bat", ".exe", ".cmd"));
        EMPTY_LINK_OPTIONS = new LinkOption[0];
    }

    private static class StdInSource
    implements Source {
        private final Process process;

        StdInSource(Process process) {
            this.process = process;
        }

        public String getName() {
            return null;
        }

        public InputStream read() {
            return this.process.in();
        }
    }

    public static class SortComparator
    implements Comparator<String> {
        private static Pattern fpPattern;
        private boolean caseInsensitive;
        private boolean reverse;
        private boolean ignoreBlanks;
        private boolean numeric;
        private char separator;
        private List<Key> sortKeys;

        public SortComparator(boolean caseInsensitive, boolean reverse, boolean ignoreBlanks, boolean numeric, char separator, List<String> sortFields) {
            this.caseInsensitive = caseInsensitive;
            this.reverse = reverse;
            this.separator = separator;
            this.ignoreBlanks = ignoreBlanks;
            this.numeric = numeric;
            if (sortFields == null || sortFields.size() == 0) {
                sortFields = new ArrayList<String>();
                sortFields.add("1");
            }
            this.sortKeys = sortFields.stream().map(x$0 -> new Key((String)x$0)).collect(Collectors.toList());
        }

        @Override
        public int compare(String o1, String o2) {
            int res = 0;
            List<Integer> fi1 = this.getFieldIndexes(o1);
            List<Integer> fi2 = this.getFieldIndexes(o2);
            for (Key key : this.sortKeys) {
                int[] k1 = this.getSortKey(o1, fi1, key);
                int[] k2 = this.getSortKey(o2, fi2, key);
                if (key.numeric) {
                    Double d1 = this.getDouble(o1, k1[0], k1[1]);
                    Double d2 = this.getDouble(o2, k2[0], k2[1]);
                    res = d1.compareTo(d2);
                } else {
                    res = this.compareRegion(o1, k1[0], k1[1], o2, k2[0], k2[1], key.caseInsensitive);
                }
                if (res == 0) continue;
                if (!key.reverse) break;
                res = -res;
                break;
            }
            return res;
        }

        protected Double getDouble(String s, int start, int end) {
            Matcher m = fpPattern.matcher(s.substring(start, end));
            m.find();
            return new Double(s.substring(0, m.end(1)));
        }

        protected int compareRegion(String s1, int start1, int end1, String s2, int start2, int end2, boolean caseInsensitive) {
            int i1 = start1;
            for (int i2 = start2; i1 < end1 && i2 < end2; ++i1, ++i2) {
                char c2;
                char c1 = s1.charAt(i1);
                if (c1 == (c2 = s2.charAt(i2))) continue;
                if (caseInsensitive) {
                    if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
                    return c1 - c2;
                }
                return c1 - c2;
            }
            return end1 - end2;
        }

        protected int[] getSortKey(String str, List<Integer> fields, Key key) {
            int end;
            int start;
            if (key.startField * 2 <= fields.size()) {
                if (key.ignoreBlanksStart) {
                    for (start = fields.get((key.startField - 1) * 2).intValue(); start < fields.get((key.startField - 1) * 2 + 1) && Character.isWhitespace(str.charAt(start)); ++start) {
                    }
                }
                if (key.startChar > 0) {
                    start = Math.min(start + key.startChar - 1, fields.get((key.startField - 1) * 2 + 1));
                }
            } else {
                start = 0;
            }
            if (key.endField > 0 && key.endField * 2 <= fields.size()) {
                if (key.ignoreBlanksEnd) {
                    for (end = fields.get((key.endField - 1) * 2).intValue(); end < fields.get((key.endField - 1) * 2 + 1) && Character.isWhitespace(str.charAt(end)); ++end) {
                    }
                }
                if (key.endChar > 0) {
                    end = Math.min(end + key.endChar - 1, fields.get((key.endField - 1) * 2 + 1));
                }
            } else {
                end = str.length();
            }
            return new int[]{start, end};
        }

        protected List<Integer> getFieldIndexes(String o) {
            ArrayList<Integer> fields = new ArrayList<Integer>();
            if (o.length() > 0) {
                if (this.separator == '\u0000') {
                    fields.add(0);
                    for (int idx = 1; idx < o.length(); ++idx) {
                        if (!Character.isWhitespace(o.charAt(idx)) || Character.isWhitespace(o.charAt(idx - 1))) continue;
                        fields.add(idx - 1);
                        fields.add(idx);
                    }
                    fields.add(o.length() - 1);
                } else {
                    int last = -1;
                    int idx = o.indexOf(this.separator);
                    while (idx >= 0) {
                        if (last >= 0) {
                            fields.add(last);
                            fields.add(idx - 1);
                        } else if (idx > 0) {
                            fields.add(0);
                            fields.add(idx - 1);
                        }
                        last = idx + 1;
                        idx = o.indexOf(this.separator, idx + 1);
                    }
                    if (last < o.length()) {
                        fields.add(last < 0 ? 0 : last);
                        fields.add(o.length() - 1);
                    }
                }
            }
            return fields;
        }

        static {
            String Digits = "(\\p{Digit}+)";
            String HexDigits = "(\\p{XDigit}+)";
            String Exp = "[eE][+-]?(\\p{Digit}+)";
            String fpRegex = "([\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*)(.*)";
            fpPattern = Pattern.compile("([\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*)(.*)");
        }

        public class Key {
            int startField;
            int startChar;
            int endField;
            int endChar;
            boolean ignoreBlanksStart;
            boolean ignoreBlanksEnd;
            boolean caseInsensitive;
            boolean reverse;
            boolean numeric;

            public Key(String str) {
                boolean modifiers = false;
                boolean startPart = true;
                boolean inField = true;
                boolean inChar = false;
                block9: for (char c : str.toCharArray()) {
                    switch (c) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            if (!inField && !inChar) {
                                throw new IllegalArgumentException("Bad field syntax: " + str);
                            }
                            if (startPart) {
                                if (inChar) {
                                    this.startChar = this.startChar * 10 + (c - 48);
                                    continue block9;
                                }
                                this.startField = this.startField * 10 + (c - 48);
                                continue block9;
                            }
                            if (inChar) {
                                this.endChar = this.endChar * 10 + (c - 48);
                                continue block9;
                            }
                            this.endField = this.endField * 10 + (c - 48);
                            continue block9;
                        }
                        case '.': {
                            if (!inField) {
                                throw new IllegalArgumentException("Bad field syntax: " + str);
                            }
                            inField = false;
                            inChar = true;
                            continue block9;
                        }
                        case 'n': {
                            inField = false;
                            inChar = false;
                            modifiers = true;
                            this.numeric = true;
                            continue block9;
                        }
                        case 'f': {
                            inField = false;
                            inChar = false;
                            modifiers = true;
                            this.caseInsensitive = true;
                            continue block9;
                        }
                        case 'r': {
                            inField = false;
                            inChar = false;
                            modifiers = true;
                            this.reverse = true;
                            continue block9;
                        }
                        case 'b': {
                            inField = false;
                            inChar = false;
                            modifiers = true;
                            if (startPart) {
                                this.ignoreBlanksStart = true;
                                continue block9;
                            }
                            this.ignoreBlanksEnd = true;
                            continue block9;
                        }
                        case ',': {
                            inField = true;
                            inChar = false;
                            startPart = false;
                            continue block9;
                        }
                        default: {
                            throw new IllegalArgumentException("Bad field syntax: " + str);
                        }
                    }
                }
                if (!modifiers) {
                    this.ignoreBlanksStart = this.ignoreBlanksEnd = SortComparator.this.ignoreBlanks;
                    this.reverse = SortComparator.this.reverse;
                    this.caseInsensitive = SortComparator.this.caseInsensitive;
                    this.numeric = SortComparator.this.numeric;
                }
                if (this.startField < 1) {
                    throw new IllegalArgumentException("Bad field syntax: " + str);
                }
            }
        }
    }

    protected static class HelpException
    extends Exception {
        public HelpException(String message) {
            super(message);
        }
    }
}

