/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.connection;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.plc4x.java.api.connection.PlcConnection;
import org.apache.plc4x.java.api.connection.PlcReader;
import org.apache.plc4x.java.api.connection.PlcSubscriber;
import org.apache.plc4x.java.api.connection.PlcWriter;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcIoException;
import org.apache.plc4x.java.base.connection.ChannelFactory;

public abstract class AbstractPlcConnection
implements PlcConnection {
    protected final ChannelFactory channelFactory;
    protected final boolean awaitSessionSetupComplete;
    protected Channel channel;
    protected boolean connected;

    protected AbstractPlcConnection(ChannelFactory channelFactory) {
        this(channelFactory, false);
    }

    protected AbstractPlcConnection(ChannelFactory channelFactory, boolean awaitSessionSetupComplete) {
        this.channelFactory = channelFactory;
        this.awaitSessionSetupComplete = awaitSessionSetupComplete;
        this.connected = false;
    }

    public void connect() throws PlcConnectionException {
        try {
            CompletableFuture<Void> sessionSetupCompleteFuture = new CompletableFuture<Void>();
            this.channel = this.channelFactory.createChannel(this.getChannelHandler(sessionSetupCompleteFuture));
            this.channel.closeFuture().addListener(future -> {
                if (!sessionSetupCompleteFuture.isDone()) {
                    sessionSetupCompleteFuture.completeExceptionally((Throwable)new PlcIoException("Connection terminated by remote"));
                }
            });
            this.sendChannelCreatedEvent();
            if (this.awaitSessionSetupComplete) {
                sessionSetupCompleteFuture.get();
            }
            this.connected = true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PlcConnectionException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new PlcConnectionException((Throwable)e);
        }
    }

    public void close() throws PlcConnectionException {
        this.channel = null;
        this.connected = false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public Channel getChannel() {
        return this.channel;
    }

    protected abstract ChannelHandler getChannelHandler(CompletableFuture<Void> var1);

    protected void sendChannelCreatedEvent() {
    }

    public Optional<PlcReader> getReader() {
        if (this instanceof PlcReader) {
            return Optional.of((PlcReader)this);
        }
        return Optional.empty();
    }

    public Optional<PlcWriter> getWriter() {
        if (this instanceof PlcWriter) {
            return Optional.of((PlcWriter)this);
        }
        return Optional.empty();
    }

    public Optional<PlcSubscriber> getSubscriber() {
        if (this instanceof PlcSubscriber) {
            return Optional.of((PlcSubscriber)this);
        }
        return Optional.empty();
    }

    protected <T> T checkInternal(Object o, Class<T> clazz) {
        Objects.requireNonNull(o);
        Objects.requireNonNull(clazz);
        if (!clazz.isInstance(o)) {
            throw new IllegalArgumentException("illegal type " + o.getClass() + ". Expected " + clazz);
        }
        return clazz.cast(o);
    }
}

