/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.base.connection.PlcFieldHandler;
import org.apache.plc4x.java.base.messages.InternalPlcReadRequest;

public class DefaultPlcReadRequest
implements InternalPlcReadRequest {
    private LinkedHashMap<String, PlcField> fields;

    private DefaultPlcReadRequest(LinkedHashMap<String, PlcField> fields) {
        this.fields = fields;
    }

    public int getNumberOfFields() {
        return this.fields.size();
    }

    public LinkedHashSet<String> getFieldNames() {
        return new LinkedHashSet<String>(this.fields.keySet());
    }

    public PlcField getField(String name) {
        return this.fields.get(name);
    }

    public LinkedList<PlcField> getFields() {
        return new LinkedList<PlcField>(this.fields.values());
    }

    public static class Builder
    implements PlcReadRequest.Builder {
        private final PlcFieldHandler fieldHandler;
        private final Map<String, String> fields;

        public Builder(PlcFieldHandler fieldHandler) {
            this.fieldHandler = fieldHandler;
            this.fields = new TreeMap<String, String>();
        }

        public PlcReadRequest.Builder addItem(String name, String fieldQuery) {
            if (this.fields.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate field definition '" + name + "'");
            }
            this.fields.put(name, fieldQuery);
            return this;
        }

        public PlcReadRequest build() {
            LinkedHashMap parsedFields = new LinkedHashMap();
            this.fields.forEach((name, fieldQuery) -> {
                PlcField parsedField = this.fieldHandler.createField((String)fieldQuery);
                parsedFields.put(name, parsedField);
            });
            return new DefaultPlcReadRequest(parsedFields);
        }
    }
}

