/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.base.messages.InternalPlcReadRequest;
import org.apache.plc4x.java.base.messages.InternalPlcReadResponse;
import org.apache.plc4x.java.base.messages.items.FieldItem;

public class DefaultPlcReadResponse
implements InternalPlcReadResponse {
    private final InternalPlcReadRequest request;
    private final Map<String, Pair<PlcResponseCode, FieldItem>> values;

    public DefaultPlcReadResponse(InternalPlcReadRequest request, Map<String, Pair<PlcResponseCode, FieldItem>> fields) {
        this.request = request;
        this.values = fields;
    }

    public InternalPlcReadRequest getRequest() {
        return this.request;
    }

    public int getNumberOfValues(String name) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.getNumberOfValues();
        }
        return 0;
    }

    public Collection<String> getFieldNames() {
        return this.request.getFieldNames();
    }

    public PlcField getField(String name) {
        return this.request.getField(name);
    }

    public PlcResponseCode getResponseCode(String name) {
        if (this.values.get(name) == null) {
            return null;
        }
        return (PlcResponseCode)this.values.get(name).getKey();
    }

    public Object getObject(String name) {
        return this.getObject(name, 0);
    }

    public Object getObject(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.getObject(index);
        }
        return null;
    }

    public Collection<Object> getAllObjects(String name) {
        return null;
    }

    public boolean isValidBoolean(String name) {
        return this.isValidBoolean(name, 0);
    }

    public boolean isValidBoolean(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.isValidBoolean(index);
        }
        return false;
    }

    public Boolean getBoolean(String name) {
        return this.getBoolean(name, 0);
    }

    public Boolean getBoolean(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.getBoolean(index);
        }
        return null;
    }

    public Collection<Boolean> getAllBooleans(String name) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            int num = fieldInternal.getNumberOfValues();
            ArrayList<Boolean> values = new ArrayList<Boolean>(num);
            for (int i = 0; i < num; ++i) {
                values.add(fieldInternal.getBoolean(i));
            }
            return values;
        }
        return null;
    }

    public boolean isValidByte(String name) {
        return this.isValidByte(name, 0);
    }

    public boolean isValidByte(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.isValidByte(index);
        }
        return false;
    }

    public Byte getByte(String name) {
        return this.getByte(name, 0);
    }

    public Byte getByte(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.getByte(index);
        }
        return null;
    }

    public Collection<Byte> getAllBytes(String name) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            int num = fieldInternal.getNumberOfValues();
            ArrayList<Byte> values = new ArrayList<Byte>(num);
            for (int i = 0; i < num; ++i) {
                values.add(fieldInternal.getByte(i));
            }
            return values;
        }
        return null;
    }

    public byte[] getByteArray(String name) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            int num = fieldInternal.getNumberOfValues();
            byte[] values = new byte[num];
            for (int i = 0; i < num; ++i) {
                values[i] = fieldInternal.getByte(i);
            }
            return values;
        }
        return null;
    }

    public boolean isValidShort(String name) {
        return this.isValidShort(name, 0);
    }

    public boolean isValidShort(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.isValidShort(index);
        }
        return false;
    }

    public Short getShort(String name) {
        return this.getShort(name, 0);
    }

    public Short getShort(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.getShort(index);
        }
        return null;
    }

    public Collection<Short> getAllShorts(String name) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            int num = fieldInternal.getNumberOfValues();
            ArrayList<Short> values = new ArrayList<Short>(num);
            for (int i = 0; i < num; ++i) {
                values.add(fieldInternal.getShort(i));
            }
            return values;
        }
        return null;
    }

    public boolean isValidInteger(String name) {
        return this.isValidInteger(name, 0);
    }

    public boolean isValidInteger(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.isValidInteger(index);
        }
        return false;
    }

    public Integer getInteger(String name) {
        return this.getInteger(name, 0);
    }

    public Integer getInteger(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.getInteger(index);
        }
        return null;
    }

    public Collection<Integer> getAllIntegers(String name) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            int num = fieldInternal.getNumberOfValues();
            ArrayList<Integer> values = new ArrayList<Integer>(num);
            for (int i = 0; i < num; ++i) {
                values.add(fieldInternal.getInteger(i));
            }
            return values;
        }
        return null;
    }

    public boolean isValidBigInteger(String name) {
        return this.isValidBigInteger(name, 0);
    }

    public boolean isValidBigInteger(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.isValidInteger(index);
        }
        return false;
    }

    public BigInteger getBigInteger(String name) {
        return this.getBigInteger(name, 0);
    }

    public BigInteger getBigInteger(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.getBigInteger(index);
        }
        return null;
    }

    public Collection<BigInteger> getAllBigIntegers(String name) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            int num = fieldInternal.getNumberOfValues();
            ArrayList<BigInteger> values = new ArrayList<BigInteger>(num);
            for (int i = 0; i < num; ++i) {
                values.add(fieldInternal.getBigInteger(i));
            }
            return values;
        }
        return null;
    }

    public boolean isValidLong(String name) {
        return this.isValidLong(name, 0);
    }

    public boolean isValidLong(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.isValidLong(index);
        }
        return false;
    }

    public Long getLong(String name) {
        return this.getLong(name, 0);
    }

    public Long getLong(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.getLong(index);
        }
        return null;
    }

    public Collection<Long> getAllLongs(String name) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            int num = fieldInternal.getNumberOfValues();
            ArrayList<Long> values = new ArrayList<Long>(num);
            for (int i = 0; i < num; ++i) {
                values.add(fieldInternal.getLong(i));
            }
            return values;
        }
        return null;
    }

    public boolean isValidFloat(String name) {
        return this.isValidFloat(name, 0);
    }

    public boolean isValidFloat(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.isValidFloat(index);
        }
        return false;
    }

    public Float getFloat(String name) {
        return this.getFloat(name, 0);
    }

    public Float getFloat(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.getFloat(index);
        }
        return null;
    }

    public Collection<Float> getAllFloats(String name) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            int num = fieldInternal.getNumberOfValues();
            ArrayList<Float> values = new ArrayList<Float>(num);
            for (int i = 0; i < num; ++i) {
                values.add(fieldInternal.getFloat(i));
            }
            return values;
        }
        return null;
    }

    public boolean isValidDouble(String name) {
        return this.isValidDouble(name, 0);
    }

    public boolean isValidDouble(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.isValidDouble(index);
        }
        return false;
    }

    public Double getDouble(String name) {
        return this.getDouble(name, 0);
    }

    public Double getDouble(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.getDouble(index);
        }
        return null;
    }

    public Collection<Double> getAllDoubles(String name) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            int num = fieldInternal.getNumberOfValues();
            ArrayList<Double> values = new ArrayList<Double>(num);
            for (int i = 0; i < num; ++i) {
                values.add(fieldInternal.getDouble(i));
            }
            return values;
        }
        return null;
    }

    public boolean isValidBigDecimal(String name) {
        return this.isValidBigDecimal(name, 0);
    }

    public boolean isValidBigDecimal(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.isValidBigDecimal(index);
        }
        return false;
    }

    public BigDecimal getBigDecimal(String name) {
        return this.getBigDecimal(name, 0);
    }

    public BigDecimal getBigDecimal(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.getBigDecimal(index);
        }
        return null;
    }

    public Collection<BigDecimal> getAllBigDecimals(String name) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            int num = fieldInternal.getNumberOfValues();
            ArrayList<BigDecimal> values = new ArrayList<BigDecimal>(num);
            for (int i = 0; i < num; ++i) {
                values.add(fieldInternal.getBigDecimal(i));
            }
            return values;
        }
        return null;
    }

    public boolean isValidString(String name) {
        return this.isValidString(name, 0);
    }

    public boolean isValidString(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.isValidString(index);
        }
        return false;
    }

    public String getString(String name) {
        return this.getString(name, 0);
    }

    public String getString(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.getString(index);
        }
        return null;
    }

    public Collection<String> getAllStrings(String name) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            int num = fieldInternal.getNumberOfValues();
            ArrayList<String> values = new ArrayList<String>(num);
            for (int i = 0; i < num; ++i) {
                values.add(fieldInternal.getString(i));
            }
            return values;
        }
        return null;
    }

    public boolean isValidTime(String name) {
        return this.isValidTime(name, 0);
    }

    public boolean isValidTime(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.isValidTime(index);
        }
        return false;
    }

    public LocalTime getTime(String name) {
        return this.getTime(name, 0);
    }

    public LocalTime getTime(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.getTime(index);
        }
        return null;
    }

    public Collection<LocalTime> getAllTimes(String name) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            int num = fieldInternal.getNumberOfValues();
            ArrayList<LocalTime> values = new ArrayList<LocalTime>(num);
            for (int i = 0; i < num; ++i) {
                values.add(fieldInternal.getTime(i));
            }
            return values;
        }
        return null;
    }

    public boolean isValidDate(String name) {
        return this.isValidDate(name, 0);
    }

    public boolean isValidDate(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.isValidDate(index);
        }
        return false;
    }

    public LocalDate getDate(String name) {
        return this.getDate(name, 0);
    }

    public LocalDate getDate(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.getDate(index);
        }
        return null;
    }

    public Collection<LocalDate> getAllDates(String name) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            int num = fieldInternal.getNumberOfValues();
            ArrayList<LocalDate> values = new ArrayList<LocalDate>(num);
            for (int i = 0; i < num; ++i) {
                values.add(fieldInternal.getDate(i));
            }
            return values;
        }
        return null;
    }

    public boolean isValidDateTime(String name) {
        return this.isValidDateTime(name, 0);
    }

    public boolean isValidDateTime(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.isValidDateTime(index);
        }
        return false;
    }

    public LocalDateTime getDateTime(String name) {
        return this.getDateTime(name, 0);
    }

    public LocalDateTime getDateTime(String name, int index) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            return fieldInternal.getDateTime(index);
        }
        return null;
    }

    public Collection<LocalDateTime> getAllDateTimes(String name) {
        FieldItem fieldInternal = this.getFieldInternal(name);
        if (fieldInternal != null) {
            int num = fieldInternal.getNumberOfValues();
            ArrayList<LocalDateTime> values = new ArrayList<LocalDateTime>(num);
            for (int i = 0; i < num; ++i) {
                values.add(fieldInternal.getDateTime(i));
            }
            return values;
        }
        return null;
    }

    private FieldItem getFieldInternal(String name) {
        if (this.values.get(name) == null) {
            return null;
        }
        if (this.values.get(name).getKey() != PlcResponseCode.OK) {
            return null;
        }
        return (FieldItem)this.values.get(name).getValue();
    }
}

